/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal.invocation.processor;

import com.ibm.cics.server.internal.invocation.processor.AnnotatedMethod;
import com.ibm.cics.server.internal.invocation.processor.AnnotatedType;
import com.ibm.cics.server.internal.invocation.processor.AnnotationMetadataWriter;
import com.ibm.cics.server.internal.invocation.processor.ValidationException;
import com.ibm.cics.server.internal.invocation.processor.WriterException;
import com.ibm.cics.server.invocation.CICSProgram;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.ibm.cics.server.invocation.CICSProgram"})
public class AnnotationProcessor
extends AbstractProcessor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2016, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String CICS_PROGRAM_ANNOTATION = "com.ibm.cics.server.invocation.CICSProgram";
    private Messager messager;
    private static Logger logger = Logger.getLogger(AnnotationProcessor.class.getName());

    public AnnotationProcessor() {
        logger.fine("Created " + this.getClass());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        logger.fine("Initialised " + this.getClass());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        logger.finer("Processing " + annotations + " with environment " + roundEnv);
        HashMap<TypeElement, AnnotatedType> annotatedTypesByType = new HashMap<TypeElement, AnnotatedType>();
        for (Element element : roundEnv.getElementsAnnotatedWith(CICSProgram.class)) {
            logger.finer("Processing element " + element);
            try {
                AnnotatedMethod annotatedMethod = new AnnotatedMethod(element, this.processingEnv);
                try {
                    annotatedMethod.validateProgramName();
                }
                catch (ValidationException e) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, e.getMessage(), e.getElement(), e.getAnnotation(), e.getValue());
                }
                TypeElement enclosingTypeElement = annotatedMethod.getEnclosingTypeElement();
                AnnotatedType annotatedType = (AnnotatedType)annotatedTypesByType.get(enclosingTypeElement);
                if (annotatedType == null) {
                    annotatedType = new AnnotatedType(enclosingTypeElement);
                    annotatedTypesByType.put(enclosingTypeElement, annotatedType);
                }
                annotatedType.addMethod(annotatedMethod);
            }
            catch (ValidationException e) {
                logger.fine("Validation problem when processing element " + element + " " + e.getMessage());
                this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage(), e.getElement(), e.getAnnotation(), e.getValue());
            }
            logger.finer("Finished processing element " + element);
        }
        AnnotationMetadataWriter metadataWriter = new AnnotationMetadataWriter(this.processingEnv);
        for (AnnotatedType annotatedType : annotatedTypesByType.values()) {
            try {
                annotatedType.validate();
                metadataWriter.writeMetadata(annotatedType);
            }
            catch (ValidationException | WriterException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage(), e.getElement(), e.getAnnotation(), e.getValue());
            }
        }
        logger.finer("Finished processing " + annotations + " with environment " + roundEnv);
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    static {
        logger.setLevel(Level.ALL);
    }
}

