/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal.invocation.processor;

import com.ibm.cics.server.internal.invocation.processor.AnnotatedMethod;
import com.ibm.cics.server.internal.invocation.processor.AnnotatedType;
import com.ibm.cics.server.internal.invocation.processor.Messages;
import com.ibm.cics.server.invocation.CICSProgram;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class ClassGenerator
implements Opcodes {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2016, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TEMPLATE_FOLDER = "com/ibm/cics/server/invocation/template";
    private static final String BEAN_NAME_PREFIX = "LinkBean_";
    public static final String TEMPLATE_INSTANCE_TYPE = "com/ibm/cics/server/invocation/template/InstanceInvocationProxyTemplate";
    public static final String TEMPLATE_STATIC_TYPE = "com/ibm/cics/server/invocation/template/StaticInvocationProxyTemplate";
    public static final String TEMPLATE_SPRING_TYPE = "com/ibm/cics/server/invocation/template/SpringBeanInvocationProxyTemplate";
    private static final String TEMPLATE_PLACEHOLDER_TYPE = "com/ibm/cics/server/invocation/template/UserClass";
    private static final String TEMPLATE_STATIC_METHOD_PLACEHOLDER = "staticMethod";
    private static final String TEMPLATE_INSTANCE_METHOD_PLACEHOLDER = "instanceMethod";
    private static final String TEMPLATE_CONTAINING_METHOD = "doInvoke";
    private static final String TEMPLATE_TARGET_FIELD = "autowiredObject";
    private final AnnotatedMethod annotatedMethod;
    private final AnnotatedType annotatedType;
    private String destPackage;
    private static Logger logger = Logger.getLogger(ClassGenerator.class.getName());

    public ClassGenerator(AnnotatedMethod annotatedMethod, AnnotatedType annotatedType) {
        this.annotatedMethod = annotatedMethod;
        this.annotatedType = annotatedType;
    }

    private String getClassName() {
        return this.annotatedType.getType().getQualifiedName().toString();
    }

    private String getMethodName() {
        return this.annotatedMethod.getAnnotatedMethodElement().getSimpleName().toString();
    }

    private boolean isStatic() {
        return this.annotatedMethod.isStaticMethod();
    }

    public byte[] generate(String string) throws IOException {
        int n;
        this.destPackage = string;
        String string2 = this.chooseTemplateType();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return this.generate(byteArrayOutputStream.toByteArray());
    }

    private String chooseTemplateType() {
        String string = null;
        string = this.annotatedMethod.getTargetType() == CICSProgram.TargetType.SPRINGBEAN ? TEMPLATE_SPRING_TYPE : (this.isStatic() ? TEMPLATE_STATIC_TYPE : TEMPLATE_INSTANCE_TYPE);
        string = string + ".class";
        return string;
    }

    private byte[] generate(byte[] byArray) throws IOException {
        ClassReader classReader = new ClassReader(byArray);
        ClassWriter classWriter = new ClassWriter(1);
        ClassRemapper classRemapper = new ClassRemapper(new ClassModifyingVisitor(327680, classWriter, this.getClassName().replace('.', '/'), this.getMethodName()), new TemplateRemapper());
        classReader.accept(classRemapper, 0);
        return classWriter.toByteArray();
    }

    private String getNewClassName() {
        return this.getNewFullyQualifiedClassName(this.annotatedMethod.getUUID());
    }

    public String getNewFullyQualifiedClassName(String string) {
        return this.destPackage.replace('.', '/') + "/" + ClassGenerator.getNewSimpleClassName(string);
    }

    public static String getNewSimpleClassName(String string) {
        return BEAN_NAME_PREFIX + string;
    }

    static {
        logger.setLevel(Level.ALL);
    }

    private final class ClassModifyingVisitor
    extends ClassVisitor {
        private final String className;
        private final String targetClassDescriptor;
        private final String methodName;

        private ClassModifyingVisitor(int n, ClassVisitor classVisitor, String string, String string2) {
            super(n, classVisitor);
            this.className = string;
            this.targetClassDescriptor = "L" + string + ";";
            this.methodName = string2;
        }

        @Override
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            MethodVisitor methodVisitor = super.visitMethod(n, string, string2, string3, stringArray);
            if (ClassGenerator.TEMPLATE_CONTAINING_METHOD.equals(string)) {
                logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__ALTERING_METHOD"), ClassGenerator.TEMPLATE_CONTAINING_METHOD));
                if (ClassGenerator.this.annotatedMethod.getTargetType() == CICSProgram.TargetType.SPRINGBEAN) {
                    methodVisitor = new SpringDoInvokeMethodVisitor(this.api, methodVisitor);
                }
                methodVisitor = ClassGenerator.this.isStatic() ? new StaticMethodVisitor(this.api, methodVisitor) : new InstanceMethodVisitor(this.api, methodVisitor);
            }
            return methodVisitor;
        }

        @Override
        public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
            if (string.equals(ClassGenerator.TEMPLATE_TARGET_FIELD)) {
                return super.visitField(n, string, this.targetClassDescriptor, string3, object);
            }
            return super.visitField(n, string, string2, string3, object);
        }

        private final class SpringDoInvokeMethodVisitor
        extends MethodVisitor {
            public SpringDoInvokeMethodVisitor(int n, MethodVisitor methodVisitor) {
                super(n, methodVisitor);
            }

            @Override
            public void visitFieldInsn(int n, String string, String string2, String string3) {
                if (string2.equals(ClassGenerator.TEMPLATE_TARGET_FIELD)) {
                    super.visitFieldInsn(n, string, string2, ClassModifyingVisitor.this.targetClassDescriptor);
                } else {
                    super.visitFieldInsn(n, string, string2, string3);
                }
            }
        }

        private final class StaticMethodVisitor
        extends MethodVisitor {
            private StaticMethodVisitor(int n, MethodVisitor methodVisitor) {
                super(n, methodVisitor);
            }

            @Override
            public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
                if (n == 184 && ClassGenerator.TEMPLATE_PLACEHOLDER_TYPE.equals(string) && ClassGenerator.TEMPLATE_STATIC_METHOD_PLACEHOLDER.equals(string2) && "()V".equals(string3)) {
                    logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_STATIC_METHOD_CALL"), ClassGenerator.TEMPLATE_PLACEHOLDER_TYPE, ClassGenerator.TEMPLATE_STATIC_METHOD_PLACEHOLDER, ClassModifyingVisitor.this.className, ClassModifyingVisitor.this.methodName));
                    this.visitMethodInsn(n, ClassModifyingVisitor.this.className, ClassModifyingVisitor.this.methodName, string3, false);
                } else {
                    super.visitMethodInsn(n, string, string2, string3, bl);
                }
            }
        }

        private final class InstanceMethodVisitor
        extends MethodVisitor {
            private InstanceMethodVisitor(int n, MethodVisitor methodVisitor) {
                super(n, methodVisitor);
            }

            @Override
            public void visitTypeInsn(int n, String string) {
                if (n == 187 && ClassGenerator.TEMPLATE_PLACEHOLDER_TYPE.equals(string)) {
                    logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_NEW_TYPE"), ClassGenerator.TEMPLATE_PLACEHOLDER_TYPE, ClassModifyingVisitor.this.className));
                    string = ClassModifyingVisitor.this.className;
                }
                super.visitTypeInsn(n, string);
            }

            @Override
            public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
                if (n == 183 && ClassGenerator.TEMPLATE_PLACEHOLDER_TYPE.equals(string) && "<init>".equals(string2) && "()V".equals(string3)) {
                    logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_CONSTRUCTOR"), ClassGenerator.TEMPLATE_PLACEHOLDER_TYPE, ClassModifyingVisitor.this.className));
                    this.visitMethodInsn(n, ClassModifyingVisitor.this.className, string2, string3, false);
                } else if (n == 182 && ClassGenerator.TEMPLATE_PLACEHOLDER_TYPE.equals(string) && ClassGenerator.TEMPLATE_INSTANCE_METHOD_PLACEHOLDER.equals(string2) && "()V".equals(string3)) {
                    logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_INSTANCE_METHOD_CALL"), ClassGenerator.TEMPLATE_PLACEHOLDER_TYPE, ClassGenerator.TEMPLATE_INSTANCE_METHOD_PLACEHOLDER, ClassModifyingVisitor.this.className, ClassModifyingVisitor.this.methodName));
                    this.visitMethodInsn(n, ClassModifyingVisitor.this.className, ClassModifyingVisitor.this.methodName, string3, false);
                } else {
                    super.visitMethodInsn(n, string, string2, string3, bl);
                }
            }
        }
    }

    private final class TemplateRemapper
    extends Remapper {
        private TemplateRemapper() {
        }

        @Override
        public String map(String string) {
            if (ClassGenerator.TEMPLATE_INSTANCE_TYPE.equals(string)) {
                logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_TYPE"), ClassGenerator.TEMPLATE_INSTANCE_TYPE, ClassGenerator.this.getNewClassName()));
                return ClassGenerator.this.getNewClassName();
            }
            if (ClassGenerator.TEMPLATE_STATIC_TYPE.equals(string)) {
                logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_TYPE"), ClassGenerator.TEMPLATE_STATIC_TYPE, ClassGenerator.this.getNewClassName()));
                return ClassGenerator.this.getNewClassName();
            }
            if (ClassGenerator.TEMPLATE_SPRING_TYPE.equals(string)) {
                logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_TYPE"), ClassGenerator.TEMPLATE_SPRING_TYPE, ClassGenerator.this.getNewClassName()));
                return ClassGenerator.this.getNewClassName();
            }
            return string;
        }
    }
}

