/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal.invocation.processor;

import com.ibm.cics.server.internal.invocation.processor.Messages;
import com.ibm.cics.server.internal.invocation.processor.ValidationException;
import com.ibm.cics.server.invocation.CICSProgram;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementKindVisitor7;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.springframework.stereotype.Component;

public class AnnotatedMethod {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM @PID###@ (c) Copyright IBM Corp. 2016, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final SecureRandom generator = new SecureRandom();
    private static final String PROGRAM_NAME_PATTERN = "[A-Za-z0-9$@#]+";
    private static final String CICS_RESERVED_PREFIX = "DFH";
    public static final Class<CICSProgram> ANNOTATION_CLASS = CICSProgram.class;
    public static final String PROGRAM_NAME_ANNOTATION_VALUE = "value";
    private static final String TARGET_TYPE_ANNOTATION_VALUE = "targetType";
    private static final String ERROR__ANNOTATION__DISALLOWED_LOCATION = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__DISALLOWED_LOCATION"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__METHOD_NOT_PUBLIC = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__METHOD_NOT_PUBLIC"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__METHOD_NOT_CONCRETE = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__METHOD_NOT_CONCRETE"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__METHOD_HAS_ARGS = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__METHOD_HAS_ARGS"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__TYPE_NOT_TOP_LEVEL = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__TYPE_NOT_TOP_LEVEL"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__TYPE_MISSING_NO_ARGS_CONSTRUCTOR = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__TYPE_MISSING_NO_ARGS_CONSTRUCTOR"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__METHOD_NOT_VOID = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__METHOD_NOT_VOID"), CICSProgram.class.getSimpleName());
    private final ExecutableElement annotatedMethodElement;
    private final String programName;
    private final byte[] uuid;
    private ProcessingEnvironment processingEnv;
    private CICSProgram.TargetType targetType;

    public AnnotatedMethod(Element annotatedElement, ProcessingEnvironment processingEnv) throws ValidationException {
        this.processingEnv = processingEnv;
        this.annotatedMethodElement = (ExecutableElement)annotatedElement;
        CICSProgram annotation = this.annotatedMethodElement.getAnnotation(ANNOTATION_CLASS);
        this.targetType = this.determineTargetType(annotation);
        this.programName = annotation.value();
        this.uuid = new byte[16];
        generator.nextBytes(this.uuid);
        this.prepareAnnotatedElementSave(annotatedElement);
        this.prepareProgramNameSave(this.programName);
    }

    private CICSProgram.TargetType determineTargetType(CICSProgram annotation) {
        CICSProgram.TargetType result = annotation.targetType();
        String annotationType = "";
        if (this.classHasSpringComponentAnnotation()) {
            annotationType = Component.class.getSimpleName();
            result = CICSProgram.TargetType.SPRINGBEAN;
        }
        for (AnnotationMirror annotationMirror : this.annotatedMethodElement.getEnclosingElement().getAnnotationMirrors()) {
            if (annotationMirror.getAnnotationType().asElement().getAnnotation(Component.class) == null) continue;
            annotationType = annotationMirror.getAnnotationType().asElement().getSimpleName().toString();
            result = CICSProgram.TargetType.SPRINGBEAN;
        }
        if (this.springBeanHasTargetTypePojo(annotation, result)) {
            AnnotationMirror annotationMirror = AnnotatedMethod.retrieveAnnotationMirror(this.annotatedMethodElement, ANNOTATION_CLASS);
            AnnotationValue annotationValue = AnnotatedMethod.retrieveAnnotationValue(annotationMirror, TARGET_TYPE_ANNOTATION_VALUE);
            String message = MessageFormat.format(Messages.getString("AnnotatedMethod.WARNING__TARGETTPE__SPRINGBEAN_ASSUMED"), annotationType);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, this.annotatedMethodElement, annotationMirror, annotationValue);
        }
        if (result == CICSProgram.TargetType.UNSPECIFIED) {
            result = CICSProgram.TargetType.POJO;
        }
        return result;
    }

    private boolean springBeanHasTargetTypePojo(CICSProgram annotation, CICSProgram.TargetType result) {
        return annotation.targetType() == CICSProgram.TargetType.POJO && result == CICSProgram.TargetType.SPRINGBEAN;
    }

    private boolean classHasSpringComponentAnnotation() {
        return this.annotatedMethodElement.getEnclosingElement().getAnnotation(Component.class) != null;
    }

    private void prepareAnnotatedElementSave(Element annotatedElement) throws ValidationException {
        AnnotationMirror annotationMirror = AnnotatedMethod.retrieveAnnotationMirror(annotatedElement, ANNOTATION_CLASS);
        this.validateAnnotationIsOnMethod(annotatedElement, annotationMirror);
        ExecutableElement methodElement = (ExecutableElement)annotatedElement;
        this.validateMethodIsPublic(methodElement, annotationMirror);
        this.validateMethodIsConcrete(methodElement, annotationMirror);
        this.validateMethodIsNotNested(methodElement, annotationMirror);
        this.validateMethodHasNoArgs(methodElement, annotationMirror);
        this.validateMethodHasVoidReturnType(methodElement, annotationMirror);
        if (!this.isStaticMethod(methodElement)) {
            this.validateClassHasNoArgsConstructor(methodElement, annotationMirror);
        }
    }

    private boolean isStaticMethod(ExecutableElement methodElement) {
        return methodElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    private void validateClassHasNoArgsConstructor(ExecutableElement methodElement, AnnotationMirror annotationMirror) throws ValidationException {
        if (this.targetType == CICSProgram.TargetType.SPRINGBEAN) {
            return;
        }
        TypeElement typeElement = (TypeElement)methodElement.getEnclosingElement();
        NoArgsConstructorDetectionResult constructorDetectionResult = new NoArgsConstructorDetectionResult();
        typeElement.accept(new NoArgsDetectionVisitor(), constructorDetectionResult);
        if (constructorDetectionResult.isConstructorDefined() && !constructorDetectionResult.isNoArgConstructorDefined()) {
            throw new ValidationException(ValidationException.Type.CLASS_MISSING_NO_ARGS_CONSTRUCTOR, ERROR__ANNOTATION__TYPE_MISSING_NO_ARGS_CONSTRUCTOR, methodElement, annotationMirror);
        }
    }

    private void validateMethodHasNoArgs(ExecutableElement methodElement, AnnotationMirror annotationMirror) throws ValidationException {
        if (!methodElement.getParameters().isEmpty()) {
            throw new ValidationException(ValidationException.Type.METHOD_HAS_ARGS, ERROR__ANNOTATION__METHOD_HAS_ARGS, methodElement, annotationMirror);
        }
    }

    private void validateMethodIsNotNested(ExecutableElement methodElement, AnnotationMirror annotationMirror) throws ValidationException {
        Element enclosingElement = methodElement.getEnclosingElement();
        if (!(enclosingElement instanceof TypeElement) || ((TypeElement)enclosingElement).getNestingKind().isNested()) {
            throw new ValidationException(ValidationException.Type.CLASS_IS_NESTED, ERROR__ANNOTATION__TYPE_NOT_TOP_LEVEL, methodElement, annotationMirror);
        }
    }

    private void validateMethodIsPublic(ExecutableElement methodElement, AnnotationMirror annotationMirror) throws ValidationException {
        if (!methodElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ValidationException(ValidationException.Type.METHOD_NOT_PUBLIC, ERROR__ANNOTATION__METHOD_NOT_PUBLIC, methodElement, annotationMirror);
        }
    }

    private void validateMethodIsConcrete(ExecutableElement methodElement, AnnotationMirror annotationMirror) throws ValidationException {
        if (methodElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ValidationException(ValidationException.Type.METHOD_NOT_CONCRETE, ERROR__ANNOTATION__METHOD_NOT_CONCRETE, methodElement, annotationMirror);
        }
    }

    private void validateMethodHasVoidReturnType(ExecutableElement methodElement, AnnotationMirror annotationMirror) throws ValidationException {
        Types typeUtils = this.processingEnv.getTypeUtils();
        if (!typeUtils.isSameType(methodElement.getReturnType(), typeUtils.getNoType(TypeKind.VOID))) {
            throw new ValidationException(ValidationException.Type.METHOD_HAS_NON_VOID_RETURN_TYPE, ERROR__ANNOTATION__METHOD_NOT_VOID, methodElement, annotationMirror);
        }
    }

    private void validateAnnotationIsOnMethod(Element annotatedElement, AnnotationMirror annotationMirror) throws ValidationException {
        if (annotatedElement.getKind() != ElementKind.METHOD) {
            throw new ValidationException(ValidationException.Type.ANNOTATION_NOT_ON_METHOD, ERROR__ANNOTATION__DISALLOWED_LOCATION, annotatedElement, annotationMirror);
        }
    }

    private void prepareProgramNameSave(String programName) throws ValidationException {
        AnnotationMirror annotationMirror = AnnotatedMethod.retrieveAnnotationMirror(this.annotatedMethodElement, ANNOTATION_CLASS);
        AnnotationValue programAnnotationValue = AnnotatedMethod.retrieveAnnotationValue(annotationMirror, PROGRAM_NAME_ANNOTATION_VALUE);
        if (programName == null) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_MISSING, Messages.getString("AnnotatedMethod.ERROR__PROGRAM_NAME_MISSING"), this.annotatedMethodElement, annotationMirror, programAnnotationValue);
        }
        if (programName.isEmpty()) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_BAD_LENGTH, Messages.getString("AnnotatedMethod.ERROR__PROGRAM_NAME__LENGTH"), this.annotatedMethodElement, annotationMirror, programAnnotationValue);
        }
        if (programName.length() > 8) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_BAD_LENGTH, Messages.getString("AnnotatedMethod.ERROR__PROGRAM_NAME__LENGTH"), this.annotatedMethodElement, annotationMirror, programAnnotationValue);
        }
        if (!programName.matches(PROGRAM_NAME_PATTERN)) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_BAD_CHARS, Messages.getString("AnnotatedMethod.ERROR__PROGRAM_NAME__PERMITTED_CHARACTERS"), this.annotatedMethodElement, annotationMirror, programAnnotationValue);
        }
    }

    public void validateProgramName() throws ValidationException {
        AnnotationMirror annotationMirror = AnnotatedMethod.retrieveAnnotationMirror(this.annotatedMethodElement, ANNOTATION_CLASS);
        AnnotationValue programAnnotationValue = AnnotatedMethod.retrieveAnnotationValue(annotationMirror, PROGRAM_NAME_ANNOTATION_VALUE);
        if (this.programName.startsWith(CICS_RESERVED_PREFIX)) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_RESERVED_FOR_CICS, MessageFormat.format(Messages.getString("AnnotatedMethod.WARNING__PROGRAM_NAME__CICS_RESERVED_PREFIX"), CICS_RESERVED_PREFIX), this.annotatedMethodElement, annotationMirror, programAnnotationValue);
        }
    }

    public static AnnotationMirror retrieveAnnotationMirror(Element annotatedElement, Class<?> annotationClass) {
        List<? extends AnnotationMirror> annotationMirrors = annotatedElement.getAnnotationMirrors();
        AnnotationMirror annotationMirror = null;
        for (AnnotationMirror annotationMirror2 : annotationMirrors) {
            if (!((TypeElement)annotationMirror2.getAnnotationType().asElement()).getQualifiedName().contentEquals(annotationClass.getCanonicalName())) continue;
            annotationMirror = annotationMirror2;
            break;
        }
        return annotationMirror;
    }

    public static AnnotationValue retrieveAnnotationValue(AnnotationMirror annotationMirror, String valueName) {
        AnnotationValue programAnnotationValue = null;
        if (annotationMirror != null) {
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!executableElement.getSimpleName().contentEquals(valueName)) continue;
                programAnnotationValue = annotationMirror.getElementValues().get(executableElement);
                break;
            }
        }
        return programAnnotationValue;
    }

    public TypeElement getEnclosingTypeElement() {
        return (TypeElement)this.annotatedMethodElement.getEnclosingElement();
    }

    public boolean isStaticMethod() {
        return this.isStaticMethod(this.annotatedMethodElement);
    }

    public ExecutableElement getAnnotatedMethodElement() {
        return this.annotatedMethodElement;
    }

    public String getProgramName() {
        return this.programName;
    }

    public String getUUID() {
        StringBuilder builder = new StringBuilder();
        for (byte b : this.uuid) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    public CICSProgram.TargetType getTargetType() {
        return this.targetType;
    }

    private class NoArgsConstructorDetectionResult {
        private boolean constructorDefined = false;
        private boolean noArgConstructorDefined = false;

        private NoArgsConstructorDetectionResult() {
        }

        public void foundConstructor() {
            this.constructorDefined = true;
        }

        public void foundNoArgsConstructor() {
            this.constructorDefined = true;
            this.noArgConstructorDefined = true;
        }

        public boolean isConstructorDefined() {
            return this.constructorDefined;
        }

        public boolean isNoArgConstructorDefined() {
            return this.noArgConstructorDefined;
        }
    }

    private final class NoArgsDetectionVisitor
    extends ElementKindVisitor7<Void, NoArgsConstructorDetectionResult> {
        private NoArgsDetectionVisitor() {
        }

        @Override
        public Void visitType(TypeElement e, NoArgsConstructorDetectionResult p) {
            for (Element element : e.getEnclosedElements()) {
                if (p.isNoArgConstructorDefined()) break;
                if (!(element instanceof ExecutableElement)) continue;
                element.accept(this, p);
            }
            return null;
        }

        @Override
        public Void visitExecutableAsConstructor(ExecutableElement e, NoArgsConstructorDetectionResult p) {
            if (e.getParameters().isEmpty()) {
                p.foundNoArgsConstructor();
            } else {
                p.foundConstructor();
            }
            return null;
        }
    }
}

