/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal.invocation.processor;

import com.ibm.cics.server.internal.invocation.processor.AnnotatedMethod;
import com.ibm.cics.server.internal.invocation.processor.AnnotatedType;
import com.ibm.cics.server.internal.invocation.processor.ClassGenerator;
import com.ibm.cics.server.internal.invocation.processor.LinkableTargetMetadataBuilder;
import com.ibm.cics.server.internal.invocation.processor.Messages;
import com.ibm.cics.server.internal.invocation.processor.WriterException;
import com.ibm.cics.server.invocation.CICSProgram;
import com.ibm.cics.server.invocation.binding.LinkableTargetMetadata;
import com.ibm.cics.server.invocation.binding.LinkableTargets;
import com.ibm.cics.server.invocation.binding.ObjectFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class AnnotationMetadataWriter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM @PID###@ (c) Copyright IBM Corp. 2016, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String METADATA_PACKAGE = "com.ibm.cics.server.invocation.metadata";
    private static final String PROXY_PACKAGE = "com.ibm.cics.server.invocation.proxy";
    private static final String METADATA_EXTENSION = "xml";
    private static final String PROXY_EXTENSION = "class";
    private ProcessingEnvironment processingEnv;
    private LinkableTargetMetadataBuilder metadataBuilder;

    public AnnotationMetadataWriter(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.metadataBuilder = new LinkableTargetMetadataBuilder();
    }

    public AnnotationMetadataWriter(ProcessingEnvironment env, LinkableTargetMetadataBuilder builder) {
        this.processingEnv = env;
        this.metadataBuilder = builder;
    }

    public void writeMetadata(AnnotatedType annotatedType) throws WriterException {
        String typeName = annotatedType.getType().getQualifiedName().toString();
        List<AnnotatedMethod> annotatedMethods = annotatedType.getMethods();
        Element[] originatingElements = new ExecutableElement[annotatedMethods.size()];
        for (int i = 0; i < annotatedMethods.size(); ++i) {
            originatingElements[i] = annotatedMethods.get(i).getAnnotatedMethodElement();
        }
        try {
            FileObject resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, METADATA_PACKAGE, this.generateMetadataFileName(typeName), originatingElements);
            ObjectFactory factory = new ObjectFactory();
            LinkableTargets linkableTargets = factory.createLinkableTargets();
            List<LinkableTargetMetadata> linkableTargetMetadata = linkableTargets.getLinkableTargetMetadata();
            for (AnnotatedMethod annotatedMethod : annotatedMethods) {
                linkableTargetMetadata.add(this.metadataBuilder.buildMetadataFor(typeName, annotatedMethod));
                this.createProxyClass(annotatedMethod, annotatedType, (ExecutableElement[])originatingElements);
            }
            JAXBContext jc = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName(), (ClassLoader)ObjectFactory.class.getClassLoader());
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            try (Writer writer = resource.openWriter();){
                m.marshal((Object)linkableTargets, writer);
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
            String message = MessageFormat.format(Messages.getString("AnnotationMetadataWriter.ERROR__WRITE"), CICSProgram.class.getSimpleName());
            throw new WriterException(message, annotatedType.getType());
        }
        catch (IOException e) {
            e.printStackTrace();
            String message = MessageFormat.format(Messages.getString("AnnotationMetadataWriter.ERROR__WRITE"), CICSProgram.class.getSimpleName());
            throw new WriterException(message, annotatedType.getType());
        }
    }

    private void createProxyClass(AnnotatedMethod annotatedMethod, AnnotatedType annotatedType, ExecutableElement[] originatingElements) throws IOException {
        FileObject resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, this.destinationPackage(annotatedMethod, annotatedType), this.generateProxyFileName(annotatedMethod.getUUID()), originatingElements);
        try (OutputStream os = resource.openOutputStream();){
            os.write(new ClassGenerator(annotatedMethod, annotatedType).generate(this.destinationPackage(annotatedMethod, annotatedType)));
        }
    }

    private String destinationPackage(AnnotatedMethod annotatedMethod, AnnotatedType annotatedType) {
        String destPackage = PROXY_PACKAGE;
        if (annotatedMethod.getTargetType() == CICSProgram.TargetType.SPRINGBEAN) {
            destPackage = this.processingEnv.getElementUtils().getPackageOf(annotatedType.getType()).getQualifiedName().toString();
            if (!destPackage.equals("")) {
                destPackage = destPackage + ".";
            }
            destPackage = destPackage + "cics.proxy";
        }
        return destPackage;
    }

    private String generateMetadataFileName(String typeName) {
        return typeName + "." + METADATA_EXTENSION;
    }

    private String generateProxyFileName(String uuid) {
        return ClassGenerator.getNewSimpleClassName(uuid) + "." + PROXY_EXTENSION;
    }
}

