/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal.invocation.processor;

import com.ibm.cics.server.internal.invocation.processor.AnnotatedMethod;
import com.ibm.cics.server.internal.invocation.processor.AnnotatedType;
import com.ibm.cics.server.internal.invocation.processor.Messages;
import com.ibm.cics.server.invocation.CICSProgram;
import com.ibm.cics.server.invocation.processor.org.objectweb.asm.ClassReader;
import com.ibm.cics.server.invocation.processor.org.objectweb.asm.ClassVisitor;
import com.ibm.cics.server.invocation.processor.org.objectweb.asm.ClassWriter;
import com.ibm.cics.server.invocation.processor.org.objectweb.asm.FieldVisitor;
import com.ibm.cics.server.invocation.processor.org.objectweb.asm.MethodVisitor;
import com.ibm.cics.server.invocation.processor.org.objectweb.asm.Opcodes;
import com.ibm.cics.server.invocation.processor.org.objectweb.asm.Type;
import com.ibm.cics.server.invocation.processor.org.objectweb.asm.commons.ClassRemapper;
import com.ibm.cics.server.invocation.processor.org.objectweb.asm.commons.Remapper;
import com.ibm.cics.server.invocation.template.InstanceInvocationProxyTemplate;
import com.ibm.cics.server.invocation.template.SpringBeanInvocationProxyTemplate;
import com.ibm.cics.server.invocation.template.StaticInvocationProxyTemplate;
import com.ibm.cics.server.invocation.template.UserClass;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassGenerator
implements Opcodes {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM @PID###@ (c) Copyright IBM Corp. 2016, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String BEAN_NAME_PREFIX = "LinkBean_";
    public static final String TEMPLATE_INSTANCE_TYPE = Type.getInternalName(InstanceInvocationProxyTemplate.class);
    public static final String TEMPLATE_STATIC_TYPE = Type.getInternalName(StaticInvocationProxyTemplate.class);
    public static final String TEMPLATE_SPRING_TYPE = Type.getInternalName(SpringBeanInvocationProxyTemplate.class);
    private static final String TEMPLATE_PLACEHOLDER_TYPE = Type.getInternalName(UserClass.class);
    private static final String TEMPLATE_STATIC_METHOD_PLACEHOLDER = "staticMethod";
    private static final String TEMPLATE_INSTANCE_METHOD_PLACEHOLDER = "instanceMethod";
    private static final String TEMPLATE_CONTAINING_METHOD = "doInvoke";
    private static final String TEMPLATE_TARGET_FIELD = "autowiredObject";
    private final AnnotatedMethod annotatedMethod;
    private final AnnotatedType annotatedType;
    private String destPackage;
    private static Logger logger = Logger.getLogger(ClassGenerator.class.getName());

    public ClassGenerator(AnnotatedMethod annotatedMethod, AnnotatedType annotatedType) {
        this.annotatedMethod = annotatedMethod;
        this.annotatedType = annotatedType;
    }

    private String getClassName() {
        return this.annotatedType.getType().getQualifiedName().toString();
    }

    private String getMethodName() {
        return this.annotatedMethod.getAnnotatedMethodElement().getSimpleName().toString();
    }

    private boolean isStatic() {
        return this.annotatedMethod.isStaticMethod();
    }

    public byte[] generate(String destPackage) throws IOException {
        int c;
        this.destPackage = destPackage;
        String templateType = this.chooseTemplateType();
        InputStream templateStream = this.getClass().getClassLoader().getResourceAsStream(templateType);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = templateStream.read()) != -1) {
            baos.write(c);
        }
        return this.generate(baos.toByteArray());
    }

    private String chooseTemplateType() {
        String templateType = null;
        templateType = this.annotatedMethod.getTargetType() == CICSProgram.TargetType.SPRINGBEAN ? Type.getInternalName(SpringBeanInvocationProxyTemplate.class) : (this.isStatic() ? TEMPLATE_STATIC_TYPE : TEMPLATE_INSTANCE_TYPE);
        templateType = templateType + ".class";
        return templateType;
    }

    private byte[] generate(byte[] input) throws IOException {
        ClassReader classReader = new ClassReader(input);
        ClassWriter classWriter = new ClassWriter(1);
        ClassRemapper classModifier = new ClassRemapper(new ClassModifyingVisitor(327680, classWriter, this.getClassName().replace('.', '/'), this.getMethodName()), new TemplateRemapper());
        classReader.accept(classModifier, 0);
        return classWriter.toByteArray();
    }

    private String getNewClassName() {
        return this.getNewFullyQualifiedClassName(this.annotatedMethod.getUUID());
    }

    public String getNewFullyQualifiedClassName(String uuid) {
        return this.destPackage.replace('.', '/') + "/" + ClassGenerator.getNewSimpleClassName(uuid);
    }

    public static String getNewSimpleClassName(String uuid) {
        return BEAN_NAME_PREFIX + uuid;
    }

    static {
        logger.setLevel(Level.ALL);
    }

    private final class ClassModifyingVisitor
    extends ClassVisitor {
        private final String className;
        private final String targetClassDescriptor;
        private final String methodName;

        private ClassModifyingVisitor(int api, ClassVisitor cv, String className, String methodName) {
            super(api, cv);
            this.className = className;
            this.targetClassDescriptor = "L" + className + ";";
            this.methodName = methodName;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            if (ClassGenerator.TEMPLATE_CONTAINING_METHOD.equals(name)) {
                logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__ALTERING_METHOD"), ClassGenerator.TEMPLATE_CONTAINING_METHOD));
                if (ClassGenerator.this.annotatedMethod.getTargetType() == CICSProgram.TargetType.SPRINGBEAN) {
                    methodVisitor = new SpringDoInvokeMethodVisitor(this.api, methodVisitor);
                }
                methodVisitor = ClassGenerator.this.isStatic() ? new StaticMethodVisitor(this.api, methodVisitor) : new InstanceMethodVisitor(this.api, methodVisitor);
            }
            return methodVisitor;
        }

        @Override
        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            if (name.equals(ClassGenerator.TEMPLATE_TARGET_FIELD)) {
                return super.visitField(access, name, this.targetClassDescriptor, signature, value);
            }
            return super.visitField(access, name, descriptor, signature, value);
        }

        private final class SpringDoInvokeMethodVisitor
        extends MethodVisitor {
            public SpringDoInvokeMethodVisitor(int api, MethodVisitor mv) {
                super(api, mv);
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                if (name.equals(ClassGenerator.TEMPLATE_TARGET_FIELD)) {
                    super.visitFieldInsn(opcode, owner, name, ClassModifyingVisitor.this.targetClassDescriptor);
                } else {
                    super.visitFieldInsn(opcode, owner, name, descriptor);
                }
            }
        }

        private final class StaticMethodVisitor
        extends MethodVisitor {
            private StaticMethodVisitor(int api, MethodVisitor mv) {
                super(api, mv);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 184 && TEMPLATE_PLACEHOLDER_TYPE.equals(owner) && ClassGenerator.TEMPLATE_STATIC_METHOD_PLACEHOLDER.equals(name) && "()V".equals(desc)) {
                    logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_STATIC_METHOD_CALL"), TEMPLATE_PLACEHOLDER_TYPE, ClassGenerator.TEMPLATE_STATIC_METHOD_PLACEHOLDER, ClassModifyingVisitor.this.className, ClassModifyingVisitor.this.methodName));
                    this.visitMethodInsn(opcode, ClassModifyingVisitor.this.className, ClassModifyingVisitor.this.methodName, desc, false);
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }
        }

        private final class InstanceMethodVisitor
        extends MethodVisitor {
            private InstanceMethodVisitor(int api, MethodVisitor mv) {
                super(api, mv);
            }

            @Override
            public void visitTypeInsn(int opcode, String type) {
                if (opcode == 187 && TEMPLATE_PLACEHOLDER_TYPE.equals(type)) {
                    logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_NEW_TYPE"), TEMPLATE_PLACEHOLDER_TYPE, ClassModifyingVisitor.this.className));
                    type = ClassModifyingVisitor.this.className;
                }
                super.visitTypeInsn(opcode, type);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 183 && TEMPLATE_PLACEHOLDER_TYPE.equals(owner) && "<init>".equals(name) && "()V".equals(desc)) {
                    logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_CONSTRUCTOR"), TEMPLATE_PLACEHOLDER_TYPE, ClassModifyingVisitor.this.className));
                    this.visitMethodInsn(opcode, ClassModifyingVisitor.this.className, name, desc, false);
                } else if (opcode == 182 && TEMPLATE_PLACEHOLDER_TYPE.equals(owner) && ClassGenerator.TEMPLATE_INSTANCE_METHOD_PLACEHOLDER.equals(name) && "()V".equals(desc)) {
                    logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_INSTANCE_METHOD_CALL"), TEMPLATE_PLACEHOLDER_TYPE, ClassGenerator.TEMPLATE_INSTANCE_METHOD_PLACEHOLDER, ClassModifyingVisitor.this.className, ClassModifyingVisitor.this.methodName));
                    this.visitMethodInsn(opcode, ClassModifyingVisitor.this.className, ClassModifyingVisitor.this.methodName, desc, false);
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }
        }
    }

    private final class TemplateRemapper
    extends Remapper {
        private TemplateRemapper() {
        }

        @Override
        public String map(String typeName) {
            if (TEMPLATE_INSTANCE_TYPE.equals(typeName)) {
                logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_TYPE"), TEMPLATE_INSTANCE_TYPE, ClassGenerator.this.getNewClassName()));
                return ClassGenerator.this.getNewClassName();
            }
            if (TEMPLATE_STATIC_TYPE.equals(typeName)) {
                logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_TYPE"), TEMPLATE_STATIC_TYPE, ClassGenerator.this.getNewClassName()));
                return ClassGenerator.this.getNewClassName();
            }
            if (TEMPLATE_SPRING_TYPE.equals(typeName)) {
                logger.finer(MessageFormat.format(Messages.getString("ClassGenerator.NOTE__REPLACING_TYPE"), TEMPLATE_SPRING_TYPE, ClassGenerator.this.getNewClassName()));
                return ClassGenerator.this.getNewClassName();
            }
            return typeName;
        }
    }
}

