/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal.invocation.processor;

import com.ibm.cics.server.internal.invocation.processor.AnnotatedMethod;
import com.ibm.cics.server.internal.invocation.processor.ClassGenerator;
import com.ibm.cics.server.invocation.binding.LinkableTargetMetadata;
import com.ibm.cics.server.invocation.binding.ObjectFactory;
import com.ibm.cics.server.invocation.binding.ProgramDefinition;

public class LinkableTargetMetadataBuilder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM @PID###@ (c) Copyright IBM Corp. 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ObjectFactory factory = new ObjectFactory();

    public LinkableTargetMetadata buildMetadataFor(String className, AnnotatedMethod annotatedMethod) {
        LinkableTargetMetadata metadata = this.factory.createLinkableTargetMetadata();
        metadata.setClassName(className);
        LinkableTargetMetadata.Method method = this.factory.createLinkableTargetMetadataMethod();
        method.setName(annotatedMethod.getAnnotatedMethodElement().getSimpleName().toString());
        metadata.setMethod(method);
        LinkableTargetMetadata.Bean bean2 = this.factory.createLinkableTargetMetadataBean();
        bean2.setName(ClassGenerator.getNewSimpleClassName(annotatedMethod.getUUID()));
        bean2.setProxy(true);
        bean2.setTargetType(annotatedMethod.getTargetType().name());
        metadata.setBean(bean2);
        ProgramDefinition programDefinition = this.factory.createProgramDefinition();
        programDefinition.setName(annotatedMethod.getProgramName());
        metadata.setProgram(programDefinition);
        return metadata;
    }
}

