/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal.invocation.processor;

import com.ibm.cics.server.internal.invocation.processor.Messages;
import com.ibm.cics.server.internal.invocation.processor.ValidationException;
import com.ibm.cics.server.invocation.CICSProgram;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.processing.ProcessingEnvironment;
import javax.enterprise.context.NormalScope;
import javax.inject.Inject;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementKindVisitor7;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class AnnotatedMethod {
    private static final String PROGRAM_NAME_PATTERN = "[A-Za-z0-9$@#]+";
    private static final String CICS_RESERVED_PREFIX = "DFH";
    public static final Class<CICSProgram> ANNOTATION_CLASS = CICSProgram.class;
    public static final String PROGRAM_NAME_ANNOTATION_VALUE = "value";
    private static final String TARGET_TYPE_ANNOTATION_VALUE = "targetType";
    private static final String ERROR__ANNOTATION__DISALLOWED_LOCATION = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__DISALLOWED_LOCATION"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__METHOD_NOT_PUBLIC = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__METHOD_NOT_PUBLIC"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__METHOD_NOT_CONCRETE = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__METHOD_NOT_CONCRETE"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__METHOD_HAS_ARGS = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__METHOD_HAS_ARGS"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__TYPE_NOT_TOP_LEVEL = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__TYPE_NOT_TOP_LEVEL"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__TYPE_MISSING_NO_ARGS_CONSTRUCTOR = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__TYPE_MISSING_NO_ARGS_CONSTRUCTOR"), CICSProgram.class.getSimpleName());
    private static final String ERROR__ANNOTATION__METHOD_NOT_VOID = MessageFormat.format(Messages.getString("AnnotatedMethod.ERROR__ANNOTATION__METHOD_NOT_VOID"), CICSProgram.class.getSimpleName());
    private final ExecutableElement annotatedMethodElement;
    private final String programName;
    private final UUID uuid;
    private ProcessingEnvironment processingEnv;
    private CICSProgram.TargetType targetType;

    public AnnotatedMethod(Element element, ProcessingEnvironment processingEnvironment) throws ValidationException {
        this.processingEnv = processingEnvironment;
        this.annotatedMethodElement = (ExecutableElement)element;
        CICSProgram cICSProgram = this.annotatedMethodElement.getAnnotation(ANNOTATION_CLASS);
        this.targetType = this.determineTargetType(cICSProgram);
        this.programName = cICSProgram.value();
        this.uuid = UUID.randomUUID();
        this.validateAnnotatedMethod(element);
        this.validateProgramName(this.programName);
    }

    private CICSProgram.TargetType determineTargetType(CICSProgram cICSProgram) {
        CICSProgram.TargetType targetType = cICSProgram.targetType();
        String string = "";
        Optional<String> optional = this.getSpringAnnotations();
        Optional<String> optional2 = this.getCDIAnnotations();
        if (optional.isPresent()) {
            string = optional.get();
            targetType = CICSProgram.TargetType.SPRINGBEAN;
        } else if (optional2.isPresent()) {
            string = optional2.get();
            targetType = CICSProgram.TargetType.CDI;
        }
        if (AnnotatedMethod.isResolvedTypeMismatchedFromOriginalType(cICSProgram, targetType)) {
            AnnotationMirror annotationMirror = AnnotatedMethod.retrieveAnnotationMirror(this.annotatedMethodElement, ANNOTATION_CLASS);
            AnnotationValue annotationValue = AnnotatedMethod.retrieveAnnotationValue(annotationMirror, TARGET_TYPE_ANNOTATION_VALUE);
            String string2 = MessageFormat.format(Messages.getString("AnnotatedMethod.WARNING__TARGETTPE__MISMATCHED"), string, cICSProgram.targetType().toString(), targetType.toString());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, string2, this.annotatedMethodElement, annotationMirror, annotationValue);
        }
        if (targetType == CICSProgram.TargetType.UNSPECIFIED) {
            targetType = CICSProgram.TargetType.POJO;
        }
        return targetType;
    }

    private static boolean isResolvedTypeMismatchedFromOriginalType(CICSProgram cICSProgram, CICSProgram.TargetType targetType) {
        CICSProgram.TargetType targetType2 = cICSProgram.targetType();
        if (targetType2 == CICSProgram.TargetType.UNSPECIFIED) {
            return false;
        }
        return targetType2 != targetType;
    }

    private Optional<String> getSpringAnnotations() {
        return this.getAnnotation("org.springframework.stereotype.Component");
    }

    private Optional<String> getCDIAnnotations() {
        Optional<String> optional = this.getAnnotation(Qualifier.class);
        if (optional.isPresent()) {
            return optional;
        }
        optional = this.getAnnotation(Scope.class);
        if (optional.isPresent()) {
            return optional;
        }
        optional = this.getAnnotation(NormalScope.class);
        if (optional.isPresent()) {
            return optional;
        }
        return this.getAnnotatedMembers(Inject.class);
    }

    private <T extends Annotation> Optional<String> getAnnotation(Class<T> clazz) {
        return this.getAnnotation(clazz, this.annotatedMethodElement.getEnclosingElement());
    }

    private <T extends Annotation> Optional<String> getAnnotation(Class<T> clazz, Element element) {
        T t = element.getAnnotation(clazz);
        if (t != null) {
            return Optional.of(t.getClass().getSimpleName());
        }
        Elements elements = this.processingEnv.getElementUtils();
        if (elements == null) {
            return Optional.empty();
        }
        for (AnnotationMirror annotationMirror : elements.getAllAnnotationMirrors(element)) {
            if (annotationMirror.getAnnotationType().asElement().getAnnotation(clazz) == null) continue;
            return Optional.of(annotationMirror.getAnnotationType().asElement().getSimpleName().toString());
        }
        return Optional.empty();
    }

    private <T extends Annotation> Optional<String> getAnnotation(String string) {
        return this.getAnnotation(string, this.annotatedMethodElement.getEnclosingElement());
    }

    private <T extends Annotation> Optional<String> getAnnotation(String string, Element element) {
        Elements elements = this.processingEnv.getElementUtils();
        if (elements == null) {
            return Optional.empty();
        }
        TypeElement typeElement = elements.getTypeElement(string);
        if (typeElement == null) {
            return Optional.empty();
        }
        for (AnnotationMirror annotationMirror : elements.getAllAnnotationMirrors(element)) {
            if (this.processingEnv.getTypeUtils().isAssignable(annotationMirror.getAnnotationType(), typeElement.asType())) {
                return Optional.of(annotationMirror.getAnnotationType().asElement().getSimpleName().toString());
            }
            for (AnnotationMirror annotationMirror2 : elements.getAllAnnotationMirrors(annotationMirror.getAnnotationType().asElement())) {
                if (!this.processingEnv.getTypeUtils().isAssignable(annotationMirror2.getAnnotationType(), typeElement.asType())) continue;
                return Optional.of(annotationMirror.getAnnotationType().asElement().getSimpleName().toString());
            }
        }
        return Optional.empty();
    }

    private <T extends Annotation> Optional<String> getAnnotatedMembers(Class<T> clazz) {
        List<? extends Element> list = this.annotatedMethodElement.getEnclosingElement().getEnclosedElements();
        for (Element element : list) {
            Optional<String> optional = this.getAnnotation(clazz, element);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    private void validateAnnotatedMethod(Element element) throws ValidationException {
        AnnotationMirror annotationMirror = AnnotatedMethod.retrieveAnnotationMirror(element, ANNOTATION_CLASS);
        AnnotatedMethod.validateAnnotationIsOnMethod(element, annotationMirror);
        ExecutableElement executableElement = (ExecutableElement)element;
        AnnotatedMethod.validateMethodIsPublic(executableElement, annotationMirror);
        AnnotatedMethod.validateMethodIsConcrete(executableElement, annotationMirror);
        AnnotatedMethod.validateMethodIsNotNested(executableElement, annotationMirror);
        AnnotatedMethod.validateMethodHasNoArgs(executableElement, annotationMirror);
        this.validateMethodHasVoidReturnType(executableElement, annotationMirror);
        if (!AnnotatedMethod.isStaticMethod(executableElement)) {
            this.validateClassHasNoArgsConstructor(executableElement, annotationMirror);
        }
    }

    private static boolean isStaticMethod(ExecutableElement executableElement) {
        return executableElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    private void validateClassHasNoArgsConstructor(ExecutableElement executableElement, AnnotationMirror annotationMirror) throws ValidationException {
        if (this.targetType == CICSProgram.TargetType.SPRINGBEAN || this.targetType == CICSProgram.TargetType.CDI) {
            return;
        }
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        NoArgsConstructorDetectionResult noArgsConstructorDetectionResult = new NoArgsConstructorDetectionResult();
        typeElement.accept(new NoArgsDetectionVisitor(), noArgsConstructorDetectionResult);
        if (noArgsConstructorDetectionResult.isConstructorDefined() && !noArgsConstructorDetectionResult.isNoArgConstructorDefined()) {
            throw new ValidationException(ValidationException.Type.CLASS_MISSING_NO_ARGS_CONSTRUCTOR, ERROR__ANNOTATION__TYPE_MISSING_NO_ARGS_CONSTRUCTOR, executableElement, annotationMirror);
        }
    }

    private static void validateMethodHasNoArgs(ExecutableElement executableElement, AnnotationMirror annotationMirror) throws ValidationException {
        if (!executableElement.getParameters().isEmpty()) {
            throw new ValidationException(ValidationException.Type.METHOD_HAS_ARGS, ERROR__ANNOTATION__METHOD_HAS_ARGS, executableElement, annotationMirror);
        }
    }

    private static void validateMethodIsNotNested(ExecutableElement executableElement, AnnotationMirror annotationMirror) throws ValidationException {
        Element element = executableElement.getEnclosingElement();
        if (!(element instanceof TypeElement) || ((TypeElement)element).getNestingKind().isNested()) {
            throw new ValidationException(ValidationException.Type.CLASS_IS_NESTED, ERROR__ANNOTATION__TYPE_NOT_TOP_LEVEL, executableElement, annotationMirror);
        }
    }

    private static void validateMethodIsPublic(ExecutableElement executableElement, AnnotationMirror annotationMirror) throws ValidationException {
        if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ValidationException(ValidationException.Type.METHOD_NOT_PUBLIC, ERROR__ANNOTATION__METHOD_NOT_PUBLIC, executableElement, annotationMirror);
        }
    }

    private static void validateMethodIsConcrete(ExecutableElement executableElement, AnnotationMirror annotationMirror) throws ValidationException {
        if (executableElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ValidationException(ValidationException.Type.METHOD_NOT_CONCRETE, ERROR__ANNOTATION__METHOD_NOT_CONCRETE, executableElement, annotationMirror);
        }
    }

    private void validateMethodHasVoidReturnType(ExecutableElement executableElement, AnnotationMirror annotationMirror) throws ValidationException {
        Types types = this.processingEnv.getTypeUtils();
        if (!types.isSameType(executableElement.getReturnType(), types.getNoType(TypeKind.VOID))) {
            throw new ValidationException(ValidationException.Type.METHOD_HAS_NON_VOID_RETURN_TYPE, ERROR__ANNOTATION__METHOD_NOT_VOID, executableElement, annotationMirror);
        }
    }

    private static void validateAnnotationIsOnMethod(Element element, AnnotationMirror annotationMirror) throws ValidationException {
        if (element.getKind() != ElementKind.METHOD) {
            throw new ValidationException(ValidationException.Type.ANNOTATION_NOT_ON_METHOD, ERROR__ANNOTATION__DISALLOWED_LOCATION, element, annotationMirror);
        }
    }

    private void validateProgramName(String string) throws ValidationException {
        AnnotationMirror annotationMirror = AnnotatedMethod.retrieveAnnotationMirror(this.annotatedMethodElement, ANNOTATION_CLASS);
        AnnotationValue annotationValue = AnnotatedMethod.retrieveAnnotationValue(annotationMirror, PROGRAM_NAME_ANNOTATION_VALUE);
        if (string == null) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_MISSING, Messages.getString("AnnotatedMethod.ERROR__PROGRAM_NAME_MISSING"), this.annotatedMethodElement, annotationMirror, annotationValue);
        }
        if (string.isEmpty()) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_BAD_LENGTH, Messages.getString("AnnotatedMethod.ERROR__PROGRAM_NAME__LENGTH"), this.annotatedMethodElement, annotationMirror, annotationValue);
        }
        if (string.length() > 8) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_BAD_LENGTH, Messages.getString("AnnotatedMethod.ERROR__PROGRAM_NAME__LENGTH"), this.annotatedMethodElement, annotationMirror, annotationValue);
        }
        if (!string.matches(PROGRAM_NAME_PATTERN)) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_BAD_CHARS, Messages.getString("AnnotatedMethod.ERROR__PROGRAM_NAME__PERMITTED_CHARACTERS"), this.annotatedMethodElement, annotationMirror, annotationValue);
        }
    }

    public void validateProgramName() throws ValidationException {
        AnnotationMirror annotationMirror = AnnotatedMethod.retrieveAnnotationMirror(this.annotatedMethodElement, ANNOTATION_CLASS);
        AnnotationValue annotationValue = AnnotatedMethod.retrieveAnnotationValue(annotationMirror, PROGRAM_NAME_ANNOTATION_VALUE);
        if (this.programName.startsWith(CICS_RESERVED_PREFIX)) {
            throw new ValidationException(ValidationException.Type.PROGRAM_NAME_RESERVED_FOR_CICS, MessageFormat.format(Messages.getString("AnnotatedMethod.WARNING__PROGRAM_NAME__CICS_RESERVED_PREFIX"), CICS_RESERVED_PREFIX), this.annotatedMethodElement, annotationMirror, annotationValue);
        }
    }

    public static AnnotationMirror retrieveAnnotationMirror(Element element, Class<?> clazz) {
        List<? extends AnnotationMirror> list = element.getAnnotationMirrors();
        AnnotationMirror annotationMirror = null;
        for (AnnotationMirror annotationMirror2 : list) {
            if (!((TypeElement)annotationMirror2.getAnnotationType().asElement()).getQualifiedName().contentEquals(clazz.getCanonicalName())) continue;
            annotationMirror = annotationMirror2;
            break;
        }
        return annotationMirror;
    }

    public static AnnotationValue retrieveAnnotationValue(AnnotationMirror annotationMirror, String string) {
        AnnotationValue annotationValue = null;
        if (annotationMirror != null) {
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!executableElement.getSimpleName().contentEquals(string)) continue;
                annotationValue = annotationMirror.getElementValues().get(executableElement);
                break;
            }
        }
        return annotationValue;
    }

    public TypeElement getEnclosingTypeElement() {
        return (TypeElement)this.annotatedMethodElement.getEnclosingElement();
    }

    public boolean isStaticMethod() {
        return AnnotatedMethod.isStaticMethod(this.annotatedMethodElement);
    }

    public ExecutableElement getAnnotatedMethodElement() {
        return this.annotatedMethodElement;
    }

    public String getProgramName() {
        return this.programName;
    }

    public String getUUID() {
        return this.uuid.toString().replace("-", "");
    }

    public CICSProgram.TargetType getTargetType() {
        return this.targetType;
    }

    protected final class NoArgsConstructorDetectionResult {
        private boolean constructorDefined = false;
        private boolean noArgConstructorDefined = false;

        protected NoArgsConstructorDetectionResult() {
        }

        public void foundConstructor() {
            this.constructorDefined = true;
        }

        public void foundNoArgsConstructor() {
            this.constructorDefined = true;
            this.noArgConstructorDefined = true;
        }

        public boolean isConstructorDefined() {
            return this.constructorDefined;
        }

        public boolean isNoArgConstructorDefined() {
            return this.noArgConstructorDefined;
        }
    }

    protected final class NoArgsDetectionVisitor
    extends ElementKindVisitor7<Void, NoArgsConstructorDetectionResult> {
        protected NoArgsDetectionVisitor() {
        }

        @Override
        public Void visitType(TypeElement typeElement, NoArgsConstructorDetectionResult noArgsConstructorDetectionResult) {
            for (Element element : typeElement.getEnclosedElements()) {
                if (noArgsConstructorDetectionResult.isNoArgConstructorDefined()) break;
                if (!(element instanceof ExecutableElement)) continue;
                element.accept(this, noArgsConstructorDetectionResult);
            }
            return null;
        }

        @Override
        public Void visitExecutableAsConstructor(ExecutableElement executableElement, NoArgsConstructorDetectionResult noArgsConstructorDetectionResult) {
            if (executableElement.getParameters().isEmpty()) {
                noArgsConstructorDetectionResult.foundNoArgsConstructor();
            } else {
                noArgsConstructorDetectionResult.foundConstructor();
            }
            return null;
        }
    }
}

