/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal.invocation.processor;

import com.ibm.cics.server.internal.invocation.processor.AnnotatedMethod;
import com.ibm.cics.server.internal.invocation.processor.AnnotatedType;
import com.ibm.cics.server.internal.invocation.processor.Messages;
import com.ibm.cics.server.invocation.CICSProgram;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class ProxyClassGenerator
implements Opcodes {
    protected static Logger logger = Logger.getLogger(ProxyClassGenerator.class.getName());
    private static final String TEMPLATE_FOLDER = "com/ibm/cics/server/invocation/template";
    private static final String BEAN_NAME_PREFIX = "LinkBean_";
    public static final String TEMPLATE_INSTANCE_TYPE = "com/ibm/cics/server/invocation/template/InstanceInvocationProxyTemplate";
    public static final String TEMPLATE_STATIC_TYPE = "com/ibm/cics/server/invocation/template/StaticInvocationProxyTemplate";
    public static final String TEMPLATE_SPRING_TYPE = "com/ibm/cics/server/invocation/template/SpringBeanInvocationProxyTemplate";
    public static final String TEMPLATE_OSGI_TYPE = "com/ibm/cics/server/invocation/template/OSGiInvocationProxyTemplate";
    public static final String TEMPLATE_OSGI_STATIC_TYPE = "com/ibm/cics/server/invocation/template/OSGiStaticInvocationProxyTemplate";
    public static final String TEMPLATE_CDI_TYPE = "com/ibm/cics/server/invocation/template/CDIBeanInvocationProxyTemplate";
    private static final String TEMPLATE_PLACEHOLDER_TYPE = "com/ibm/cics/server/invocation/template/UserClass";
    private static final String TEMPLATE_STATIC_METHOD_PLACEHOLDER = "staticMethod";
    private static final String TEMPLATE_INSTANCE_METHOD_PLACEHOLDER = "instanceMethod";
    private static final String TEMPLATE_CONTAINING_METHOD = "doInvoke";
    private static final String TEMPLATE_TARGET_FIELD = "autowiredObject";
    private static final String INJECTION_TARGET_FIELD = "bean";
    protected final AnnotatedMethod annotatedMethod;
    private final AnnotatedType annotatedType;
    private String destPackage;

    public ProxyClassGenerator(AnnotatedMethod annotatedMethod, AnnotatedType annotatedType) {
        this.annotatedMethod = annotatedMethod;
        this.annotatedType = annotatedType;
    }

    private String getClassName() {
        return this.annotatedType.getType().getQualifiedName().toString();
    }

    private String getMethodName() {
        return this.annotatedMethod.getAnnotatedMethodElement().getSimpleName().toString();
    }

    protected boolean isStatic() {
        return this.annotatedMethod.isStaticMethod();
    }

    public byte[] generate(String string) throws IOException {
        int n;
        this.destPackage = string;
        String string2 = this.getTemplateFileName();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return this.generate(byteArrayOutputStream.toByteArray());
    }

    public byte[] generateOSGi(String string) throws IOException {
        int n;
        this.destPackage = string;
        String string2 = this.isStatic() ? TEMPLATE_OSGI_STATIC_TYPE : TEMPLATE_OSGI_TYPE;
        string2 = string2 + ".class";
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return this.generate(byteArrayOutputStream.toByteArray());
    }

    private String getTemplateFileName() {
        String string = null;
        switch (this.annotatedMethod.getTargetType()) {
            case SPRINGBEAN: {
                string = TEMPLATE_SPRING_TYPE;
                break;
            }
            case CDI: {
                string = TEMPLATE_CDI_TYPE;
                break;
            }
            default: {
                string = this.isStatic() ? TEMPLATE_STATIC_TYPE : TEMPLATE_INSTANCE_TYPE;
            }
        }
        string = string + ".class";
        return string;
    }

    private byte[] generate(byte[] byArray) throws IOException {
        ClassReader classReader = new ClassReader(byArray);
        ClassWriter classWriter = new ClassWriter(1);
        InvocationProxyTemplateModifyingVisitor invocationProxyTemplateModifyingVisitor = new InvocationProxyTemplateModifyingVisitor(327680, classWriter, this.getClassName().replace('.', '/'), this.getMethodName());
        InvocationProxyTemplateRemapper invocationProxyTemplateRemapper = new InvocationProxyTemplateRemapper();
        ClassRemapper classRemapper = new ClassRemapper(invocationProxyTemplateModifyingVisitor, invocationProxyTemplateRemapper);
        classReader.accept(classRemapper, 0);
        return classWriter.toByteArray();
    }

    protected String getNewClassName() {
        return this.getNewFullyQualifiedClassName(this.annotatedMethod.getUUID());
    }

    public String getNewFullyQualifiedClassName(String string) {
        return this.destPackage.replace('.', '/') + "/" + ProxyClassGenerator.getNewSimpleClassName(string);
    }

    public static String getNewSimpleClassName(String string) {
        return BEAN_NAME_PREFIX + string;
    }

    static {
        logger.setLevel(Level.ALL);
    }

    private final class InvocationProxyTemplateModifyingVisitor
    extends ClassVisitor {
        protected final String className;
        protected final String targetClassDescriptor;
        protected final String methodName;

        protected InvocationProxyTemplateModifyingVisitor(int n, ClassVisitor classVisitor, String string, String string2) {
            super(n, classVisitor);
            this.className = string;
            this.targetClassDescriptor = "L" + this.className + ";";
            this.methodName = string2;
        }

        @Override
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            MethodVisitor methodVisitor = super.visitMethod(n, string, string2, string3, stringArray);
            if (ProxyClassGenerator.TEMPLATE_CONTAINING_METHOD.equals(string)) {
                logger.finer(MessageFormat.format(Messages.getString("ProxyClassGenerator.NOTE__ALTERING_METHOD"), ProxyClassGenerator.TEMPLATE_CONTAINING_METHOD));
                if (ProxyClassGenerator.this.annotatedMethod.getTargetType() == CICSProgram.TargetType.SPRINGBEAN) {
                    methodVisitor = new SpringDoInvokeMethodVisitor(this.api, methodVisitor);
                }
                if (ProxyClassGenerator.this.annotatedMethod.getTargetType() == CICSProgram.TargetType.CDI) {
                    methodVisitor = new CDIDoInvokeMethodVisitor(this.api, methodVisitor);
                }
                methodVisitor = ProxyClassGenerator.this.isStatic() ? new StaticMethodVisitor(this.api, methodVisitor) : new InstanceMethodVisitor(this.api, methodVisitor);
            }
            return methodVisitor;
        }

        @Override
        public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
            String string4 = string2;
            if (string.equals(ProxyClassGenerator.TEMPLATE_TARGET_FIELD) || string.equals(ProxyClassGenerator.INJECTION_TARGET_FIELD)) {
                string4 = this.targetClassDescriptor;
            }
            return super.visitField(n, string, string4, string3, object);
        }

        private final class SpringDoInvokeMethodVisitor
        extends MethodVisitor {
            public SpringDoInvokeMethodVisitor(int n, MethodVisitor methodVisitor) {
                super(n, methodVisitor);
            }

            @Override
            public void visitFieldInsn(int n, String string, String string2, String string3) {
                String string4 = string3;
                if (string2.equals(ProxyClassGenerator.TEMPLATE_TARGET_FIELD)) {
                    string4 = InvocationProxyTemplateModifyingVisitor.this.targetClassDescriptor;
                }
                super.visitFieldInsn(n, string, string2, string4);
            }
        }

        private final class CDIDoInvokeMethodVisitor
        extends MethodVisitor {
            public CDIDoInvokeMethodVisitor(int n, MethodVisitor methodVisitor) {
                super(n, methodVisitor);
            }

            @Override
            public void visitFieldInsn(int n, String string, String string2, String string3) {
                String string4 = string3;
                if (string2.equals(ProxyClassGenerator.INJECTION_TARGET_FIELD)) {
                    string4 = InvocationProxyTemplateModifyingVisitor.this.targetClassDescriptor;
                }
                super.visitFieldInsn(n, string, string2, string4);
            }
        }

        private final class StaticMethodVisitor
        extends MethodVisitor {
            public StaticMethodVisitor(int n, MethodVisitor methodVisitor) {
                super(n, methodVisitor);
            }

            @Override
            public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
                boolean bl2;
                String string4 = string;
                String string5 = string2;
                boolean bl3 = bl;
                boolean bl4 = ProxyClassGenerator.TEMPLATE_PLACEHOLDER_TYPE.equals(string);
                boolean bl5 = "()V".equals(string3);
                boolean bl6 = bl2 = bl4 && bl5 && ProxyClassGenerator.TEMPLATE_STATIC_METHOD_PLACEHOLDER.equals(string2);
                if (n == 184 && bl2) {
                    logger.finer(MessageFormat.format(Messages.getString("ProxyClassGenerator.NOTE__REPLACING_STATIC_METHOD_CALL"), ProxyClassGenerator.TEMPLATE_PLACEHOLDER_TYPE, ProxyClassGenerator.TEMPLATE_STATIC_METHOD_PLACEHOLDER, InvocationProxyTemplateModifyingVisitor.this.className, InvocationProxyTemplateModifyingVisitor.this.methodName));
                    string4 = InvocationProxyTemplateModifyingVisitor.this.className;
                    string5 = InvocationProxyTemplateModifyingVisitor.this.methodName;
                    bl3 = false;
                }
                super.visitMethodInsn(n, string4, string5, string3, bl3);
            }
        }

        private final class InstanceMethodVisitor
        extends MethodVisitor {
            public InstanceMethodVisitor(int n, MethodVisitor methodVisitor) {
                super(n, methodVisitor);
            }

            @Override
            public void visitTypeInsn(int n, String string) {
                String string2 = string;
                if (n == 187 && ProxyClassGenerator.TEMPLATE_PLACEHOLDER_TYPE.equals(string)) {
                    logger.finer(MessageFormat.format(Messages.getString("ProxyClassGenerator.NOTE__REPLACING_NEW_TYPE"), ProxyClassGenerator.TEMPLATE_PLACEHOLDER_TYPE, InvocationProxyTemplateModifyingVisitor.this.className));
                    string2 = InvocationProxyTemplateModifyingVisitor.this.className;
                }
                super.visitTypeInsn(n, string2);
            }

            @Override
            public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
                boolean bl2;
                String string4 = string;
                String string5 = string2;
                String string6 = string3;
                boolean bl3 = bl;
                boolean bl4 = "()V".equals(string3);
                boolean bl5 = ProxyClassGenerator.TEMPLATE_PLACEHOLDER_TYPE.equals(string);
                boolean bl6 = bl5 && bl4 && "<init>".equals(string2);
                boolean bl7 = bl2 = bl5 && bl4 && ProxyClassGenerator.TEMPLATE_INSTANCE_METHOD_PLACEHOLDER.equals(string2);
                if (n == 183 && bl6) {
                    logger.finer(MessageFormat.format(Messages.getString("ProxyClassGenerator.NOTE__REPLACING_CONSTRUCTOR"), ProxyClassGenerator.TEMPLATE_PLACEHOLDER_TYPE, InvocationProxyTemplateModifyingVisitor.this.className));
                    string4 = InvocationProxyTemplateModifyingVisitor.this.className;
                    bl3 = false;
                }
                if (n == 182 && bl2) {
                    logger.finer(MessageFormat.format(Messages.getString("ProxyClassGenerator.NOTE__REPLACING_INSTANCE_METHOD_CALL"), ProxyClassGenerator.TEMPLATE_PLACEHOLDER_TYPE, ProxyClassGenerator.TEMPLATE_INSTANCE_METHOD_PLACEHOLDER, InvocationProxyTemplateModifyingVisitor.this.className, InvocationProxyTemplateModifyingVisitor.this.methodName));
                    string4 = InvocationProxyTemplateModifyingVisitor.this.className;
                    string5 = InvocationProxyTemplateModifyingVisitor.this.methodName;
                    bl3 = false;
                }
                super.visitMethodInsn(n, string4, string5, string6, bl3);
            }
        }
    }

    protected final class InvocationProxyTemplateRemapper
    extends Remapper {
        protected InvocationProxyTemplateRemapper() {
        }

        @Override
        public String map(String string) {
            String string2 = string;
            if (ProxyClassGenerator.TEMPLATE_INSTANCE_TYPE.equals(string) || ProxyClassGenerator.TEMPLATE_STATIC_TYPE.equals(string) || ProxyClassGenerator.TEMPLATE_SPRING_TYPE.equals(string) || ProxyClassGenerator.TEMPLATE_OSGI_TYPE.equals(string) || ProxyClassGenerator.TEMPLATE_OSGI_STATIC_TYPE.equals(string) || ProxyClassGenerator.TEMPLATE_CDI_TYPE.equals(string)) {
                string2 = ProxyClassGenerator.this.getNewClassName();
                logger.finer(MessageFormat.format(Messages.getString("ProxyClassGenerator.NOTE__REPLACING_TYPE"), string, string2));
            }
            return string2;
        }
    }
}

