/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server.internal.invocation.processor;

import com.ibm.cics.server.internal.invocation.processor.AnnotatedMethod;
import com.ibm.cics.server.internal.invocation.processor.AnnotatedType;
import com.ibm.cics.server.internal.invocation.processor.Messages;
import com.ibm.cics.server.invocation.CICSProgram;
import com.ibm.cics.server.invocation.template.CDIBeanInvocationProxyTemplate;
import com.ibm.cics.server.invocation.template.InstanceInvocationProxyTemplate;
import com.ibm.cics.server.invocation.template.OSGiInvocationProxyTemplate;
import com.ibm.cics.server.invocation.template.OSGiStaticInvocationProxyTemplate;
import com.ibm.cics.server.invocation.template.SpringBeanInvocationProxyTemplate;
import com.ibm.cics.server.invocation.template.StaticInvocationProxyTemplate;
import com.ibm.cics.server.invocation.template.UserClass;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class ProxyClassGenerator
implements Opcodes {
    protected static Logger logger;
    private static final String BEAN_NAME_PREFIX = "LinkBean_";
    public static final String TEMPLATE_INSTANCE_TYPE;
    public static final String TEMPLATE_STATIC_TYPE;
    public static final String TEMPLATE_SPRING_TYPE;
    public static final String TEMPLATE_OSGI_TYPE;
    public static final String TEMPLATE_OSGI_STATIC_TYPE;
    public static final String TEMPLATE_CDI_TYPE;
    protected static final String TEMPLATE_PLACEHOLDER_TYPE;
    private static final String TEMPLATE_STATIC_METHOD_PLACEHOLDER = "staticMethod";
    private static final String TEMPLATE_INSTANCE_METHOD_PLACEHOLDER = "instanceMethod";
    private static final String TEMPLATE_CONTAINING_METHOD = "doInvoke";
    private static final String TEMPLATE_TARGET_FIELD = "autowiredObject";
    private static final String INJECTION_TARGET_FIELD = "bean";
    protected final AnnotatedMethod annotatedMethod;
    private final AnnotatedType annotatedType;
    private String destPackage;

    public ProxyClassGenerator(AnnotatedMethod theAnnotatedMethod, AnnotatedType theAnnotatedType) {
        this.annotatedMethod = theAnnotatedMethod;
        this.annotatedType = theAnnotatedType;
    }

    private String getClassName() {
        return this.annotatedType.getType().getQualifiedName().toString();
    }

    private String getMethodName() {
        return this.annotatedMethod.getAnnotatedMethodElement().getSimpleName().toString();
    }

    protected boolean isStatic() {
        return this.annotatedMethod.isStaticMethod();
    }

    public byte[] generate(String destinationPackage) throws IOException {
        int c;
        this.destPackage = destinationPackage;
        String templateType = this.getTemplateFileName();
        InputStream templateStream = this.getClass().getClassLoader().getResourceAsStream(templateType);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = templateStream.read()) != -1) {
            baos.write(c);
        }
        return this.generate(baos.toByteArray());
    }

    public byte[] generateOSGi(String destinationPackage) throws IOException {
        int c;
        this.destPackage = destinationPackage;
        String templateType = this.isStatic() ? TEMPLATE_OSGI_STATIC_TYPE : TEMPLATE_OSGI_TYPE;
        templateType = templateType + ".class";
        InputStream templateStream = this.getClass().getClassLoader().getResourceAsStream(templateType);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = templateStream.read()) != -1) {
            baos.write(c);
        }
        return this.generate(baos.toByteArray());
    }

    private String getTemplateFileName() {
        String templateType = null;
        switch (this.annotatedMethod.getTargetType()) {
            case SPRINGBEAN: {
                templateType = TEMPLATE_SPRING_TYPE;
                break;
            }
            case CDI: {
                templateType = TEMPLATE_CDI_TYPE;
                break;
            }
            default: {
                templateType = this.isStatic() ? TEMPLATE_STATIC_TYPE : TEMPLATE_INSTANCE_TYPE;
            }
        }
        templateType = templateType + ".class";
        return templateType;
    }

    private byte[] generate(byte[] input) throws IOException {
        ClassReader classReader = new ClassReader(input);
        ClassWriter classWriter = new ClassWriter(1);
        InvocationProxyTemplateModifyingVisitor templateClassModifier = new InvocationProxyTemplateModifyingVisitor(327680, classWriter, this.getClassName().replace('.', '/'), this.getMethodName());
        InvocationProxyTemplateRemapper templateClassRemapper = new InvocationProxyTemplateRemapper();
        ClassRemapper classModifier = new ClassRemapper(templateClassModifier, templateClassRemapper);
        classReader.accept(classModifier, 0);
        return classWriter.toByteArray();
    }

    protected String getNewClassName() {
        return this.getNewFullyQualifiedClassName(this.annotatedMethod.getUUID());
    }

    public String getNewFullyQualifiedClassName(String uuid) {
        return this.destPackage.replace('.', '/') + "/" + ProxyClassGenerator.getNewSimpleClassName(uuid);
    }

    public static String getNewSimpleClassName(String uuid) {
        return BEAN_NAME_PREFIX + uuid;
    }

    static {
        TEMPLATE_INSTANCE_TYPE = Type.getInternalName(InstanceInvocationProxyTemplate.class);
        TEMPLATE_STATIC_TYPE = Type.getInternalName(StaticInvocationProxyTemplate.class);
        TEMPLATE_SPRING_TYPE = Type.getInternalName(SpringBeanInvocationProxyTemplate.class);
        TEMPLATE_OSGI_TYPE = Type.getInternalName(OSGiInvocationProxyTemplate.class);
        TEMPLATE_OSGI_STATIC_TYPE = Type.getInternalName(OSGiStaticInvocationProxyTemplate.class);
        TEMPLATE_CDI_TYPE = Type.getInternalName(CDIBeanInvocationProxyTemplate.class);
        TEMPLATE_PLACEHOLDER_TYPE = Type.getInternalName(UserClass.class);
        logger = Logger.getLogger(ProxyClassGenerator.class.getName());
        logger.setLevel(Level.ALL);
    }

    private final class InvocationProxyTemplateModifyingVisitor
    extends ClassVisitor {
        protected final String className;
        protected final String targetClassDescriptor;
        protected final String methodName;

        protected InvocationProxyTemplateModifyingVisitor(int theApi, ClassVisitor theCV, String theClassName, String theMethodName) {
            super(theApi, theCV);
            this.className = theClassName;
            this.targetClassDescriptor = "L" + this.className + ";";
            this.methodName = theMethodName;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            if (ProxyClassGenerator.TEMPLATE_CONTAINING_METHOD.equals(name)) {
                logger.finer(MessageFormat.format(Messages.getString("ProxyClassGenerator.NOTE__ALTERING_METHOD"), ProxyClassGenerator.TEMPLATE_CONTAINING_METHOD));
                if (ProxyClassGenerator.this.annotatedMethod.getTargetType() == CICSProgram.TargetType.SPRINGBEAN) {
                    methodVisitor = new SpringDoInvokeMethodVisitor(this.api, methodVisitor);
                }
                if (ProxyClassGenerator.this.annotatedMethod.getTargetType() == CICSProgram.TargetType.CDI) {
                    methodVisitor = new CDIDoInvokeMethodVisitor(this.api, methodVisitor);
                }
                methodVisitor = ProxyClassGenerator.this.isStatic() ? new StaticMethodVisitor(this.api, methodVisitor) : new InstanceMethodVisitor(this.api, methodVisitor);
            }
            return methodVisitor;
        }

        @Override
        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            String desc = descriptor;
            if (name.equals(ProxyClassGenerator.TEMPLATE_TARGET_FIELD) || name.equals(ProxyClassGenerator.INJECTION_TARGET_FIELD)) {
                desc = this.targetClassDescriptor;
            }
            return super.visitField(access, name, desc, signature, value);
        }

        private final class CDIDoInvokeMethodVisitor
        extends MethodVisitor {
            public CDIDoInvokeMethodVisitor(int theApi, MethodVisitor theMV) {
                super(theApi, theMV);
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                String desc = descriptor;
                if (name.equals(ProxyClassGenerator.INJECTION_TARGET_FIELD)) {
                    desc = InvocationProxyTemplateModifyingVisitor.this.targetClassDescriptor;
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        private final class SpringDoInvokeMethodVisitor
        extends MethodVisitor {
            public SpringDoInvokeMethodVisitor(int theApi, MethodVisitor theMV) {
                super(theApi, theMV);
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                String desc = descriptor;
                if (name.equals(ProxyClassGenerator.TEMPLATE_TARGET_FIELD)) {
                    desc = InvocationProxyTemplateModifyingVisitor.this.targetClassDescriptor;
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        private final class StaticMethodVisitor
        extends MethodVisitor {
            public StaticMethodVisitor(int theApi, MethodVisitor theMV) {
                super(theApi, theMV);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                boolean isTemplateStaticMethod;
                String returnOwner = owner;
                String returnName = name;
                boolean returnItf = itf;
                boolean isTemplateType = TEMPLATE_PLACEHOLDER_TYPE.equals(owner);
                boolean isNoArgsVoidReturn = "()V".equals(desc);
                boolean bl = isTemplateStaticMethod = isTemplateType && isNoArgsVoidReturn && ProxyClassGenerator.TEMPLATE_STATIC_METHOD_PLACEHOLDER.equals(name);
                if (opcode == 184 && isTemplateStaticMethod) {
                    logger.finer(MessageFormat.format(Messages.getString("ProxyClassGenerator.NOTE__REPLACING_STATIC_METHOD_CALL"), TEMPLATE_PLACEHOLDER_TYPE, ProxyClassGenerator.TEMPLATE_STATIC_METHOD_PLACEHOLDER, InvocationProxyTemplateModifyingVisitor.this.className, InvocationProxyTemplateModifyingVisitor.this.methodName));
                    returnOwner = InvocationProxyTemplateModifyingVisitor.this.className;
                    returnName = InvocationProxyTemplateModifyingVisitor.this.methodName;
                    returnItf = false;
                }
                super.visitMethodInsn(opcode, returnOwner, returnName, desc, returnItf);
            }
        }

        private final class InstanceMethodVisitor
        extends MethodVisitor {
            public InstanceMethodVisitor(int theApi, MethodVisitor theMV) {
                super(theApi, theMV);
            }

            @Override
            public void visitTypeInsn(int opcode, String type) {
                String theType = type;
                if (opcode == 187 && TEMPLATE_PLACEHOLDER_TYPE.equals(type)) {
                    logger.finer(MessageFormat.format(Messages.getString("ProxyClassGenerator.NOTE__REPLACING_NEW_TYPE"), TEMPLATE_PLACEHOLDER_TYPE, InvocationProxyTemplateModifyingVisitor.this.className));
                    theType = InvocationProxyTemplateModifyingVisitor.this.className;
                }
                super.visitTypeInsn(opcode, theType);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                boolean isTemplateMethod;
                String returnOwner = owner;
                String returnName = name;
                String returnDesc = desc;
                boolean returnItf = itf;
                boolean isNoArgsVoidReturn = "()V".equals(desc);
                boolean isTemplateType = TEMPLATE_PLACEHOLDER_TYPE.equals(owner);
                boolean isTemplateConstructor = isTemplateType && isNoArgsVoidReturn && "<init>".equals(name);
                boolean bl = isTemplateMethod = isTemplateType && isNoArgsVoidReturn && ProxyClassGenerator.TEMPLATE_INSTANCE_METHOD_PLACEHOLDER.equals(name);
                if (opcode == 183 && isTemplateConstructor) {
                    logger.finer(MessageFormat.format(Messages.getString("ProxyClassGenerator.NOTE__REPLACING_CONSTRUCTOR"), TEMPLATE_PLACEHOLDER_TYPE, InvocationProxyTemplateModifyingVisitor.this.className));
                    returnOwner = InvocationProxyTemplateModifyingVisitor.this.className;
                    returnItf = false;
                }
                if (opcode == 182 && isTemplateMethod) {
                    logger.finer(MessageFormat.format(Messages.getString("ProxyClassGenerator.NOTE__REPLACING_INSTANCE_METHOD_CALL"), TEMPLATE_PLACEHOLDER_TYPE, ProxyClassGenerator.TEMPLATE_INSTANCE_METHOD_PLACEHOLDER, InvocationProxyTemplateModifyingVisitor.this.className, InvocationProxyTemplateModifyingVisitor.this.methodName));
                    returnOwner = InvocationProxyTemplateModifyingVisitor.this.className;
                    returnName = InvocationProxyTemplateModifyingVisitor.this.methodName;
                    returnItf = false;
                }
                super.visitMethodInsn(opcode, returnOwner, returnName, returnDesc, returnItf);
            }
        }
    }

    protected final class InvocationProxyTemplateRemapper
    extends Remapper {
        protected InvocationProxyTemplateRemapper() {
        }

        @Override
        public String map(String typeName) {
            String newTypeName = typeName;
            if (TEMPLATE_INSTANCE_TYPE.equals(typeName) || TEMPLATE_STATIC_TYPE.equals(typeName) || TEMPLATE_SPRING_TYPE.equals(typeName) || TEMPLATE_OSGI_TYPE.equals(typeName) || TEMPLATE_OSGI_STATIC_TYPE.equals(typeName) || TEMPLATE_CDI_TYPE.equals(typeName)) {
                newTypeName = ProxyClassGenerator.this.getNewClassName();
                logger.finer(MessageFormat.format(Messages.getString("ProxyClassGenerator.NOTE__REPLACING_TYPE"), typeName, newTypeName));
            }
            return newTypeName;
        }
    }
}

