/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.ResourceUnavailableException;
import com.ibm.cics.server.SynchronizationResource;
import com.ibm.cics.server.UnknownCicsError;

public class AddressResource
extends SynchronizationResource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = 319465280460549460L;
    private byte[] address;

    public void dequeue() {
        try {
            if (this.address == null) {
                throw new NullPointerException("null resource address");
            }
            super.dequeue(this.address);
        }
        catch (LengthErrorException lee) {
            throw new UnknownCicsError("dequeue(address) returned LengthErrorException");
        }
    }

    public void enqueue() throws ResourceUnavailableException {
        try {
            if (this.address == null) {
                throw new NullPointerException("null resource address");
            }
            super.enqueue(this.address, true);
        }
        catch (LengthErrorException lee) {
            throw new UnknownCicsError("enqueue(address) returned LengthErrorException");
        }
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = new byte[]{0, 0, 0, 0};
        int dataLen = Math.min(address.length, this.address.length);
        System.arraycopy(address, 0, this.address, 0, dataLen);
    }

    public void tryEnqueue() throws ResourceUnavailableException {
        try {
            if (this.address == null) {
                throw new NullPointerException("null resource address");
            }
            super.enqueue(this.address, false);
        }
        catch (LengthErrorException lee) {
            throw new UnknownCicsError("tryEnqueue(address) returned LengthErrorException");
        }
    }
}

