/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.ApplicationNotFoundException;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.Version;

public class Application
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String operation;
    private String application;
    private String platform;
    private Version appVersion;
    private MatchStyle match;

    public Application(String operation, String application, String platform, Version version, MatchStyle match) {
        if (operation.length() > 64) {
            throw new IllegalArgumentException(operation);
        }
        if (application.length() > 64) {
            throw new IllegalArgumentException(application);
        }
        if (platform.length() > 64) {
            throw new IllegalArgumentException(platform);
        }
        if (match == null) {
            throw new IllegalArgumentException("match == null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version == null");
        }
        if (match == MatchStyle.NONE && version.getMajorVersion() >= 0) {
            throw new IllegalArgumentException("Version is not compatible with MatchStyle.NONE");
        }
        this.operation = operation;
        this.application = application;
        this.platform = platform;
        this.appVersion = version;
        this.match = match;
    }

    public Application(String operation, String application, Version version, MatchStyle match) {
        this(operation, application, "", version, match);
    }

    public Application(String operation, String application) {
        this(operation, application, "", new Version(-1, 0, 0), MatchStyle.NONE);
    }

    public Application(String operation, String application, String platform) {
        this(operation, application, platform, new Version(-1, 0, 0), MatchStyle.NONE);
    }

    public Application(String operation, String application, String platform, int majorVersion, int minorVersion, MatchStyle match) {
        this(operation, application, platform, new Version(majorVersion, minorVersion, 0), match);
    }

    public Application(String operation, String application, int majorVersion, int minorVersion, MatchStyle match) {
        this(operation, application, "", new Version(majorVersion, minorVersion, 0), match);
    }

    public String getOperation() {
        return this.operation;
    }

    public String getApplication() {
        return this.application;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Version getVersion() {
        return this.appVersion;
    }

    public void setVersion(Version version) {
        this.appVersion = version;
    }

    public MatchStyle getMatch() {
        return this.match;
    }

    public void setMatch(MatchStyle match) {
        this.match = match;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public boolean equals(Object obj) {
        return obj instanceof Application && ((Application)obj).getApplication().equals(this.application) & ((Application)obj).getPlatform().equals(this.platform) & ((Application)obj).getOperation().equals(this.operation) & ((Application)obj).getVersion().equals(this.appVersion);
    }

    public void invoke() throws InvalidRequestException, ApplicationNotFoundException {
        this.INVOKE(this.operation, this.application, this.platform, this.appVersion.getMajorVersion(), this.appVersion.getMinorVersion(), this.match.getMatchStyle());
    }

    private final native void INVOKE(String var1, String var2, String var3, int var4, int var5, int var6) throws InvalidRequestException, ApplicationNotFoundException;

    public void invoke(Channel channel) throws InvalidRequestException, ApplicationNotFoundException {
        this.INVOKE_CHANNEL(this.operation, this.application, this.platform, this.appVersion.getMajorVersion(), this.appVersion.getMinorVersion(), this.match.getMatchStyle(), channel.getName());
    }

    private final native void INVOKE_CHANNEL(String var1, String var2, String var3, int var4, int var5, int var6, String var7) throws InvalidRequestException, ApplicationNotFoundException;

    public void invoke(byte[] commarea) throws InvalidRequestException, ApplicationNotFoundException {
        this.INVOKE_COMMAREA(this.operation, this.application, this.platform, this.appVersion.getMajorVersion(), this.appVersion.getMinorVersion(), this.match.getMatchStyle(), commarea);
    }

    private final native void INVOKE_COMMAREA(String var1, String var2, String var3, int var4, int var5, int var6, byte[] var7) throws InvalidRequestException, ApplicationNotFoundException;

    public static enum MatchStyle {
        NONE(-1),
        EXACTMATCH(1),
        MINIMUM(2);

        private int match;

        private MatchStyle(int style) {
            this.match = style;
        }

        public int getMatchStyle() {
            return this.match;
        }
    }
}

