/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.Version;

public class ApplicationContext {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String operation;
    private String application;
    private String platform;
    private Version appVersion;

    public ApplicationContext(String operation, String application, String platform, Version version) {
        if (operation.length() > 64) {
            throw new IllegalArgumentException(operation);
        }
        if (application.length() > 64) {
            throw new IllegalArgumentException(application);
        }
        if (platform.length() > 64) {
            throw new IllegalArgumentException(platform);
        }
        this.operation = operation;
        this.application = application;
        this.platform = platform;
        this.appVersion = version;
    }

    public ApplicationContext(String operation, String application, String platform, int majorVersion, int minorVersion, int microVersion) {
        this(operation, application, platform, new Version(majorVersion, minorVersion, microVersion));
    }

    public String getOperation() {
        return this.operation;
    }

    public String getApplication() {
        return this.application;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Version getVersion() {
        return this.appVersion;
    }

    public boolean equals(Object obj) {
        return obj instanceof ApplicationContext && ((ApplicationContext)obj).getApplication().equals(this.application) & ((ApplicationContext)obj).getPlatform().equals(this.platform) & ((ApplicationContext)obj).getOperation().equals(this.operation) & ((ApplicationContext)obj).getVersion().equals(this.appVersion);
    }
}

