/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.AsyncService;
import com.ibm.cics.server.CICSFuture;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.ChildResponse;
import com.ibm.cics.server.ChildResponseImpl;
import com.ibm.cics.server.FileDisabledException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidTransactionIdException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotFinishedException;
import com.ibm.cics.server.NotFoundException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.ResourceDisabledException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class AsyncServiceImpl
extends API
implements AsyncService {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public Future<ChildResponse> runTransactionId(String transactionId, Channel channel) throws InvalidRequestException, InvalidTransactionIdException, ChannelErrorException, NotAuthorisedException, ResourceDisabledException {
        byte[] childToken;
        String channelName = "";
        if (transactionId == null || transactionId.isEmpty() || transactionId.length() > 4) {
            throw new InvalidTransactionIdException("The transaction ID is invalid", 1);
        }
        transactionId = String.format("%1$-4s", transactionId);
        if (channel != null) {
            channelName = channel.getName();
        }
        try {
            childToken = AsyncServiceImpl.RUNTRANSID(transactionId, channelName);
        }
        catch (FileDisabledException e) {
            throw new ResourceDisabledException("Transaction '" + transactionId + "' is disabled", 50);
        }
        CICSFuture future = new CICSFuture(childToken);
        return future;
    }

    @Override
    public Future<ChildResponse> runTransactionId(String transactionId) throws InvalidRequestException, InvalidTransactionIdException, NotAuthorisedException, ResourceDisabledException {
        Future<ChildResponse> request = null;
        try {
            request = this.runTransactionId(transactionId, null);
        }
        catch (ChannelErrorException channelErrorException) {
            // empty catch block
        }
        return request;
    }

    @Override
    public ChildResponse getAny() throws InvalidRequestException, NotFoundException {
        ChildResponseImpl childResponse = new ChildResponseImpl(null);
        byte[] childResponseData = null;
        try {
            childResponseData = AsyncServiceImpl.FETCHANY(0, false);
        }
        catch (RecordNotFoundException e) {
            throw new NotFoundException("No unfetched children were found", 1);
        }
        catch (NotFinishedException notFinishedException) {
            // empty catch block
        }
        if (childResponseData != null) {
            childResponse.setResponse(childResponseData, true);
        }
        return childResponse;
    }

    @Override
    public ChildResponse getAny(AsyncService.BlockingAction blockingAction) throws InvalidRequestException, NotFinishedException, NotFoundException {
        ChildResponseImpl childResponse = new ChildResponseImpl(null);
        byte[] childResponseData = null;
        boolean noSuspendKeyword = false;
        if (blockingAction != null) {
            switch (blockingAction) {
                case NOSUSPEND: {
                    noSuspendKeyword = true;
                    break;
                }
                case SUSPEND: {
                    break;
                }
            }
        }
        try {
            childResponseData = AsyncServiceImpl.FETCHANY(0, noSuspendKeyword);
        }
        catch (RecordNotFoundException e) {
            throw new NotFoundException("No unfetched children were found", 1);
        }
        if (childResponseData != null) {
            childResponse.setResponse(childResponseData, true);
        }
        return childResponse;
    }

    @Override
    public ChildResponse getAny(long timeout, TimeUnit unit) throws InvalidRequestException, NotFinishedException, NotFoundException {
        if (unit == null) {
            throw new InvalidRequestException("A TimeUnit must be specified", 241);
        }
        ChildResponseImpl childResponse = new ChildResponseImpl(null);
        byte[] childResponseData = null;
        long timeoutMilliSeconds = TimeUnit.MILLISECONDS.convert(timeout, unit);
        if (timeoutMilliSeconds >= Integer.MAX_VALUE) {
            throw new InvalidRequestException("Timeout value is too large", 241);
        }
        int cicsTimeout = (int)timeoutMilliSeconds;
        if (timeoutMilliSeconds < 0L) {
            throw new InvalidRequestException("Timeout value must be positive", 241);
        }
        try {
            childResponseData = AsyncServiceImpl.FETCHANY(cicsTimeout, false);
        }
        catch (RecordNotFoundException e) {
            throw new NotFoundException("No unfetched children were found", 1);
        }
        if (childResponseData != null) {
            childResponse.setResponse(childResponseData, true);
        }
        return childResponse;
    }

    @Override
    public void freeChild(ChildResponse childResponse) throws InvalidRequestException {
        if (childResponse == null) {
            throw new InvalidRequestException("Parameter must not be null", 50);
        }
        AsyncServiceImpl.FREECHILD(((ChildResponseImpl)childResponse).getToken());
    }

    @Override
    public void freeChild(Future<ChildResponse> future) throws InvalidRequestException {
        if (future == null || !(future instanceof CICSFuture)) {
            throw new InvalidRequestException("Parameter must be an instance of CICSFuture and not null", 50);
        }
        AsyncServiceImpl.FREECHILD(((CICSFuture)future).getChildResponse().getToken());
    }

    private static final native byte[] RUNTRANSID(String var0, String var1) throws ChannelErrorException, InvalidRequestException, InvalidTransactionIdException, NotAuthorisedException, FileDisabledException;

    private static final native byte[] FETCHANY(int var0, boolean var1) throws InvalidRequestException, NotFinishedException, RecordNotFoundException;

    private static final native void FREECHILD(byte[] var0) throws InvalidRequestException;
}

