/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.Conversation;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAllocatedException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.SyncLevel;
import com.ibm.cics.server.SystemBusyException;
import java.io.Serializable;

public class AttachInitiator
extends API
implements Serializable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2003, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = 1901955914874515196L;
    private String sysId = "";
    private String profile = "";
    private boolean toQueue = true;
    private String process = "";
    private SyncLevel syncLevel = SyncLevel.NONE;

    private static final native Conversation ALLOCATE(String var0, String var1, boolean var2) throws InvalidSystemIdException, InvalidRequestException;

    private static final native int CONNECT_PROCESS(Object var0, byte[] var1, String var2, int var3, byte[] var4) throws InvalidRequestException, LengthErrorException, NotAuthorisedException, NotAllocatedException, SystemBusyException, InvalidSystemIdException;

    public String getProcess() {
        return this.process;
    }

    public String getProfile() {
        return this.profile;
    }

    public boolean getQueue() {
        return this.toQueue;
    }

    public SyncLevel getSyncLevel() {
        return this.syncLevel;
    }

    public String getSysId() {
        return this.sysId;
    }

    public Conversation initiate() throws InvalidSystemIdException, InvalidRequestException, LengthErrorException, NotAuthorisedException, NotAllocatedException, SystemBusyException {
        return this.initiate(null);
    }

    public Conversation initiate(byte[] pipdata) throws InvalidSystemIdException, InvalidRequestException, LengthErrorException, NotAuthorisedException, NotAllocatedException, SystemBusyException {
        Conversation result = null;
        result = AttachInitiator.ALLOCATE(this.getSysId(), this.getProfile(), this.getQueue());
        if (result != null) {
            AttachInitiator.CONNECT_PROCESS(result, result.getConvId(), this.getProcess(), this.getSyncLevel().hashCode(), pipdata);
        }
        return result;
    }

    public void setProcess(String process) throws NullPointerException {
        if (process == null) {
            throw new NullPointerException("null process");
        }
        this.process = process;
    }

    public void setProfile(String profile) throws NullPointerException {
        if (profile == null) {
            throw new NullPointerException("null profile");
        }
        this.profile = profile;
    }

    public void setQueue(boolean queue) {
        this.toQueue = queue;
    }

    public void setSyncLevel(SyncLevel syncLevel) {
        this.syncLevel = syncLevel;
    }

    public void setSysId(String sysId) throws NullPointerException, InvalidSystemIdException {
        if (sysId == null) {
            throw new NullPointerException("null sysId");
        }
        if (sysId.length() == 0) {
            throw new InvalidSystemIdException("empty sysId", 0);
        }
        this.sysId = sysId;
    }
}

