/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.server.CicsRuntimeException;
import com.ibm.cics.server.FutureWrapper;
import com.ibm.cics.server.internal.CICSLogger;
import com.ibm.cics.server.internal.CICSThreadPoolExecutor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CICSExecutorService
implements ExecutorService {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static CICSLogger cicsLog = CICSLogger.getLogger();
    private static final String CLASS_NAME = CICSExecutorService.class.getSimpleName();
    private static final String RESTRICT_RUNASCICS_STRING = "com.ibm.cics.jvmserver.runascics.restrict";
    private static final boolean restrictRunAsCICS = Boolean.getBoolean("com.ibm.cics.jvmserver.runascics.restrict");
    private static boolean isThreadPoolReady;
    private static final int WAIT_PERIOD_MILLIS = 200;
    private static int THREADPOOLTIMEOUT;
    private static ExecutorService cicsExecutor;
    private static ExecutorService libertyExecutor;
    private ThreadPoolExecutor cicsThreadExecutor;
    private ThreadFactory basicThreadFactory;

    public CICSExecutorService() {
        cicsLog.logEntryExit(CLASS_NAME, "constructor", new Object[0]);
        cicsExecutor = this;
    }

    protected void bindBasicThreadFactory(ThreadFactory theFactory) {
        cicsLog.logEntryExit(CLASS_NAME, "bindBasicThreadFactory", new Object[]{theFactory});
        this.basicThreadFactory = theFactory;
    }

    protected void unbindBasicThreadFactory(ThreadFactory theFactory) {
        cicsLog.logEntryExit(CLASS_NAME, "unbindBasicThreadFactory", new Object[]{theFactory});
        this.basicThreadFactory = null;
    }

    protected void bindLibertyExecutor(ExecutorService executor) {
        cicsLog.logEntryExit(CLASS_NAME, "bindLibertyExecutor", new Object[]{executor});
        libertyExecutor = executor;
    }

    protected void unbindLibertyExecutor(ExecutorService executor) {
        cicsLog.logEntryExit(CLASS_NAME, "unbindLibertyExecutor", new Object[]{executor});
        libertyExecutor = null;
    }

    protected void activate(Map<String, Object> componentConfig) {
        cicsLog.logEntry(CLASS_NAME, "activate", new Object[]{componentConfig});
        if (!CommonConstants.THREADPOOL_ACTIVE) {
            this.cicsThreadExecutor = this.createThreadExecutor(componentConfig);
        }
        cicsLog.logExit(CLASS_NAME, "activate", new String[0]);
    }

    protected void modified(Map<String, Object> componentConfig) {
        cicsLog.logEntry(CLASS_NAME, "modified", new Object[]{componentConfig});
        if (!CommonConstants.THREADPOOL_ACTIVE) {
            this.cicsThreadExecutor = this.createThreadExecutor(componentConfig);
        }
        cicsLog.logExit(CLASS_NAME, "modified", new String[0]);
    }

    protected void deactivate() {
        cicsLog.logEntry(CLASS_NAME, "deactivate", new Object[0]);
        this.shutdown();
        this.cicsThreadExecutor = null;
        cicsLog.logExit(CLASS_NAME, "deactivate", new String[0]);
    }

    private ThreadPoolExecutor createThreadExecutor(Map<String, Object> componentConfig) {
        cicsLog.logEntry(CLASS_NAME, "createThreadExecutor", new Object[]{componentConfig});
        RejectedWorkPolicy rejectedWorkPolicy = Enum.valueOf(RejectedWorkPolicy.class, (String)componentConfig.get("rejectedWorkPolicy"));
        RejectedExecutionHandler rejectedExecutionHandler = null;
        rejectedExecutionHandler = rejectedWorkPolicy.equals((Object)RejectedWorkPolicy.ABORT) ? new ThreadPoolExecutor.AbortPolicy() : new ThreadPoolExecutor.CallerRunsPolicy();
        int coreThreads = Integer.parseInt(String.valueOf(componentConfig.get("coreThreads")));
        int maxThreads = Integer.parseInt(String.valueOf(componentConfig.get("maxThreads")));
        long keepAliveMillis = Long.parseLong(String.valueOf(componentConfig.get("keepAlive")));
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        if (this.basicThreadFactory == null) {
            throw new RuntimeException("Internal Error: No BasicThreadFactory has been injected into CICSExecutorService.");
        }
        CICSThreadPoolExecutor singlePool = new CICSThreadPoolExecutor(coreThreads, maxThreads, keepAliveMillis, TimeUnit.MILLISECONDS, workQueue, this.basicThreadFactory, rejectedExecutionHandler);
        cicsLog.logExit(CLASS_NAME, "createThreadExecutor", new Object[]{singlePool});
        return singlePool;
    }

    public static void runAsCICS(Runnable theWork) {
        cicsLog.logEntry(CLASS_NAME, "runAsCICS(Runnable)", new Object[]{theWork});
        if (theWork == null) {
            cicsLog.logError(CLASS_NAME, "runAsCICS", "Runnable passed in is null");
            throw new IllegalArgumentException("The user supplied Runnable 'theWork' is null.");
        }
        CICSExecutorService.isCICSThreadAllowed();
        if (CommonConstants.THREADPOOL_ACTIVE) {
            CICSExecutorService.waitForLibertyThreadPool();
            libertyExecutor.execute(theWork);
        } else {
            cicsExecutor.execute(theWork);
        }
        cicsLog.logExit(CLASS_NAME, "runAsCICS(Runnable)", new String[0]);
    }

    public static <T> Future<T> runAsCICS(Callable<T> theWork) {
        cicsLog.logEntry(CLASS_NAME, "runAsCICS(Callable)", new Object[]{theWork});
        if (theWork == null) {
            cicsLog.logError(CLASS_NAME, "runAsCICS", "Callable passed in is null");
            throw new IllegalArgumentException("The user supplied Callable 'theWork' is null.");
        }
        CICSExecutorService.isCICSThreadAllowed();
        FutureWrapper<T> theResult = new FutureWrapper<T>(theWork);
        if (CommonConstants.THREADPOOL_ACTIVE) {
            CICSExecutorService.waitForLibertyThreadPool();
            libertyExecutor.execute(theResult);
        } else {
            cicsExecutor.execute(theResult);
        }
        cicsLog.logExit(CLASS_NAME, "runAsCICS(Callable)", new Object[]{theResult});
        return theResult;
    }

    private static boolean isCICSThreadAllowed() {
        if (restrictRunAsCICS) {
            throw new CicsRuntimeException("Spawning a CICS Thread is disallowed when 'com.ibm.cics.jvmserver.runascics.restrict' = true");
        }
        return true;
    }

    protected static void waitForLibertyThreadPool() {
        int loop = THREADPOOLTIMEOUT / 200;
        for (int i = 0; !isThreadPoolReady && i < loop; ++i) {
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException ie) {
                cicsLog.logException(CLASS_NAME, "waitForThreadPool", "Interrupted", ie);
            }
        }
    }

    protected static void setThreadPoolReady(boolean value) {
        isThreadPoolReady = value;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (CommonConstants.THREADPOOL_ACTIVE) {
            return libertyExecutor.awaitTermination(timeout, unit);
        }
        return this.cicsThreadExecutor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (CommonConstants.THREADPOOL_ACTIVE) {
            return libertyExecutor.invokeAll(tasks);
        }
        return this.cicsThreadExecutor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (CommonConstants.THREADPOOL_ACTIVE) {
            return libertyExecutor.invokeAll(tasks, timeout, unit);
        }
        return this.cicsThreadExecutor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (CommonConstants.THREADPOOL_ACTIVE) {
            return libertyExecutor.invokeAny(tasks);
        }
        return this.cicsThreadExecutor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (CommonConstants.THREADPOOL_ACTIVE) {
            return libertyExecutor.invokeAny(tasks, timeout, unit);
        }
        return this.cicsThreadExecutor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        if (CommonConstants.THREADPOOL_ACTIVE) {
            return libertyExecutor.isShutdown();
        }
        return this.cicsThreadExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        if (CommonConstants.THREADPOOL_ACTIVE) {
            return libertyExecutor.isTerminated();
        }
        return this.cicsThreadExecutor.isTerminated();
    }

    @Override
    public void shutdown() {
        cicsLog.logEntry(CLASS_NAME, "shutdown", new Object[0]);
        if (this.cicsThreadExecutor == null) {
            return;
        }
        this.cicsThreadExecutor.shutdown();
        boolean terminated = false;
        try {
            terminated = this.cicsThreadExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            cicsLog.logException(CLASS_NAME, "shutdown", "didn't shutdown politely after 10 seconds", e);
        }
        if (!terminated) {
            try {
                this.cicsThreadExecutor.shutdownNow();
                this.cicsThreadExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                cicsLog.logException(CLASS_NAME, "shutdown", "didn't shutdown forcefully after 10 seconds", e);
            }
        }
        cicsLog.logExit(CLASS_NAME, "shutdown", new String[0]);
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (CommonConstants.THREADPOOL_ACTIVE) {
            return null;
        }
        return this.cicsThreadExecutor.shutdownNow();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        cicsLog.logEntry(CLASS_NAME, "submit(Callable)", new Object[]{task});
        Future<T> theFuture = !CommonConstants.THREADPOOL_ACTIVE ? this.cicsThreadExecutor.submit(task) : libertyExecutor.submit(task);
        cicsLog.logExit(CLASS_NAME, "submit(Callable)", new Object[]{theFuture});
        return theFuture;
    }

    @Override
    public Future<?> submit(Runnable task) {
        cicsLog.logEntry(CLASS_NAME, "submit(Runnable)", new Object[]{task});
        Future<?> theFuture = !CommonConstants.THREADPOOL_ACTIVE ? this.cicsThreadExecutor.submit(task) : libertyExecutor.submit(task);
        cicsLog.logExit(CLASS_NAME, "submit(Runnable)", new Object[]{theFuture});
        return theFuture;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        cicsLog.logEntry(CLASS_NAME, "submit(Runnable, Result)", new Object[]{task, result});
        Future<T> theFuture = !CommonConstants.THREADPOOL_ACTIVE ? this.cicsThreadExecutor.submit(task, result) : libertyExecutor.submit(task, result);
        cicsLog.logExit(CLASS_NAME, "submit(Runnable, Result)", new Object[]{theFuture});
        return theFuture;
    }

    @Override
    public void execute(Runnable usersRunnable) {
        cicsLog.logEntry(CLASS_NAME, "execute", new Object[]{usersRunnable});
        if (!CommonConstants.THREADPOOL_ACTIVE) {
            this.cicsThreadExecutor.execute(usersRunnable);
        } else {
            libertyExecutor.execute(usersRunnable);
        }
        cicsLog.logExit(CLASS_NAME, "execute", new String[0]);
    }

    static {
        try {
            THREADPOOLTIMEOUT = Integer.parseInt(System.getProperty("com.ibm.cics.jvmserver.threadpool.timeout"));
        }
        catch (NumberFormatException e) {
            THREADPOOLTIMEOUT = 90000;
        }
    }

    public static enum RejectedWorkPolicy {
        ABORT,
        CALLER_RUNS;

    }
}

