/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.ChildResponse;
import com.ibm.cics.server.ChildResponseImpl;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.NotFinishedException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CICSFuture
extends API
implements Future<ChildResponse> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ChildResponseImpl childResponse;

    protected CICSFuture(byte[] childToken) {
        this.childResponse = new ChildResponseImpl(childToken);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ChildResponseImpl) {
            ChildResponseImpl other = (ChildResponseImpl)obj;
            byte[] otherToken = other.getToken();
            if (Arrays.equals(this.childResponse.getToken(), otherToken)) {
                return true;
            }
        } else if (this.getClass() == obj.getClass()) {
            CICSFuture other = (CICSFuture)obj;
            if (Arrays.equals(this.childResponse.getToken(), other.getChildResponse().getToken())) {
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.childResponse != null) {
            return Arrays.hashCode(this.childResponse.getToken());
        }
        return 0;
    }

    protected ChildResponseImpl getChildResponse() {
        return this.childResponse;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChildResponse get() throws InterruptedException, ExecutionException {
        try {
            this.childResponse = (ChildResponseImpl)this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return this.childResponse;
    }

    @Override
    public ChildResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.childResponse.isFetched()) {
            byte[] childResponseData = null;
            long timeoutMilliSeconds = TimeUnit.MILLISECONDS.convert(timeout, unit);
            if (timeoutMilliSeconds >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Timeout value is too large", new InvalidRequestException(241));
            }
            int cicsTimeout = (int)timeoutMilliSeconds;
            if (timeoutMilliSeconds < 0L) {
                throw new IllegalArgumentException("Timeout value must be positive", new InvalidRequestException(241));
            }
            try {
                childResponseData = CICSFuture.FETCHCHILD(this.childResponse.getToken(), cicsTimeout, false);
            }
            catch (NotFinishedException e) {
                throw new TimeoutException("The child has not yet finished");
            }
            catch (InvalidRequestException e) {
                throw new ExecutionException("Invalid request: the child task has already been freed, or the timeout value is invalid", e);
            }
            if (childResponseData != null) {
                this.childResponse.setResponse(childResponseData, false);
            }
        }
        return this.childResponse;
    }

    @Override
    public boolean isCancelled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDone() {
        byte[] childResponseData = null;
        if (this.childResponse.isFetched()) {
            return true;
        }
        try {
            childResponseData = CICSFuture.FETCHCHILD(this.childResponse.getToken(), 0, true);
            this.childResponse.setCompletionStatus(childResponseData);
            if (this.childResponse.getCompletionStatus() != null) {
                return true;
            }
        }
        catch (InvalidRequestException e) {
            return false;
        }
        catch (NotFinishedException e) {
            return false;
        }
        return false;
    }

    private static final native byte[] FETCHCHILD(byte[] var0, int var1, boolean var2) throws InvalidRequestException, NotFinishedException;
}

