/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.CCSIDErrorException;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.ChannelFactory;
import com.ibm.cics.server.CicsConditionException;
import com.ibm.cics.server.CicsException;
import com.ibm.cics.server.CodePageErrorException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.ContainerIterator;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.Task;
import java.util.ArrayList;
import java.util.ListIterator;

public class Channel
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2004, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final int DEFAULT_CONTAINER_LIST_SIZE = 16;
    static final int DEFAULT_ITERATOR_LIST_SIZE = 2;
    private String name;
    private ArrayList<Container> containerList;
    private ArrayList<ContainerIterator> iteratorList;
    private int containerCount = 0;

    Channel(String channelName) throws ChannelErrorException {
        this(channelName, 16);
    }

    Channel(String channelName, int listSize) throws ChannelErrorException {
        try {
            this.name = ChannelFactory.padName(channelName);
        }
        catch (CicsException e) {
            throw new ChannelErrorException("Channel " + e.getMessage(), 1);
        }
        if (this.name == null) {
            throw new ChannelErrorException("Channel name \"" + channelName + "\"" + " is longer than " + 16 + " characters", 1);
        }
        this.containerList = new ArrayList(listSize);
        this.iteratorList = new ArrayList(2);
    }

    Container findContainer(String containerName) throws ContainerErrorException {
        String tmpName = null;
        try {
            tmpName = ChannelFactory.padName(containerName);
        }
        catch (CicsException e) {
            throw new ContainerErrorException("Container " + e.getMessage(), 18);
        }
        if (tmpName == null) {
            throw new ContainerErrorException("Container name \"" + containerName + "\"" + " is longer than " + 16 + " characters", 18);
        }
        ListIterator<Container> li = this.containerList.listIterator();
        while (li.hasNext()) {
            Container c = li.next();
            if (!c.getName().equals(tmpName)) continue;
            return c;
        }
        return null;
    }

    void add(Container c) {
        if (!this.containerList.contains(c)) {
            this.containerList.add(c);
        }
    }

    void remove(Container c) {
        int i = this.containerList.indexOf(c);
        if (i != -1) {
            this.containerList.remove(i);
            ListIterator<ContainerIterator> li = this.iteratorList.listIterator();
            while (li.hasNext()) {
                ContainerIterator ci = li.next();
                ci.delete(i);
            }
        }
    }

    public Container createContainer(String containerName) throws ContainerErrorException, ChannelErrorException {
        Container c = this.findContainer(containerName);
        if (c != null) {
            throw new ContainerErrorException("Container \"" + containerName + "\"" + " already exists", 18);
        }
        c = new Container(containerName, this);
        this.add(c);
        return c;
    }

    public Container getContainer(String containerName) throws ContainerErrorException {
        Container c = this.findContainer(containerName);
        if (c == null) {
            c = new Container(containerName, this);
            try {
                c.getLength();
                this.add(c);
            }
            catch (CicsConditionException e) {
                c = null;
            }
        } else {
            try {
                c.getLength();
            }
            catch (CicsConditionException e) {
                this.remove(c);
                c = null;
            }
        }
        return c;
    }

    public void deleteContainer(String containerName) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException, InvalidRequestException {
        Container c = this.findContainer(containerName);
        if (c == null) {
            c = new Container(containerName, this);
            try {
                c.get();
                c.delete();
            }
            catch (Exception e) {
                this.remove(c);
                throw new ContainerErrorException("Container \"" + containerName + "\"" + " does not exist", 10);
            }
        } else {
            c.delete();
        }
    }

    public String getName() {
        return this.name;
    }

    public ContainerIterator containerIterator() {
        ContainerIterator ci = null;
        try {
            ci = new ContainerIterator(this, this.containerList);
            this.iteratorList.add(ci);
        }
        catch (CicsConditionException cicsConditionException) {
            // empty catch block
        }
        return ci;
    }

    protected Container returnContainer(String containerName) throws ContainerErrorException {
        Container c = this.findContainer(containerName);
        if (c == null) {
            c = new Container(containerName, this);
            this.add(c);
        }
        return c;
    }

    public void delete() throws ChannelErrorException {
        int i;
        this.DELETE(this.name);
        if (!this.containerList.isEmpty()) {
            for (i = 0; i < this.containerList.size(); ++i) {
                this.containerList.remove(i);
            }
        }
        this.containerList = null;
        if (!this.iteratorList.isEmpty()) {
            for (i = 0; i < this.iteratorList.size(); ++i) {
                this.iteratorList.remove(i);
            }
        }
        this.iteratorList = null;
        Task.getTask().removeChannel(this);
    }

    private final native void DELETE(String var1) throws ChannelErrorException;

    public int getContainerCount() throws ChannelErrorException {
        this.QUERY(this.name);
        return this.containerCount;
    }

    private final native void QUERY(String var1) throws ChannelErrorException;
}

