/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.CicsException;
import java.util.ArrayList;
import java.util.ListIterator;

public class ChannelFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2004, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final int CHANNEL_LIST_SIZE = 16;
    static final int MAX_NAME_LEN = 16;
    private ArrayList<Channel> channelList = new ArrayList(16);

    ChannelFactory(Channel currentChan) {
        if (currentChan != null) {
            this.add(currentChan);
        }
    }

    static String padName(String name) throws CicsException {
        int strLen = name.length();
        if (strLen == 16 && name.indexOf(0) == -1) {
            return name;
        }
        if (strLen > 16) {
            return null;
        }
        StringBuilder sb = new StringBuilder(name);
        sb.setLength(16);
        for (int i = 15; i >= 0 && sb.charAt(i) == '\u0000'; --i) {
            sb.setCharAt(i, ' ');
        }
        String paddedName = sb.toString();
        if (paddedName.indexOf(0) > -1) {
            throw new CicsException("name contains a null character at index " + paddedName.indexOf(0) + ". ");
        }
        if (paddedName.trim().length() == 0) {
            throw new CicsException("name is empty. ");
        }
        return paddedName;
    }

    boolean channelExists(String channelName) throws ChannelErrorException {
        String fullName = null;
        try {
            fullName = ChannelFactory.padName(channelName);
        }
        catch (CicsException e) {
            throw new ChannelErrorException("Channel " + e.getMessage(), 1);
        }
        if (fullName == null) {
            throw new ChannelErrorException("Channel name \"" + channelName + "\"" + " is longer than " + 16 + " characters", 1);
        }
        ListIterator<Channel> li = this.channelList.listIterator();
        while (li.hasNext()) {
            Channel chan = li.next();
            if (!chan.getName().equals(fullName)) continue;
            return true;
        }
        return false;
    }

    void add(Channel chan) {
        this.channelList.add(chan);
    }

    boolean remove(Channel chan) {
        return this.channelList.remove(chan);
    }

    Channel createChannel(String channelName, int listSize) throws ChannelErrorException {
        if (this.channelExists(channelName)) {
            throw new ChannelErrorException("Channel \"" + channelName + "\"" + " already exists", 1);
        }
        Channel chan = new Channel(channelName, listSize);
        this.add(chan);
        return chan;
    }

    protected Channel returnChannel(String channelName) throws ChannelErrorException {
        Channel chan;
        ListIterator<Channel> li = this.channelList.listIterator();
        while (li.hasNext()) {
            chan = li.next();
            if (!chan.getName().equals(channelName)) continue;
            return chan;
        }
        chan = new Channel(channelName, 16);
        this.add(chan);
        return chan;
    }

    protected Channel getChannel(String chanName) {
        String channelName = null;
        try {
            channelName = ChannelFactory.padName(chanName);
        }
        catch (CicsException e) {
            return null;
        }
        Channel result = null;
        Channel chan = null;
        ListIterator<Channel> li = this.channelList.listIterator();
        while (result == null && li.hasNext()) {
            chan = li.next();
            if (!chan.getName().equals(channelName)) continue;
            result = chan;
        }
        return result;
    }
}

