/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.CicsRuntimeException;

public class CicsThreadingRuntimeException
extends CicsRuntimeException {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = -6186727935318534597L;
    private RuntimeException r;
    private String responseMsg;
    private String reasonMsg;
    private int reasonCode;
    private int httpResponseCode = 500;

    public CicsThreadingRuntimeException(RuntimeException r) {
        this.r = r;
        this.reFormat();
    }

    public String getResponse() {
        return this.responseMsg;
    }

    public String getReason() {
        return this.reasonMsg;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    @Override
    public String getMessage() {
        return "Response: " + this.responseMsg + ", Reason: " + this.reasonMsg + ", Code: " + this.reasonCode;
    }

    private void reFormat() {
        try {
            String[] message_parts = this.r.getMessage().split(":");
            this.responseMsg = message_parts[0].trim();
            this.reasonCode = Integer.parseInt(message_parts[1].trim());
        }
        catch (Exception e) {
            this.responseMsg = this.r.getMessage();
            return;
        }
        switch (this.reasonCode) {
            case 38: {
                this.reasonMsg = "GETMAIN FAILED";
                this.httpResponseCode = 500;
                break;
            }
            case 40: {
                this.reasonMsg = "PARSE URL ERROR";
                this.httpResponseCode = 500;
                break;
            }
            case 5: {
                this.reasonMsg = "INSUFFICIENT STORAGE";
                this.httpResponseCode = 500;
                break;
            }
            case 49: {
                this.reasonMsg = "ATTACH ERROR";
                this.httpResponseCode = 500;
                break;
            }
            case 50: {
                this.reasonMsg = "TRANSACTION NOT FOUND";
                this.httpResponseCode = 500;
                break;
            }
            case 51: {
                this.reasonMsg = "BUILD TRANSACTION ERROR";
                this.httpResponseCode = 500;
                break;
            }
            case 41: {
                this.reasonMsg = "URIMAP TYPE ERROR";
                this.httpResponseCode = 500;
                break;
            }
            case 42: {
                this.reasonMsg = "LOCATE URIMAP ERROR";
                this.httpResponseCode = 500;
                break;
            }
            case 48: {
                this.reasonMsg = "TRANSACTION DISABLED";
                this.httpResponseCode = 503;
                break;
            }
            case 46: {
                this.reasonMsg = "TRANSACTION PURGED";
                this.httpResponseCode = 503;
                break;
            }
            case 44: {
                this.reasonMsg = "URIMAP DISABLED";
                this.httpResponseCode = 503;
                break;
            }
            case 47: {
                this.reasonMsg = "TRANSACTION ID NOT AUTH";
                this.httpResponseCode = 403;
                break;
            }
            case 43: {
                this.reasonMsg = "URIMAP SCHEME ERROR";
                this.httpResponseCode = 403;
                break;
            }
            case 45: {
                this.reasonMsg = "URIMAP UNAVAILABLE";
                this.httpResponseCode = 404;
                break;
            }
            default: {
                this.reasonMsg = "INTERNAL ERROR";
                this.httpResponseCode = 500;
            }
        }
    }
}

