/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.domains.Dfhpgchj;
import com.ibm.cics.domains.Dfhpgcrj;
import com.ibm.cics.domains.DomainResponse;
import com.ibm.cics.server.API;
import com.ibm.cics.server.CCSIDErrorException;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.ChannelFactory;
import com.ibm.cics.server.CicsException;
import com.ibm.cics.server.CodePageErrorException;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.InvalidRequestException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class Container
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2004, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NOTSET = -1;
    public static final int DATATYPE_BIT = 1020;
    public static final int DATATYPE_CHAR = 1019;
    private String name;
    private Channel owner;
    private Channel savedOwner;
    private int ccsid = -1;
    private boolean dataInCICS;
    private static final int RESP2_INVALID_CODEPAGE = 1;
    private static String CCSID = System.getProperty("com.ibm.cics.jvmserver.supplied.ccsid");
    private static Charset JAVA_CHARSET;
    private static String JAVA_CHARSET_NAME;

    Container(String containerName, Channel chan) throws ContainerErrorException {
        try {
            this.name = ChannelFactory.padName(containerName);
        }
        catch (CicsException e) {
            throw new ContainerErrorException("Container " + e.getMessage(), 18);
        }
        if (this.name == null) {
            throw new ContainerErrorException("Container name \"" + containerName + "\"" + " is longer than " + 16 + " characters", 18);
        }
        this.owner = chan;
        this.dataInCICS = false;
    }

    private void checkOwner() throws ContainerErrorException {
        if (this.owner == null) {
            throw new ContainerErrorException("Container \"" + this.name + "\"" + " not found", 10);
        }
    }

    protected String getChannelName() {
        return this.owner.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getString() throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        this.checkOwner();
        byte[] ba = this.GET(this.name, this.owner.getName(), JAVA_CHARSET_NAME, false, -1, -1);
        this.dataInCICS = true;
        return new String(ba, JAVA_CHARSET);
    }

    public byte[] get() throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        this.checkOwner();
        byte[] ba = this.GET(this.name, this.owner.getName(), null, false, -1, -1);
        this.dataInCICS = true;
        return ba;
    }

    public byte[] get(String intoCodePage) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        this.checkOwner();
        if (intoCodePage == null) {
            throw new CodePageErrorException("Null Codepage", 1);
        }
        intoCodePage = Container.spacePad(intoCodePage, 40);
        byte[] ba = this.GET(this.name, this.owner.getName(), intoCodePage, false, -1, -1);
        this.dataInCICS = true;
        return ba;
    }

    public byte[] get(String intoCodePage, int offset, int length) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        this.checkOwner();
        if (intoCodePage == null) {
            throw new CodePageErrorException("Null Codepage", 1);
        }
        intoCodePage = Container.spacePad(intoCodePage, 40);
        byte[] ba = this.GET(this.name, this.owner.getName(), intoCodePage, false, length, offset < 0 ? 0 : offset);
        this.dataInCICS = true;
        return ba;
    }

    public byte[] getNoConvert() throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        this.checkOwner();
        byte[] ba = this.GET(this.name, this.owner.getName(), null, true, -1, -1);
        this.dataInCICS = true;
        return ba;
    }

    public byte[] getNoConvert(int offset, int length) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        this.checkOwner();
        byte[] ba = this.GET(this.name, this.owner.getName(), null, true, length, offset < 0 ? 0 : offset);
        this.dataInCICS = true;
        return ba;
    }

    public byte[] get(int offset, int length) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        this.checkOwner();
        byte[] ba = this.GET(this.name, this.owner.getName(), null, false, length, offset < 0 ? 0 : offset);
        this.dataInCICS = true;
        return ba;
    }

    public int getLength() throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        this.checkOwner();
        int len = this.GETLENGTH(this.name, this.owner.getName(), null, false);
        this.dataInCICS = true;
        return len;
    }

    public int getLength(String intoCodePage) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        this.checkOwner();
        if (intoCodePage == null) {
            throw new CodePageErrorException("Null Codepage", 1);
        }
        intoCodePage = Container.spacePad(intoCodePage, 40);
        int len = this.GETLENGTH(this.name, this.owner.getName(), intoCodePage, false);
        this.dataInCICS = true;
        return len;
    }

    public int getLengthNoConvert() throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException {
        this.checkOwner();
        int len = this.GETLENGTH(this.name, this.owner.getName(), null, true);
        this.dataInCICS = true;
        return len;
    }

    public int getCCSID() {
        return this.ccsid;
    }

    public int getDatatype() throws ContainerErrorException, ChannelErrorException {
        this.checkOwner();
        String channelName = this.owner.getName();
        Dfhpgchj dfhpgchj = new Dfhpgchj();
        dfhpgchj.setChannelName(channelName);
        dfhpgchj.setFunction((byte)1);
        dfhpgchj.setExistence(7);
        try {
            dfhpgchj.invoke();
        }
        catch (DomainResponse e) {
            if (2 == dfhpgchj.getResponse() && 1 == dfhpgchj.getReason()) {
                if (!this.dataInCICS) {
                    return -1;
                }
                throw new ChannelErrorException("Channel \"" + channelName + "\"" + " not found", 1);
            }
            throw new ChannelErrorException("Channel \"" + channelName + "\"" + " error. Response " + dfhpgchj.getReason() + " reason " + dfhpgchj.getReason());
        }
        int poolToken = dfhpgchj.getContainerPoolToken();
        byte type = this.getContainerDatatype(poolToken);
        if (1 == type) {
            return 1019;
        }
        if (2 == type) {
            return 1020;
        }
        return -1;
    }

    private byte getContainerDatatype(int poolToken) throws ContainerErrorException {
        byte type;
        Dfhpgcrj dfhpgcrj = new Dfhpgcrj();
        dfhpgcrj.setContainerName(this.name);
        dfhpgcrj.setPoolToken(poolToken);
        dfhpgcrj.setFunction((byte)7);
        dfhpgcrj.setExistence(12);
        try {
            dfhpgcrj.invoke();
            type = dfhpgcrj.getDatatype();
            this.dataInCICS = true;
        }
        catch (DomainResponse e) {
            if (2 == dfhpgcrj.getResponse() && 6 == dfhpgcrj.getReason()) {
                if (!this.dataInCICS) {
                    type = 0;
                }
                throw new ContainerErrorException("Container \"" + this.name + "\"" + " not found", 10);
            }
            throw new ContainerErrorException("Container \"" + this.name + "\"" + " error. Response " + dfhpgcrj.getReason() + " reason " + dfhpgcrj.getReason());
        }
        return type;
    }

    public void append(byte[] byteArrayData) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        this.putContainerCheckParmsAndCall(byteArrayData, null, -1, true);
    }

    public void put(byte[] byteArrayData) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        this.putContainerCheckParmsAndCall(byteArrayData, null, -1, false);
    }

    private void putContainerCheckParmsAndCall(byte[] byteArrayData, String fromCodepage, int datatype, boolean append) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        if (this.owner == null) {
            Container con = this.savedOwner.findContainer(this.name);
            if (con != null) {
                throw new ContainerErrorException("Container \"" + this.name + "\"" + " already exists", 18);
            }
            this.owner = this.savedOwner;
            this.owner.add(this);
        }
        this.PUT(byteArrayData, this.name, this.owner.getName(), fromCodepage, datatype, append);
        this.dataInCICS = true;
    }

    public void append(byte[] byteArrayData, String fromCodePage) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        if (fromCodePage == null) {
            throw new CodePageErrorException("Null Codepage", 1);
        }
        fromCodePage = Container.spacePad(fromCodePage, 40);
        this.putContainerCheckParmsAndCall(byteArrayData, fromCodePage, 1019, true);
    }

    public void put(byte[] byteArrayData, String fromCodePage) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        if (fromCodePage == null) {
            throw new CodePageErrorException("Null Codepage", 1);
        }
        fromCodePage = Container.spacePad(fromCodePage, 40);
        this.putContainerCheckParmsAndCall(byteArrayData, fromCodePage, 1019, false);
    }

    public void appendString(String stringData) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        byte[] value = stringData == null ? null : stringData.getBytes(JAVA_CHARSET);
        this.putContainerCheckParmsAndCall(value, JAVA_CHARSET_NAME, 1019, true);
    }

    @Deprecated
    public void put(String stringData) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        byte[] value;
        if (stringData == null) {
            value = null;
        } else {
            try {
                value = stringData.getBytes(CCSID);
            }
            catch (UnsupportedEncodingException e) {
                value = stringData.getBytes();
            }
        }
        this.putContainerCheckParmsAndCall(value, null, -1, false);
    }

    public void putString(String stringData) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException {
        byte[] value = stringData == null ? null : stringData.getBytes(JAVA_CHARSET);
        this.putContainerCheckParmsAndCall(value, JAVA_CHARSET_NAME, 1019, false);
    }

    public void delete() throws ContainerErrorException, ChannelErrorException, InvalidRequestException {
        this.checkOwner();
        this.owner.remove(this);
        if (this.dataInCICS) {
            this.DELETE(this.name, this.owner.getName());
            this.dataInCICS = false;
        }
        this.savedOwner = this.owner;
        this.owner = null;
    }

    protected void setDataInCICS() {
        this.dataInCICS = true;
    }

    private static String spacePad(String dataIn, int newLength) {
        if (dataIn == null) {
            return null;
        }
        StringBuilder dataOut = new StringBuilder(newLength);
        dataOut.append(dataIn);
        if (newLength > 0) {
            int spaces = newLength - dataIn.length();
            for (int i = 0; i < spaces; ++i) {
                dataOut.append(" ");
            }
            return dataOut.toString();
        }
        return dataIn;
    }

    private final native byte[] GET(String var1, String var2, String var3, boolean var4, int var5, int var6) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException;

    private final native void PUT(byte[] var1, String var2, String var3, String var4, int var5, boolean var6) throws ContainerErrorException, ChannelErrorException, InvalidRequestException, CCSIDErrorException, CodePageErrorException;

    private final native void DELETE(String var1, String var2) throws ContainerErrorException, ChannelErrorException, InvalidRequestException;

    private final native int GETLENGTH(String var1, String var2, String var3, boolean var4) throws ContainerErrorException, ChannelErrorException, CCSIDErrorException, CodePageErrorException;

    static {
        if (CCSID == null) {
            CCSID = System.getProperty("com.ibm.cics.jvmserver.local.ccsid");
        }
        JAVA_CHARSET = Charset.forName("UTF-16");
        JAVA_CHARSET_NAME = Container.spacePad(JAVA_CHARSET.name(), 40);
    }
}

