/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.CicsConditionException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.EndException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.TokenErrorException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ContainerIterator
extends API
implements Iterator<Container> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2004, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Object owner;
    private List<Container> containerList;
    private boolean hasMore;
    private int browseToken;
    private int nextIndex;
    private int hasNextIndex;

    ContainerIterator(Object chan, List<Container> list) throws ChannelErrorException, NotAuthorisedException {
        this.owner = chan;
        this.containerList = list;
        this.hasMore = true;
        this.nextIndex = -1;
        this.hasNextIndex = -1;
        this.browseToken = this.STARTBROWSE(((Channel)this.owner).getName());
    }

    void delete(int index) {
        if (index <= this.hasNextIndex) {
            --this.hasNextIndex;
            --this.nextIndex;
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    @Override
    public boolean hasNext() {
        if (this.hasMore) {
            try {
                String cName = this.GETNEXT(this.browseToken);
                if (((Channel)this.owner).findContainer(cName) == null) {
                    Container newC = ((Channel)this.owner).createContainer(cName);
                    newC.setDataInCICS();
                }
                ++this.hasNextIndex;
            }
            catch (CicsConditionException cce1) {
                this.hasMore = false;
                try {
                    this.ENDBROWSE(this.browseToken);
                }
                catch (CicsConditionException cicsConditionException) {
                    // empty catch block
                }
            }
        }
        return this.hasMore;
    }

    @Override
    public Container next() throws NoSuchElementException {
        Container c = null;
        if (this.hasMore) {
            if (this.hasNextIndex > this.nextIndex) {
                c = this.containerList.get(this.hasNextIndex);
            } else if (this.hasNext()) {
                c = this.containerList.get(this.hasNextIndex);
            } else {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
        } else {
            throw new NoSuchElementException();
        }
        return c;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("remove()");
    }

    native int STARTBROWSE(String var1) throws ChannelErrorException, NotAuthorisedException;

    native String GETNEXT(int var1) throws EndException, LogicException, TokenErrorException;

    native void ENDBROWSE(int var1) throws LogicException, TokenErrorException;
}

