/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.ConversationSendOptions;
import com.ibm.cics.server.ConversationState;
import com.ibm.cics.server.DataHolder;
import com.ibm.cics.server.EndOfChainIndicatorException;
import com.ibm.cics.server.InboundSignalException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAllocatedException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.SyncLevel;
import com.ibm.cics.server.TerminalException;
import java.util.BitSet;

public class Conversation
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2003, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private BitSet bits;
    private static final int NUMBER_OF_BITS = 9;
    private static final int EIBCOMPL = 0;
    private static final int EIBSIG = 1;
    private static final int EIBERR = 2;
    private static final int EIBNODAT = 3;
    private static final int ABEND = 1;
    private static final int CONFIRMATION = 2;
    private static final int ERROR = 3;
    private static final int PREPARE = 4;
    private static final int SIGNAL = 5;
    private byte[] convId;
    private SyncLevel syncLevel = SyncLevel.NONE;
    private int errorCode;

    Conversation() {
        this.bits = new BitSet(9);
    }

    public void converse(DataHolder data) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        Conversation.CONVERSE(this, this.getConvId(), data, 0, false);
    }

    public void converse(DataHolder data, int maxLength, boolean retainExcess) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        Conversation.CONVERSE(this, this.getConvId(), data, maxLength, retainExcess);
    }

    static final native int CONVERSE(Object var0, byte[] var1, DataHolder var2, int var3, boolean var4) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException;

    public void flush() throws InvalidRequestException, NotAllocatedException {
        Conversation.WAIT_CONVID(this, this.getConvId());
    }

    public void free() throws InvalidRequestException, NotAllocatedException, NotAuthorisedException, InvalidSystemIdException {
        Conversation.FREE(this, this.getConvId());
    }

    static final native int FREE(Object var0, byte[] var1) throws InvalidRequestException, NotAllocatedException, NotAuthorisedException, InvalidSystemIdException;

    static final native int GET_STATE(Object var0, byte[] var1);

    public byte[] getConvId() {
        return this.convId;
    }

    public boolean getDataComplete() {
        return this.bits.get(0);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean getErrorOccurred() {
        return this.bits.get(2);
    }

    public boolean getNoData() {
        return this.bits.get(3);
    }

    public boolean getSignalReceived() {
        return this.bits.get(1);
    }

    public ConversationState getState() {
        return ConversationState.lookup(Conversation.GET_STATE(this, this.convId));
    }

    public SyncLevel getSyncLevel() {
        return this.syncLevel;
    }

    static final native int ISSUE_CONTROL(Object var0, byte[] var1, int var2) throws InvalidRequestException, NotAllocatedException, TerminalException;

    public void issueAbend() throws InvalidRequestException, NotAllocatedException, TerminalException {
        Conversation.ISSUE_CONTROL(this, this.getConvId(), 1);
    }

    public void issueConfirmation() throws InvalidRequestException, NotAllocatedException, TerminalException {
        Conversation.ISSUE_CONTROL(this, this.getConvId(), 2);
    }

    public void issueError() throws InvalidRequestException, NotAllocatedException, TerminalException {
        Conversation.ISSUE_CONTROL(this, this.getConvId(), 3);
    }

    public void issuePrepare() throws InvalidRequestException, NotAllocatedException, TerminalException {
        Conversation.ISSUE_CONTROL(this, this.getConvId(), 4);
    }

    public void issueSignal() throws InvalidRequestException, NotAllocatedException, TerminalException {
        Conversation.ISSUE_CONTROL(this, this.getConvId(), 5);
    }

    public void receive(DataHolder data) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        Conversation.RECEIVE(this, this.getConvId(), data, 0, false);
    }

    public void receive(DataHolder data, int maxLength, boolean retainExcess) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        Conversation.RECEIVE(this, this.getConvId(), data, maxLength, retainExcess);
    }

    static final native int RECEIVE(Object var0, byte[] var1, DataHolder var2, int var3, boolean var4) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException;

    public void send(byte[] data) throws InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        Conversation.SEND(this, this.getConvId(), data, false, false, false, false);
    }

    public void send(byte[] data, ConversationSendOptions options) throws InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        Conversation.SEND(this, this.getConvId(), data, options.getInvite(), options.getLast(), options.getConfirm(), options.getWait());
    }

    public void send(ConversationSendOptions options) throws InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException {
        Conversation.SEND(this, this.getConvId(), null, options.getInvite(), options.getLast(), options.getConfirm(), options.getWait());
    }

    static final native int SEND(Object var0, byte[] var1, byte[] var2, boolean var3, boolean var4, boolean var5, boolean var6) throws InvalidRequestException, LengthErrorException, NotAllocatedException, InboundSignalException, TerminalException;

    void setBits(boolean dataComplete, boolean signalReceived, boolean errorOccurred, boolean noData) {
        if (dataComplete) {
            this.bits.set(0);
        } else {
            this.bits.clear(0);
        }
        if (signalReceived) {
            this.bits.set(1);
        } else {
            this.bits.clear(1);
        }
        if (errorOccurred) {
            this.bits.set(2);
        } else {
            this.bits.clear(2);
        }
        if (noData) {
            this.bits.set(3);
        } else {
            this.bits.clear(3);
        }
    }

    void setConvId(byte[] convId) {
        this.convId = convId;
    }

    void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    void setSyncLevel(int syncLevelValue) {
        this.syncLevel = SyncLevel.lookup(syncLevelValue);
    }

    void setSyncLevel(SyncLevel syncLevel) {
        this.syncLevel = syncLevel;
    }

    static final native int WAIT_CONVID(Object var0, byte[] var1) throws InvalidRequestException, NotAllocatedException;
}

