/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

public class Cursor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2001, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static byte[] sbaMapping = new byte[64];
    private int column;
    private int row;
    private int width;
    private int height;
    private int screenSize;

    public Cursor(int width, int height) {
        this(width, height, 1, 1);
    }

    public Cursor(int width, int height, int column, int row) {
        this.width = width;
        this.height = height;
        this.column = column;
        this.row = row;
        this.screenSize = width * height;
    }

    public void decrement() {
        if (this.column == 1) {
            this.column = this.width;
            this.row = this.row == 1 ? this.height : --this.row;
        } else {
            --this.column;
        }
    }

    public void increment() {
        if (this.column == this.width) {
            this.column = 1;
            this.row = this.row == this.height ? 1 : ++this.row;
        } else {
            ++this.column;
        }
    }

    public void increment(int extra) {
        int originalPosition = 0;
        int finalPosition = 0;
        if (this.column + extra > this.width) {
            originalPosition = (this.row - 1) * this.width + (this.column - 1);
            finalPosition = (originalPosition + extra) % this.screenSize;
            this.row = finalPosition / this.width + 1;
            this.column = finalPosition % this.width + 1;
        } else {
            this.column += extra;
        }
    }

    public void incrementRow() {
        this.row = this.row == this.height ? 1 : ++this.row;
    }

    public void setColumn(int newColumn) {
        this.column = newColumn;
    }

    public void setRow(int newRow) {
        this.row = newRow;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public int toBinary() {
        int binaryValue = 0;
        binaryValue = (this.row - 1) * this.width + (this.column - 1);
        return binaryValue;
    }

    void toSBA(byte[] Buffer2) {
        int posLSB = 0;
        int posMSB = 0;
        if (Buffer2.length >= 3) {
            Buffer2[0] = 17;
            posLSB = posMSB = (this.row - 1) * this.width + (this.column - 1);
            Buffer2[1] = sbaMapping[posMSB >>= 6];
            Buffer2[2] = sbaMapping[posLSB &= 0x3F];
        }
    }

    static {
        Cursor.sbaMapping[0] = 32;
        Cursor.sbaMapping[1] = 65;
        Cursor.sbaMapping[2] = 66;
        Cursor.sbaMapping[3] = 67;
        Cursor.sbaMapping[4] = 68;
        Cursor.sbaMapping[5] = 69;
        Cursor.sbaMapping[6] = 70;
        Cursor.sbaMapping[7] = 71;
        Cursor.sbaMapping[8] = 72;
        Cursor.sbaMapping[9] = 73;
        Cursor.sbaMapping[10] = 91;
        Cursor.sbaMapping[11] = 46;
        Cursor.sbaMapping[12] = 60;
        Cursor.sbaMapping[13] = 40;
        Cursor.sbaMapping[14] = 43;
        Cursor.sbaMapping[15] = 33;
        Cursor.sbaMapping[16] = 38;
        Cursor.sbaMapping[17] = 74;
        Cursor.sbaMapping[18] = 75;
        Cursor.sbaMapping[19] = 76;
        Cursor.sbaMapping[20] = 77;
        Cursor.sbaMapping[21] = 78;
        Cursor.sbaMapping[22] = 79;
        Cursor.sbaMapping[23] = 80;
        Cursor.sbaMapping[24] = 81;
        Cursor.sbaMapping[25] = 82;
        Cursor.sbaMapping[26] = 93;
        Cursor.sbaMapping[27] = 36;
        Cursor.sbaMapping[28] = 42;
        Cursor.sbaMapping[29] = 41;
        Cursor.sbaMapping[30] = 59;
        Cursor.sbaMapping[31] = 94;
        Cursor.sbaMapping[32] = 45;
        Cursor.sbaMapping[33] = 47;
        Cursor.sbaMapping[34] = 83;
        Cursor.sbaMapping[35] = 84;
        Cursor.sbaMapping[36] = 85;
        Cursor.sbaMapping[37] = 86;
        Cursor.sbaMapping[38] = 87;
        Cursor.sbaMapping[39] = 88;
        Cursor.sbaMapping[40] = 89;
        Cursor.sbaMapping[41] = 90;
        Cursor.sbaMapping[42] = 124;
        Cursor.sbaMapping[43] = 44;
        Cursor.sbaMapping[44] = 37;
        Cursor.sbaMapping[45] = 95;
        Cursor.sbaMapping[46] = 62;
        Cursor.sbaMapping[47] = 63;
        Cursor.sbaMapping[48] = 48;
        Cursor.sbaMapping[49] = 49;
        Cursor.sbaMapping[50] = 50;
        Cursor.sbaMapping[51] = 51;
        Cursor.sbaMapping[52] = 52;
        Cursor.sbaMapping[53] = 53;
        Cursor.sbaMapping[54] = 54;
        Cursor.sbaMapping[55] = 55;
        Cursor.sbaMapping[56] = 56;
        Cursor.sbaMapping[57] = 57;
        Cursor.sbaMapping[58] = 58;
        Cursor.sbaMapping[59] = 35;
        Cursor.sbaMapping[60] = 64;
        Cursor.sbaMapping[61] = 39;
        Cursor.sbaMapping[62] = 61;
        Cursor.sbaMapping[63] = 34;
        String osArch = System.getProperty("os.arch");
        if (osArch.equals("390") || osArch.equals("s390") || osArch.equals("s390x")) {
            Cursor.sbaMapping[10] = -94;
            Cursor.sbaMapping[15] = 124;
            Cursor.sbaMapping[26] = 33;
            Cursor.sbaMapping[42] = -90;
        }
    }
}

