/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.server.API;
import com.ibm.cics.server.DocumentLocation;
import com.ibm.cics.server.DuplicateRecordException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.SymbolErrorException;
import com.ibm.cics.server.SymbolList;
import com.ibm.cics.server.TemplateErrorException;
import java.io.UnsupportedEncodingException;

public class Document
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NOTSET = -1;
    private byte[] docToken;
    private int docSize = -1;
    private byte[] doc;
    private boolean docDeleted = false;
    private static final int RESP2_DOCUMENT_NOTFND = 1;
    private static final int RESP2_FROM_DOCUMENT_DELETED = 2;

    private native void CREATE() throws InvalidRequestException;

    private native void INSERT(byte[] var1, byte[] var2, byte[] var3, byte[] var4, int var5, String var6, String var7, byte[] var8, String var9, String var10, String var11, String var12) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException;

    private native void RETRIEVE(byte[] var1, String var2, boolean var3) throws InvalidRequestException;

    private native void SET(byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, char var6, boolean var7) throws InvalidRequestException, RecordNotFoundException, SymbolErrorException, LengthErrorException;

    private native void DELETE(byte[] var1) throws RecordNotFoundException;

    public Document() throws InvalidRequestException {
        this.CREATE();
    }

    public Document(byte[] docToken) {
        this.docToken = docToken;
    }

    public void createFromDocRetrieve(byte[] from) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, from, null, null, from.length, null, null, null, null, null, null, null);
    }

    public void createFromTemplate(String from) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        try {
            this.INSERT(this.docToken, from.getBytes(CommonConstants.LOCALCCSID), null, null, from.length(), null, null, null, null, null, null, null);
        }
        catch (UnsupportedEncodingException e) {
            this.INSERT(this.docToken, from.getBytes(), null, null, from.length(), null, null, null, null, null, null, null);
        }
    }

    public void createText(String text) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        this.createText(text, null);
    }

    public void createText(String text, String hostCodePage) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        hostCodePage = this.spacePad(hostCodePage, 8);
        try {
            this.INSERT(this.docToken, null, text.getBytes(CommonConstants.LOCALCCSID), null, text.length(), null, null, null, null, hostCodePage, null, null);
        }
        catch (UnsupportedEncodingException e) {
            this.INSERT(this.docToken, null, text.getBytes(), null, text.length(), null, null, null, null, hostCodePage, null, null);
        }
    }

    public void createBinary(byte[] binary) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, null, null, binary, binary.length, null, null, null, null, null, null, null);
    }

    public void createFromDoc(Document fromDoc) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        try {
            fromDoc.getDocToken();
        }
        catch (Exception e) {
            throw new RecordNotFoundException("fromDoc deleted", 2);
        }
        this.INSERT(this.docToken, null, null, null, -1, null, null, fromDoc.getDocToken(), null, null, null, null);
    }

    public void createTemplate(String template) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        this.createTemplate(template, null);
    }

    public void createTemplate(String template, String hostCodePage) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        hostCodePage = this.spacePad(hostCodePage, 8);
        template = this.spacePad(template, 48);
        this.INSERT(this.docToken, null, null, null, -1, null, template, null, null, hostCodePage, null, null);
    }

    public byte[] getDocToken() throws RecordNotFoundException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        return this.docToken;
    }

    public int getDocSize() throws RecordNotFoundException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        return this.docSize;
    }

    public void appendFromDocRetrieve(byte[] from) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, from, null, null, from.length, null, null, null, null, null, null, null);
    }

    public void appendFromTemplate(String from) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        try {
            this.INSERT(this.docToken, from.getBytes(CommonConstants.LOCALCCSID), null, null, from.length(), null, null, null, null, null, null, null);
        }
        catch (UnsupportedEncodingException e) {
            this.INSERT(this.docToken, from.getBytes(), null, null, from.length(), null, null, null, null, null, null, null);
        }
    }

    public void appendBinary(byte[] binary) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, null, null, binary, binary.length, null, null, null, null, null, null, null);
    }

    public void appendText(String text) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        this.appendText(text, null);
    }

    public void appendText(String text, String hostCodePage) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        hostCodePage = this.spacePad(hostCodePage, 8);
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        try {
            this.INSERT(this.docToken, null, text.getBytes(CommonConstants.LOCALCCSID), null, text.length(), null, null, null, null, hostCodePage, null, null);
        }
        catch (UnsupportedEncodingException e) {
            this.INSERT(this.docToken, null, text.getBytes(), null, text.length(), null, null, null, null, hostCodePage, null, null);
        }
    }

    public void appendLine(String text, String hostCodePage) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        int textLen = text.length();
        byte[] baText = new byte[textLen + 2];
        try {
            baText = text.getBytes(CommonConstants.LOCALCCSID);
        }
        catch (UnsupportedEncodingException e) {
            baText = text.getBytes();
        }
        baText[textLen] = 13;
        baText[textLen + 1] = 37;
        hostCodePage = this.spacePad(hostCodePage, 8);
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, null, baText, null, textLen + 2, null, null, null, null, hostCodePage, null, null);
    }

    public void appendCRLF() throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        byte[] newLine = new byte[]{13, 37};
        this.INSERT(this.docToken, null, newLine, null, 2, null, null, null, null, null, null, null);
    }

    public void appendSymbol(String symbol) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        this.appendSymbol(symbol, null);
    }

    public void appendSymbol(String symbol, String hostCodePage) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        symbol = this.spacePad(symbol, 32);
        hostCodePage = this.spacePad(hostCodePage, 8);
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, null, null, null, -1, symbol, null, null, null, hostCodePage, null, null);
    }

    public void appendTemplate(String template) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        this.appendTemplate(template, null);
    }

    public void appendTemplate(String template, String hostCodePage) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        template = this.spacePad(template, 48);
        hostCodePage = this.spacePad(hostCodePage, 8);
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, null, null, null, -1, null, template, null, null, hostCodePage, null, null);
    }

    public void appendDocument(Document doc) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, null, null, null, -1, null, null, doc.getDocToken(), null, null, null, null);
    }

    public void appendBookmark(String bookmark) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        bookmark = this.spacePad(bookmark, 16);
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, null, null, null, -1, null, null, null, bookmark, null, null, null);
    }

    public void insertFromDocRetrieve(byte[] from, DocumentLocation locn) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, from, null, null, from.length, null, null, null, null, null, locn.getAt(), locn.getTo());
    }

    public void insertFromTemplate(String from, DocumentLocation locn) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        try {
            this.INSERT(this.docToken, from.getBytes(CommonConstants.LOCALCCSID), null, null, from.length(), null, null, null, null, null, locn.getAt(), locn.getTo());
        }
        catch (UnsupportedEncodingException e) {
            this.INSERT(this.docToken, from.getBytes(), null, null, from.length(), null, null, null, null, null, locn.getAt(), locn.getTo());
        }
    }

    public void insertBinary(byte[] binary, DocumentLocation locn) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, null, null, binary, binary.length, null, null, null, null, null, locn.getAt(), locn.getTo());
    }

    public void insertText(String text, DocumentLocation locn) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        this.insertText(text, null, locn);
    }

    public void insertText(String text, String hostCodePage, DocumentLocation locn) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        hostCodePage = this.spacePad(hostCodePage, 8);
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        try {
            this.INSERT(this.docToken, null, text.getBytes(CommonConstants.LOCALCCSID), null, text.length(), null, null, null, null, hostCodePage, locn.getAt(), locn.getTo());
        }
        catch (UnsupportedEncodingException e) {
            this.INSERT(this.docToken, null, text.getBytes(), null, text.length(), null, null, null, null, hostCodePage, locn.getAt(), locn.getTo());
        }
    }

    public void insertSymbol(String symbol, DocumentLocation locn) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        this.insertSymbol(symbol, null, locn);
    }

    public void insertSymbol(String symbol, String hostCodePage, DocumentLocation locn) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        symbol = this.spacePad(symbol, 32);
        hostCodePage = this.spacePad(hostCodePage, 8);
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, null, null, null, -1, symbol, null, null, null, hostCodePage, locn.getAt(), locn.getTo());
    }

    public void insertTemplate(String template, DocumentLocation locn) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        this.insertTemplate(template, null, locn);
    }

    public void insertTemplate(String template, String hostCodePage, DocumentLocation locn) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        template = this.spacePad(template, 48);
        hostCodePage = this.spacePad(hostCodePage, 8);
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, null, null, null, -1, null, template, null, null, hostCodePage, locn.getAt(), locn.getTo());
    }

    public void insertDocument(Document doc, DocumentLocation locn) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        try {
            doc.getDocToken();
        }
        catch (Exception e) {
            throw new RecordNotFoundException("fromDoc deleted", 2);
        }
        this.INSERT(this.docToken, null, null, null, -1, null, null, doc.getDocToken(), null, null, locn.getAt(), locn.getTo());
    }

    public void insertBookmark(String bookmark, DocumentLocation locn) throws DuplicateRecordException, InvalidRequestException, NotAuthorisedException, RecordNotFoundException, TemplateErrorException {
        bookmark = this.spacePad(bookmark, 16);
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.INSERT(this.docToken, null, null, null, -1, null, null, null, bookmark, null, locn.getAt(), locn.getTo());
    }

    public byte[] retrieve() throws InvalidRequestException, RecordNotFoundException {
        return this.retrieve(null, true);
    }

    public byte[] retrieve(String characterset) throws InvalidRequestException, RecordNotFoundException {
        return this.retrieve(characterset, false);
    }

    public byte[] retrieve(String characterset, boolean dataOnly) throws InvalidRequestException, RecordNotFoundException {
        if (characterset != null) {
            characterset = this.spacePad(characterset, 40);
        }
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.RETRIEVE(this.docToken, characterset, dataOnly);
        return this.doc;
    }

    public void addSymbol(String symbol, String value) throws InvalidRequestException, RecordNotFoundException, SymbolErrorException, LengthErrorException {
        int len;
        symbol = this.spacePad(symbol, 32);
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        byte[] value_bytes = null;
        if (value != null) {
            try {
                value_bytes = value.getBytes(CommonConstants.LOCALCCSID);
                len = value_bytes.length;
            }
            catch (UnsupportedEncodingException e) {
                value_bytes = value.getBytes();
                len = value_bytes.length;
            }
        } else {
            len = -1;
        }
        try {
            this.SET(this.docToken, symbol.getBytes(CommonConstants.LOCALCCSID), value_bytes, len, null, '&', false);
        }
        catch (UnsupportedEncodingException e) {
            this.SET(this.docToken, symbol.getBytes(), value_bytes, len, null, '&', false);
        }
    }

    public void setSymbolList(SymbolList symbolList) throws InvalidRequestException, RecordNotFoundException, SymbolErrorException, LengthErrorException {
        if (symbolList != null) {
            if (this.docDeleted) {
                throw new RecordNotFoundException("Document deleted", 1);
            }
            this.SET(this.docToken, null, null, symbolList.getSymbolListAsByteArray().length, symbolList.getSymbolListAsByteArray(), symbolList.getDelimiter(), symbolList.getUnescaped());
        }
    }

    public void delete() throws RecordNotFoundException {
        if (this.docDeleted) {
            throw new RecordNotFoundException("Document deleted", 1);
        }
        this.DELETE(this.docToken);
        this.docToken = null;
        this.docSize = -1;
        this.doc = null;
        this.docDeleted = true;
    }

    protected void docDeleted() {
        this.docToken = null;
        this.docSize = -1;
        this.doc = null;
        this.docDeleted = true;
    }

    private String spacePad(String dataIn, int newLength) {
        if (dataIn == null) {
            return null;
        }
        StringBuilder dataOut = new StringBuilder(newLength);
        dataOut.append(dataIn);
        if (newLength > 0) {
            int spaces = newLength - dataIn.length();
            for (int i = 0; i < spaces; ++i) {
                dataOut.append(" ");
            }
            return dataOut.toString();
        }
        return dataIn;
    }
}

