/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.ChangedException;
import com.ibm.cics.server.CicsError;
import com.ibm.cics.server.DTCFile;
import com.ibm.cics.server.DuplicateRecordException;
import com.ibm.cics.server.ESDS_Browse;
import com.ibm.cics.server.FileDisabledException;
import com.ibm.cics.server.FileNotFoundException;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.KeyedFile;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.LoadingException;
import com.ibm.cics.server.LockedException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NoSpaceException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RBAHolder;
import com.ibm.cics.server.RecordBusyException;
import com.ibm.cics.server.RecordHolder;
import com.ibm.cics.server.RecordNotFoundException;

public class ESDS
extends KeyedFile {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = 1422226436087435487L;
    private transient RBAHolder newRBA = new RBAHolder();
    private boolean XRBA = false;

    public void setXRBA(boolean XRBA) {
        this.XRBA = XRBA;
    }

    public boolean isXRBA() {
        return this.XRBA;
    }

    public void read(long byteAddress, RecordHolder holder) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DTCFile.READ_ESDS(this.getName(), this.getSysId(), byteAddress, this.XRBA, false, holder);
    }

    public void readForUpdate(long byteAddress, RecordHolder holder) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DTCFile.READ_ESDS(this.getName(), this.getSysId(), byteAddress, this.XRBA, true, holder);
    }

    @Override
    public void rewrite(byte[] data) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        try {
            DTCFile.REWRITE(this.getName(), this.getSysId(), data);
        }
        catch (DuplicateRecordException DRE) {
            throw new CicsError("DuplicateRecordException not expected");
        }
    }

    public ESDS_Browse startBrowse(long byteAddress) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        ESDS_Browse newBrowse = new ESDS_Browse(this.getName(), this.getSysId(), byteAddress, this.XRBA);
        return newBrowse;
    }

    public long write(byte[] data) throws FileDisabledException, DuplicateRecordException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DTCFile.WRITE_ESDS(this.getName(), this.getSysId(), null, data, this.newRBA, this.XRBA);
        return this.newRBA.getValue();
    }

    public long write(byte[] alternateKey, byte[] data) throws FileDisabledException, DuplicateRecordException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DTCFile.WRITE_ESDS(this.getName(), this.getSysId(), alternateKey, data, this.newRBA, this.XRBA);
        return this.newRBA.getValue();
    }
}

