/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.ChangedException;
import com.ibm.cics.server.DTCFile;
import com.ibm.cics.server.EndOfFileException;
import com.ibm.cics.server.FileDisabledException;
import com.ibm.cics.server.FileNotFoundException;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.KeyedFileBrowse;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.LoadingException;
import com.ibm.cics.server.LockedException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RBAHolder;
import com.ibm.cics.server.RecordBusyException;
import com.ibm.cics.server.RecordHolder;
import com.ibm.cics.server.RecordNotFoundException;

public class ESDS_Browse
extends KeyedFileBrowse {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    RBAHolder returnedRBA = new RBAHolder();
    boolean XRBA = false;

    ESDS_Browse(String fileName, String sysId, long byteAddress, boolean XRBA) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        super(fileName, sysId);
        this.XRBA = XRBA;
        DTCFile.STARTBR_ESDS(fileName, sysId, byteAddress, XRBA, this.getRequestID());
        this.returnedRBA.setValue(byteAddress);
    }

    public long next(long inputRBA, RecordHolder record) throws FileDisabledException, EndOfFileException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        this.returnedRBA.setValue(inputRBA);
        DTCFile.READNEXT_ESDS(this.fileName, this.sysId, this.returnedRBA, this.XRBA, this.getRequestID(), record);
        return this.returnedRBA.getValue();
    }

    public long next(RecordHolder record) throws FileDisabledException, EndOfFileException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DTCFile.READNEXT_ESDS(this.fileName, this.sysId, this.returnedRBA, this.XRBA, this.getRequestID(), record);
        return this.returnedRBA.getValue();
    }

    public long previous(long inputRBA, RecordHolder record) throws FileDisabledException, EndOfFileException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        this.returnedRBA.setValue(inputRBA);
        DTCFile.READPREV_ESDS(this.fileName, this.sysId, this.returnedRBA, this.XRBA, this.getRequestID(), record);
        return this.returnedRBA.getValue();
    }

    public long previous(RecordHolder record) throws FileDisabledException, EndOfFileException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DTCFile.READPREV_ESDS(this.fileName, this.sysId, this.returnedRBA, this.XRBA, this.getRequestID(), record);
        return this.returnedRBA.getValue();
    }

    public void reset(long inputRBA) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DTCFile.RESETBR_ESDS(this.fileName, this.sysId, inputRBA, this.XRBA, this.getRequestID());
        this.returnedRBA.setValue(inputRBA);
    }
}

