/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.server.API;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.EventErrorException;
import com.ibm.cics.server.LengthErrorException;
import java.io.UnsupportedEncodingException;

public class Event
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2004, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final int MAX_NAME_LEN = 32;
    private String eventName;

    public Event() {
        this.eventName = null;
    }

    public Event(String name) throws EventErrorException {
        this.eventName = Event.padName(name);
        if (this.eventName == null) {
            throw new EventErrorException("Invalid event name" + name, 6);
        }
    }

    static String padName(String name) {
        int strLen = name.length();
        if (strLen == 32) {
            return name;
        }
        if (strLen > 32) {
            return null;
        }
        StringBuilder sb = new StringBuilder(name);
        sb.setLength(32);
        for (int i = 31; i >= 0 && sb.charAt(i) == '\u0000'; --i) {
            sb.setCharAt(i, ' ');
        }
        return sb.toString();
    }

    public String getName() {
        return this.eventName;
    }

    public void setName(String name) throws EventErrorException {
        this.eventName = Event.padName(name);
        if (this.eventName == null) {
            throw new EventErrorException("Invalid event name" + name, 6);
        }
    }

    public void signal() throws ChannelErrorException, EventErrorException, LengthErrorException {
        if (this.eventName == null) {
            throw new EventErrorException("Event name is null", 6);
        }
        this.SIGNAL(this.eventName, null, 0, null);
    }

    public void signal(String fromString) throws ChannelErrorException, EventErrorException, LengthErrorException {
        try {
            this.signal(fromString.getBytes(CommonConstants.LOCALCCSID));
        }
        catch (UnsupportedEncodingException e) {
            this.signal(fromString.getBytes());
        }
    }

    public void signal(byte[] fromData) throws ChannelErrorException, EventErrorException, LengthErrorException {
        if (this.eventName == null) {
            throw new EventErrorException("Event name is null", 6);
        }
        if (fromData.length <= 0) {
            throw new LengthErrorException("Data length not greater than zero");
        }
        this.SIGNAL(this.eventName, fromData, fromData.length, null);
    }

    public void signal(byte[] fromData, int fromLength) throws ChannelErrorException, EventErrorException, LengthErrorException {
        if (this.eventName == null) {
            throw new EventErrorException("Event name is null", 6);
        }
        if (fromData.length <= 0 || fromLength <= 0) {
            throw new LengthErrorException("Data length not greater than zero");
        }
        this.SIGNAL(this.eventName, fromData, fromData.length > fromLength ? fromLength : fromData.length, null);
    }

    public void signal(Channel fromChannel) throws ChannelErrorException, EventErrorException, LengthErrorException {
        if (this.eventName == null) {
            throw new EventErrorException("Event name is null", 6);
        }
        this.SIGNAL(this.eventName, null, 0, fromChannel.getName());
    }

    private final native void SIGNAL(String var1, byte[] var2, int var3, String var4) throws ChannelErrorException, EventErrorException, LengthErrorException;
}

