/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.ras.CICSRas;
import com.ibm.cics.server.API;
import com.ibm.cics.server.DTCFile;
import com.ibm.cics.server.FileDisabledException;
import com.ibm.cics.server.FileNotFoundException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.Task;

public class FileBrowse
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String fileName;
    protected String sysId;
    private short requestID = 0;
    private static ThreadLocal<LocalVars> threadLocalVars = new ThreadLocal();

    protected FileBrowse(String fileName, String sysId) {
        this.fileName = fileName;
        this.sysId = sysId;
        if (threadLocalVars.get() == null) {
            threadLocalVars.set(new LocalVars());
        }
        threadLocalVars.get().reset(false);
        threadLocalVars.get().incrementCounter();
        this.requestID = threadLocalVars.get().getRequestID();
    }

    public void end() throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, ISCInvalidRequestException, NotAuthorisedException, NotOpenException, InvalidSystemIdException {
        threadLocalVars.get().freeRequest(this.requestID);
        DTCFile.ENDBR(this.fileName, this.sysId, this.requestID);
    }

    public short getRequestID() {
        return this.requestID;
    }

    public static class LocalVars {
        private int countPart = 0;
        private int taskNumber = Task.getTask().getTaskNumber();
        private byte taskPart = (byte)(this.taskNumber & 0x7F);
        private boolean[] occupied = new boolean[256];

        protected void reset(boolean force) {
            int taskNumberLocal = Task.getTask().getTaskNumber();
            if (taskNumberLocal != this.taskNumber || force) {
                this.taskNumber = taskNumberLocal;
                this.taskPart = (byte)(this.taskNumber & 0x7F);
                this.countPart = 0;
                this.occupied = new boolean[256];
            }
        }

        protected void incrementCounter() {
            int checked = 0;
            while (this.occupied[this.countPart]) {
                ++this.countPart;
                if (++checked == 257) {
                    this.reset(true);
                    checked = 0;
                    CICSRas.getMessageService().msg(2L, "com.ibm.cics.server.FileBrowse", "incrementCounter", "CICS_MESSAGE SJ 600", "");
                }
                if (this.countPart != 256) continue;
                this.countPart = 0;
            }
            this.occupied[this.countPart] = true;
        }

        protected short getRequestID() {
            return (short)(this.taskPart << 8 | this.countPart);
        }

        protected void freeRequest(short requestID) {
            int request = requestID & 0xFF;
            this.occupied[request] = false;
        }
    }
}

