/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.Task;
import com.ibm.cics.server.TerminalPrincipalFacility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

class HPOutputStream
extends OutputStream {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2001, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String systemOutTDQ = "CESO";
    private static final int TDQRecordLength = 105;
    private boolean displayBlankLine = false;
    private static final String ASCII_cp = "8859_1";
    private static String fileencoding = System.getProperty("file.encoding");
    private static final byte ASCII_LF = 10;
    private byte[] dataBuffer = new byte[105];
    private int dataBufferOffset = 0;
    private byte[] blankBuffer = new byte[105];

    HPOutputStream() {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        if (this.dataBufferOffset > 0 || this.displayBlankLine) {
            this.displayBlankLine = false;
            try {
                String prefix;
                try {
                    Task thisTask = Task.getTask();
                    TerminalPrincipalFacility tpf = (TerminalPrincipalFacility)thisTask.getPrincipalFacility();
                    prefix = tpf.getName() + thisTask.getTransactionName() + " ";
                }
                catch (Exception exc) {
                    prefix = "         ";
                }
                prefix = prefix + "               ";
                BufferedReader r = null;
                if (this.dataBufferOffset > 0) {
                    ByteArrayInputStream in = new ByteArrayInputStream(this.dataBuffer);
                    r = new BufferedReader(new InputStreamReader((InputStream)in, ASCII_cp));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream(prefix.length() + 105);
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)out, fileencoding));
                ((Writer)w).write(prefix.toCharArray(), 0, prefix.length());
                if (this.dataBufferOffset > 0) {
                    char[] buffer = new char[1050];
                    if (r != null) {
                        int rlen;
                        while ((rlen = r.read(buffer)) != -1) {
                            ((Writer)w).write(buffer, 0, rlen);
                        }
                        ((Reader)r).close();
                    }
                }
                ((Writer)w).flush();
                HPOutputStream.WRITE(systemOutTDQ, out.toByteArray(), null, false);
                ((Writer)w).close();
            }
            catch (Exception exc) {
                System.err.println("Exception: " + exc + "\n" + " raised during write to TDQ " + systemOutTDQ + ".");
            }
            System.arraycopy(this.blankBuffer, 0, this.dataBuffer, 0, 105);
            this.dataBufferOffset = 0;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int blen = b.length;
        if (len != 1 || b[off] != 10) {
            int lfPos = this.index((byte)10, b, off, len);
            while (off < blen && len > 0) {
                int copyBytes;
                int n = copyBytes = len + this.dataBufferOffset < 105 ? len : 105 - this.dataBufferOffset;
                if (lfPos != -1 && copyBytes > lfPos - off) {
                    copyBytes = lfPos - off;
                }
                System.arraycopy(b, off, this.dataBuffer, this.dataBufferOffset, copyBytes);
                this.dataBufferOffset += copyBytes;
                if (this.dataBufferOffset == 105) {
                    this.flush();
                }
                len -= copyBytes;
                if (lfPos == -1 || lfPos > (off += copyBytes)) continue;
                this.flush();
                ++off;
                lfPos = this.index((byte)10, b, lfPos + 1, --len);
            }
        } else {
            this.displayBlankLine = true;
            this.flush();
        }
    }

    private int index(byte searchFor, byte[] inHere, int fromOffset, int forLen) {
        int index = -1;
        int i = fromOffset;
        do {
            if (inHere[i] == searchFor) {
                index = i;
                continue;
            }
            ++i;
        } while (index == -1 && i < fromOffset + forLen);
        return index;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] DataBuffer = new byte[1];
        this.write(DataBuffer, 0, 1);
    }

    static final native void WRITE(String var0, byte[] var1, String var2, boolean var3) throws Exception;
}

