/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.server.API;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.Document;
import com.ibm.cics.server.HttpSession;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.TokenErrorException;
import java.io.UnsupportedEncodingException;

public class HttpClientRequest
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2005, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int method = -1;
    private String characterset;
    private String mediaType;
    private int closeStatus = -1;
    private int action = -1;
    private String urimap;
    private String path;
    private int pathLength = -1;
    private String queryString;
    private int queryStringLength = -1;
    private int clientConvert = -1;
    private int docStatus = -1;
    private int authenticate = -1;
    private String userName;
    private int userNameLength = -1;
    private String password;
    private int passwordLength = -1;
    public static final int NOTSET = -1;
    private static final int POST = 636;
    private static final int GET = 748;
    private static final int HEAD = 750;
    private static final int PUT = 749;
    private static final int TRACE = 760;
    private static final int OPTIONS = 759;
    private static final int DELETE = 292;
    private static final int EXPECT = 747;
    private static final int CLOSE = 741;
    private static final int NOCLOSE = 742;
    private static final int CLICONVERT = 743;
    private static final int NOCLICONVERT = 744;
    private static final int CHUNKYES = 736;
    private static final int CHUNKEND = 737;
    private static final int DOCDELETE = 295;
    private static final int NODOCDELETE = 296;
    private static final int AUTHENTICATE_BASIC = 1092;
    private static final int AUTHENTICATE_NONE = 496;
    private static final int RESP2_CONTAINER_NOT_FOUND = 2;
    private static String ORIG_LOCALCCSID = CommonConstants.SUPPLIED_CCSID;

    private native void SEND(byte[] var1, byte[] var2, byte[] var3, int var4, int var5, int var6, String var7, String var8, String var9, int var10, String var11, String var12, int var13, int var14, int var15, int var16, int var17, int var18, String var19, int var20, String var21, int var22, String var23, String var24) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException;

    private native void WRITE(byte[] var1, String var2, String var3) throws InvalidRequestException, NotOpenException;

    public HttpClientRequest(String method) {
        method = method.toUpperCase();
        if (method.equals("POST")) {
            this.method = 636;
        }
        if (method.equals("GET")) {
            this.method = 748;
        }
        if (method.equals("HEAD")) {
            this.method = 750;
        }
        if (method.equals("PUT")) {
            this.method = 749;
        }
        if (method.equals("TRACE")) {
            this.method = 760;
        }
        if (method.equals("OPTIONS")) {
            this.method = 759;
        }
        if (method.equals("DELETE")) {
            this.method = 292;
        }
    }

    public HttpClientRequest(String method, String mediaType) {
        this(method);
        this.mediaType = this.spacePad(mediaType, 56);
    }

    public void setMethodPost() {
        this.method = 636;
    }

    public void setMethodGet() {
        this.method = 748;
    }

    public void setMethodHead() {
        this.method = 750;
    }

    public void setMethodPut() {
        this.method = 749;
    }

    public void setMethodTrace() {
        this.method = 760;
    }

    public void setMethodOptions() {
        this.method = 759;
    }

    public void setMethodDelete() {
        this.method = 292;
    }

    public void setCharacterset(String characterset) {
        this.characterset = this.spacePad(characterset, 40);
        this.clientConvert = 743;
    }

    public void setClose() {
        this.closeStatus = 741;
    }

    public void setNoClose() {
        this.closeStatus = 742;
    }

    public void setActionExpect() {
        this.action = 747;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = this.spacePad(mediaType, 56);
    }

    public void setPath(String path) {
        this.path = path;
        this.pathLength = path.length();
    }

    public void setUrimap(String urimap) {
        this.urimap = this.spacePad(urimap, 8);
    }

    public void setClientConvert() {
        this.clientConvert = 743;
    }

    public void setNoClientConvert() {
        this.clientConvert = 744;
        this.characterset = null;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
        this.queryStringLength = queryString.length();
    }

    public void setDocDelete() {
        this.docStatus = 295;
    }

    public void setNoDocDelete() {
        this.docStatus = 296;
    }

    public void setAuthenticationNone() {
        this.authenticate = 496;
        this.userName = null;
        this.userNameLength = -1;
        this.password = null;
        this.passwordLength = -1;
    }

    public void setAuthenticationBasic() {
        this.authenticate = 1092;
        this.userName = null;
        this.userNameLength = -1;
        this.password = null;
        this.passwordLength = -1;
    }

    public void setAuthenticationBasic(String userName, String password) {
        this.authenticate = 1092;
        this.userName = userName;
        this.userNameLength = userName.length();
        this.password = password;
        this.passwordLength = password.length();
    }

    public void sendDocument(HttpSession session, Document doc) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        this.SEND(session.getSessionToken(), doc.getDocToken(), null, -1, this.method, this.clientConvert, this.characterset, this.mediaType, this.path, this.pathLength, this.urimap, this.queryString, this.queryStringLength, this.action, this.closeStatus, -1, this.docStatus, this.authenticate, this.userName, this.userNameLength, this.password, this.passwordLength, null, null);
        if (this.docStatus == 295) {
            doc.docDeleted();
        }
    }

    public void sendFrom(HttpSession session, String from) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        String dataCodepageName = session.getCodePageCharsetName();
        if (dataCodepageName == null) {
            dataCodepageName = ORIG_LOCALCCSID;
        }
        try {
            byte[] data = from.getBytes(dataCodepageName);
            this.SEND(session.getSessionToken(), null, data, data.length, this.method, this.clientConvert, this.characterset, this.mediaType, this.path, this.pathLength, this.urimap, this.queryString, this.queryStringLength, this.action, this.closeStatus, -1, -1, this.authenticate, this.userName, this.userNameLength, this.password, this.passwordLength, null, null);
        }
        catch (UnsupportedEncodingException e) {
            byte[] data = from.getBytes();
            this.SEND(session.getSessionToken(), null, data, data.length, this.method, this.clientConvert, this.characterset, this.mediaType, this.path, this.pathLength, this.urimap, this.queryString, this.queryStringLength, this.action, this.closeStatus, -1, -1, this.authenticate, this.userName, this.userNameLength, this.password, this.passwordLength, null, null);
        }
    }

    public void sendFrom(HttpSession session, byte[] from) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        this.SEND(session.getSessionToken(), null, from, from.length, this.method, this.clientConvert, this.characterset, this.mediaType, this.path, this.pathLength, this.urimap, this.queryString, this.queryStringLength, this.action, this.closeStatus, -1, -1, this.authenticate, this.userName, this.userNameLength, this.password, this.passwordLength, null, null);
    }

    public void sendContainer(HttpSession session, Container container) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        if (container == null) {
            throw new ContainerErrorException("Null Container", 2);
        }
        try {
            container.getName();
            container.getChannelName();
        }
        catch (Exception e) {
            throw new ContainerErrorException("Container deleted", 2);
        }
        this.SEND(session.getSessionToken(), null, null, -1, this.method, this.clientConvert, this.characterset, this.mediaType, this.path, this.pathLength, this.urimap, this.queryString, this.queryStringLength, this.action, this.closeStatus, -1, -1, this.authenticate, this.userName, this.userNameLength, this.password, this.passwordLength, container.getName(), container.getChannelName());
    }

    public void send(HttpSession session) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        this.SEND(session.getSessionToken(), null, null, -1, this.method, this.clientConvert, this.characterset, this.mediaType, this.path, this.pathLength, this.urimap, this.queryString, this.queryStringLength, this.action, this.closeStatus, -1, -1, this.authenticate, this.userName, this.userNameLength, this.password, this.passwordLength, null, null);
    }

    public void sendChunk(HttpSession session, String from) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        String dataCodepageName = session.getCodePageCharsetName();
        if (dataCodepageName == null) {
            dataCodepageName = ORIG_LOCALCCSID;
        }
        try {
            byte[] data = from.getBytes(dataCodepageName);
            this.SEND(session.getSessionToken(), null, data, data.length, this.method, this.clientConvert, this.characterset, this.mediaType, this.path, this.pathLength, this.urimap, this.queryString, this.queryStringLength, this.action, this.closeStatus, 736, -1, this.authenticate, this.userName, this.userNameLength, this.password, this.passwordLength, null, null);
        }
        catch (UnsupportedEncodingException e) {
            byte[] data = from.getBytes();
            this.SEND(session.getSessionToken(), null, data, data.length, this.method, this.clientConvert, this.characterset, this.mediaType, this.path, this.pathLength, this.urimap, this.queryString, this.queryStringLength, this.action, this.closeStatus, 736, -1, this.authenticate, this.userName, this.userNameLength, this.password, this.passwordLength, null, null);
        }
        this.method = -1;
        this.clientConvert = -1;
        this.characterset = null;
        this.mediaType = null;
        this.path = null;
        this.pathLength = -1;
        this.urimap = null;
        this.queryString = null;
        this.queryStringLength = -1;
        this.closeStatus = -1;
        this.authenticate = -1;
        this.userName = null;
        this.userNameLength = -1;
        this.password = null;
        this.passwordLength = -1;
        this.docStatus = -1;
    }

    public void sendChunk(HttpSession session, byte[] from) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        this.SEND(session.getSessionToken(), null, from, from.length, this.method, this.clientConvert, this.characterset, this.mediaType, this.path, this.pathLength, this.urimap, this.queryString, this.queryStringLength, this.action, this.closeStatus, 736, -1, this.authenticate, this.userName, this.userNameLength, this.password, this.passwordLength, null, null);
        this.method = -1;
        this.clientConvert = -1;
        this.characterset = null;
        this.mediaType = null;
        this.path = null;
        this.pathLength = -1;
        this.urimap = null;
        this.queryString = null;
        this.queryStringLength = -1;
        this.closeStatus = -1;
        this.authenticate = -1;
        this.userName = null;
        this.userNameLength = -1;
        this.password = null;
        this.passwordLength = -1;
        this.docStatus = -1;
    }

    public void sendLastChunk(HttpSession session) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, NotOpenException, TokenErrorException, ContainerErrorException, ChannelErrorException {
        this.SEND(session.getSessionToken(), null, null, -1, this.method, this.clientConvert, this.characterset, this.mediaType, this.path, this.pathLength, this.urimap, this.queryString, this.queryStringLength, this.action, this.closeStatus, 737, -1, this.authenticate, this.userName, this.userNameLength, this.password, this.passwordLength, null, null);
    }

    public void writeHeader(HttpSession session, String header, String value) throws InvalidRequestException, NotOpenException {
        this.WRITE(session.getSessionToken(), header, value);
    }

    private String spacePad(String dataIn, int newLength) {
        if (dataIn == null) {
            return null;
        }
        StringBuilder dataOut = new StringBuilder(newLength);
        dataOut.append(dataIn);
        if (newLength > 0) {
            int spaces = newLength - dataIn.length();
            for (int i = 0; i < spaces; ++i) {
                dataOut.append(" ");
            }
            return dataOut.toString();
        }
        return dataIn;
    }

    static {
        if (ORIG_LOCALCCSID == null) {
            ORIG_LOCALCCSID = CommonConstants.LOCALCCSID;
        }
    }
}

