/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.server.API;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.EndOfFileException;
import com.ibm.cics.server.HttpHeader;
import com.ibm.cics.server.HttpSession;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NameValueData;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.Task;
import com.ibm.cics.server.TimedOutException;
import java.io.UnsupportedEncodingException;

public class HttpClientResponse
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String ORIG_LOCALCCSID = CommonConstants.SUPPLIED_CCSID;
    public static final int NOTSET = -1;
    private static final int TRUNCATEYES = -1;
    private static final int TRUNCATENO = -2;
    private static final int BODYCOMPLETE = 0;
    private static final int BODYTRUNCATED = 1;
    private static final int BODYPARTIAL = 2;
    private static final int DEFAULTMAXLENGTH = Short.MAX_VALUE;
    private static final int CLICONVERT = 743;
    private static final int NOCLICONVERT = 744;
    private static final int RESP2_NO_CURRENT_CHANNEL = 145;
    private static final int RESP2_CONTAINER_NAME_INVALID = 1;
    private static final int RESP2_CHANNEL_NAME_INVALID = 1;
    private int clientConvert = -1;
    private int maxLength = Short.MAX_VALUE;
    private int truncate = -1;
    private int bodyState = -1;
    private int statusCode = -1;
    private String statusText;
    private String mediaType;
    private String bodyCharset;

    private native byte[] RECEIVE(byte[] var1, int var2, int var3, int var4) throws InvalidRequestException, IOErrorException, NotOpenException, TimedOutException;

    private native String READ(byte[] var1, String var2) throws InvalidRequestException, NotOpenException;

    private native void STARTBROWSE(byte[] var1) throws InvalidRequestException, NotOpenException, LogicException;

    private native void ENDBROWSE(byte[] var1) throws NotOpenException, LogicException;

    private native NameValueData READNEXT(byte[] var1) throws NotOpenException, LogicException, EndOfFileException;

    private native void RECCONT(byte[] var1, String var2, String var3) throws InvalidRequestException, IOErrorException, NotOpenException, TimedOutException, ChannelErrorException, ContainerErrorException;

    public void setClientConvert() {
        this.clientConvert = 743;
    }

    public void setNoClientConvert() {
        this.clientConvert = 744;
    }

    public void setNoTruncate() {
        this.truncate = -2;
    }

    public void setTruncate() {
        this.truncate = -1;
    }

    public void setMaxLength(int maxLength) throws LengthErrorException {
        if (maxLength < 1) {
            throw new LengthErrorException("maxLength less than 1");
        }
        this.maxLength = maxLength;
    }

    public byte[] getContent(HttpSession session) throws InvalidRequestException, IOErrorException, NotOpenException, TimedOutException {
        return this.RECEIVE(session.getSessionToken(), this.maxLength, this.clientConvert, this.truncate);
    }

    public String getContentAsString(HttpSession session) throws InvalidRequestException, IOErrorException, NotOpenException, TimedOutException {
        String dataCodepageName = session.getCodePageCharsetName();
        if (dataCodepageName == null) {
            dataCodepageName = ORIG_LOCALCCSID;
        }
        try {
            return new String(this.RECEIVE(session.getSessionToken(), this.maxLength, this.clientConvert, this.truncate), dataCodepageName);
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.RECEIVE(session.getSessionToken(), this.maxLength, this.clientConvert, this.truncate));
        }
    }

    public Container getContentAsContainer(HttpSession session, String toContainer, String toChannel) throws InvalidRequestException, IOErrorException, NotOpenException, TimedOutException, ChannelErrorException, ContainerErrorException {
        Channel chan;
        if (toContainer == null) {
            throw new ContainerErrorException("Null toContainer", 1);
        }
        if (toChannel == null) {
            throw new ChannelErrorException("Null toChannel", 1);
        }
        toContainer = this.spacePad(toContainer, 16);
        toChannel = this.spacePad(toChannel, 16);
        this.RECCONT(session.getSessionToken(), toContainer, toChannel);
        Task t = Task.getTask();
        if (t == null) {
            throw new InvalidRequestException("Task.getTask failed");
        }
        try {
            chan = t.createChannel(toChannel);
        }
        catch (Exception e) {
            chan = t.returnChannel(toChannel);
        }
        Container cont = chan.returnContainer(toContainer);
        cont.setDataInCICS();
        return cont;
    }

    public Container getContentAsContainer(HttpSession session, String toContainer) throws InvalidRequestException, IOErrorException, NotOpenException, TimedOutException, ChannelErrorException, ContainerErrorException {
        if (toContainer == null) {
            throw new ContainerErrorException("Null toContainer", 1);
        }
        toContainer = this.spacePad(toContainer, 16);
        Task t = Task.getTask();
        Channel chan = t.getCurrentChannel();
        if (chan == null) {
            throw new InvalidRequestException("No current channel", 145);
        }
        this.RECCONT(session.getSessionToken(), toContainer, chan.getName());
        Container cont = chan.returnContainer(toContainer);
        cont.setDataInCICS();
        return cont;
    }

    public int getStatusCode() throws InvalidRequestException {
        if (this.statusCode == -1) {
            throw new InvalidRequestException("getContent() or getContentAsContainer() not called");
        }
        return this.statusCode;
    }

    public String getStatusText() throws InvalidRequestException {
        if (this.statusText == null) {
            throw new InvalidRequestException("getContent() or getContentAsContainer() not called");
        }
        return this.statusText;
    }

    public String getMediaType() throws InvalidRequestException {
        if (this.mediaType == null) {
            throw new InvalidRequestException("getContent() or getContentAsContainer() not called");
        }
        return this.mediaType;
    }

    public String getMediaTypeTrim() throws InvalidRequestException {
        if (this.mediaType == null) {
            throw new InvalidRequestException("getContent() or getContentAsContainer() not called");
        }
        return this.mediaType.trim();
    }

    public String getCharacterset() throws InvalidRequestException {
        if (this.bodyCharset == null) {
            throw new InvalidRequestException("getContent() or getContentAsContainer() not called");
        }
        return this.bodyCharset;
    }

    public String getCharactersetTrim() throws InvalidRequestException {
        if (this.bodyCharset == null) {
            throw new InvalidRequestException("getContent() or getContentAsContainer() not called");
        }
        return this.bodyCharset.trim();
    }

    public String getBodyCharset() throws InvalidRequestException {
        if (this.bodyCharset == null) {
            throw new InvalidRequestException("getContent() or getContentAsContainer() not called");
        }
        return this.bodyCharset.trim();
    }

    public boolean isBodyComplete() {
        boolean bodyComplete = false;
        if (this.bodyState == 0) {
            bodyComplete = true;
        }
        return bodyComplete;
    }

    public boolean isBodyTruncated() {
        boolean bodyTruncated = false;
        if (this.bodyState == 1) {
            bodyTruncated = true;
        }
        return bodyTruncated;
    }

    public boolean isBodyPartial() {
        boolean bodyPartial = false;
        if (this.bodyState == 2) {
            bodyPartial = true;
        }
        return bodyPartial;
    }

    public String getHeader(HttpSession session, String header) throws InvalidRequestException, NotOpenException {
        return this.READ(session.getSessionToken(), header);
    }

    public void startBrowseHeader(HttpSession session) throws InvalidRequestException, NotOpenException, LogicException {
        this.STARTBROWSE(session.getSessionToken());
    }

    public HttpHeader getNextHeader(HttpSession session) throws LogicException, NotOpenException, EndOfFileException {
        return (HttpHeader)this.READNEXT(session.getSessionToken());
    }

    public void endBrowseHeader(HttpSession session) throws LogicException, NotOpenException {
        this.ENDBROWSE(session.getSessionToken());
    }

    private String spacePad(String dataIn, int newLength) {
        if (dataIn == null) {
            return null;
        }
        StringBuilder dataOut = new StringBuilder(newLength);
        dataOut.append(dataIn);
        if (newLength > 0) {
            int spaces = newLength - dataIn.length();
            for (int i = 0; i < spaces; ++i) {
                dataOut.append(" ");
            }
            return dataOut.toString();
        }
        return dataIn;
    }

    static {
        if (ORIG_LOCALCCSID == null) {
            ORIG_LOCALCCSID = CommonConstants.LOCALCCSID;
        }
    }
}

