/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.ras.server.TidyUpOnTermination;
import com.ibm.cics.ras.server.WrapperHelper;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.EndOfFileException;
import com.ibm.cics.server.FormField;
import com.ibm.cics.server.HttpHeader;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NameValueData;
import com.ibm.cics.server.NonHttpDataException;
import com.ibm.cics.server.QueryParm;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.Task;
import com.ibm.cics.server.TcpipRequest;
import com.ibm.cics.server.WebInfo;
import com.ibm.cics.server.WebReceive;

public class HttpRequest
extends TcpipRequest {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NOTSET = -1;
    private static ThreadLocal<WebInfo> WInfo = new ThreadLocal();
    private static ThreadLocal<HttpRequest> _hrq = new ThreadLocal();
    private static ThreadLocal<WebReceive> WRecv = new ThreadLocal();
    private static final int HTTPHEADER = 1;
    private static final int FORMFIELD = 2;
    private static final int QUERYPARM = 3;
    private static final int RESP2_NO_CURRENT_CHANNEL = 145;
    private static final int RESP2_CONTAINER_NAME_INVALID = 1;
    private static final int RESP2_CHANNEL_NAME_INVALID = 1;
    private static boolean registeredWithWrapper = false;

    private static native String READ(int var0, String var1, String var2, String var3) throws InvalidRequestException;

    private static native byte[] READDATA(int var0, String var1, String var2, String var3) throws InvalidRequestException;

    private static native void STARTBROWSE(int var0, String var1, String var2, String var3) throws InvalidRequestException, RecordNotFoundException;

    private static native void ENDBROWSE(int var0) throws InvalidRequestException;

    private static native NameValueData READNEXT(int var0) throws InvalidRequestException, EndOfFileException;

    private HttpRequest() {
        if (!registeredWithWrapper) {
            registeredWithWrapper = true;
            WrapperHelper.registerTerminator((TidyUpOnTermination)this);
        }
    }

    public static HttpRequest getHttpRequestInstance() {
        if (_hrq.get() == null) {
            _hrq.set(new HttpRequest());
        }
        return _hrq.get();
    }

    public String getHttpMethod() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getHttpMethod();
    }

    public String getHttpVersion() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getHttpVersion();
    }

    public String getRequestType() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getRequestType();
    }

    public boolean isDataHttp() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().isDataHttp();
    }

    public String getPath() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getPath();
    }

    public String getQueryString() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getQueryString();
    }

    public String getHost() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getHost();
    }

    public int getHostType() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getHostType();
    }

    public boolean isSchemeHttp() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().isSchemeHttp();
    }

    public boolean isSchemeHttps() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().isSchemeHttps();
    }

    public String getScheme() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getScheme();
    }

    public String getUrimap() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getUrimap();
    }

    @Override
    public int getPortNumber() throws InvalidRequestException {
        if (WInfo.get() == null) {
            WInfo.set(new WebInfo());
        }
        return WInfo.get().getPortNumber();
    }

    public String getHeader(String header) throws InvalidRequestException {
        return HttpRequest.READ(1, header, null, null);
    }

    public String getFormField(String formField) throws InvalidRequestException {
        return this.getFormField(formField, null, null);
    }

    public String getFormField(String formField, String hostCodePage, String characterset) throws InvalidRequestException {
        hostCodePage = this.spacePad(hostCodePage, 8);
        characterset = this.spacePad(characterset, 40);
        return HttpRequest.READ(2, formField, hostCodePage, characterset);
    }

    public byte[] getFormFieldData(String formField) throws InvalidRequestException {
        return this.getFormFieldData(formField, null, null);
    }

    public byte[] getFormFieldData(String formField, String hostCodePage, String characterset) throws InvalidRequestException {
        hostCodePage = this.spacePad(hostCodePage, 8);
        characterset = this.spacePad(characterset, 40);
        return HttpRequest.READDATA(2, formField, hostCodePage, characterset);
    }

    public String getQueryParm(String queryParm) throws InvalidRequestException {
        return HttpRequest.READ(3, queryParm, null, null);
    }

    @Override
    public void setServerConvert() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setServerConvert();
    }

    @Override
    public void setNoServerConvert() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setNoServerConvert();
    }

    @Override
    public void setClientCodePage(String characterset) {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        characterset = this.spacePad(characterset, 40);
        WRecv.get().setCharacterset(characterset);
    }

    @Override
    public void setCharacterset(String characterset) {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        characterset = this.spacePad(characterset, 40);
        WRecv.get().setCharacterset(characterset);
    }

    @Override
    public void setHostCodePage(String hostCodePage) {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        hostCodePage = this.spacePad(hostCodePage, 8);
        WRecv.get().setHostCodePage(hostCodePage);
    }

    @Override
    public void setNoTruncate() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setNoTruncate();
    }

    @Override
    public void setTruncate() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setTruncate();
    }

    @Override
    public void setMaxLength(int maxLength) throws LengthErrorException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        if (maxLength < 1) {
            throw new LengthErrorException("maxLength not greater than 0");
        }
        WRecv.get().setMaxLength(maxLength);
    }

    @Override
    public byte[] getContent(String hostCodePage, String characterset) throws InvalidRequestException, RecordNotFoundException, NonHttpDataException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        hostCodePage = this.spacePad(hostCodePage, 8);
        WRecv.get().setHostCodePage(hostCodePage);
        characterset = this.spacePad(characterset, 40);
        WRecv.get().setCharacterset(characterset);
        WRecv.get().setNonHttpDataExceptionYes();
        return WRecv.get().receive();
    }

    @Override
    public byte[] getContent() throws InvalidRequestException, RecordNotFoundException, NonHttpDataException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setNonHttpDataExceptionYes();
        return WRecv.get().receive();
    }

    @Override
    public Container getContentAsContainer(String toContainer, String toChannel) throws InvalidRequestException, RecordNotFoundException, ChannelErrorException, ContainerErrorException {
        Channel chan;
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        if (toContainer == null) {
            throw new ContainerErrorException("Null toContainer", 1);
        }
        if (toChannel == null) {
            throw new ChannelErrorException("Null toChannel", 1);
        }
        toContainer = this.spacePad(toContainer, 16);
        toChannel = this.spacePad(toChannel, 16);
        WRecv.get().receiveContainer(toContainer, toChannel);
        Task t = Task.getTask();
        if (t == null) {
            throw new InvalidRequestException("Task.getTask failed");
        }
        try {
            chan = t.createChannel(toChannel);
        }
        catch (Exception e) {
            chan = t.returnChannel(toChannel);
        }
        Container cont = chan.returnContainer(toContainer);
        cont.setDataInCICS();
        return cont;
    }

    @Override
    public Container getContentAsContainer(String toContainer) throws InvalidRequestException, RecordNotFoundException, ChannelErrorException, ContainerErrorException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        if (toContainer == null) {
            throw new ContainerErrorException("Null toContainer", 1);
        }
        toContainer = this.spacePad(toContainer, 16);
        Task t = Task.getTask();
        Channel chan = t.getCurrentChannel();
        if (chan == null) {
            throw new InvalidRequestException("No current channel", 145);
        }
        WRecv.get().receiveContainer(toContainer, chan.getName());
        Container cont = chan.returnContainer(toContainer);
        cont.setDataInCICS();
        return cont;
    }

    @Override
    public boolean isBodyComplete() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().isBodyComplete();
    }

    @Override
    public boolean isBodyTruncated() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().isBodyTruncated();
    }

    @Override
    public boolean isBodyPartial() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().isBodyPartial();
    }

    @Override
    public String getBodyCharset() throws InvalidRequestException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().getBodyCharset();
    }

    @Override
    public String getMediaType() throws InvalidRequestException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().getMediaType();
    }

    public void startBrowseHeader() throws InvalidRequestException, RecordNotFoundException, LogicException {
        HttpRequest.STARTBROWSE(1, null, null, null);
    }

    public HttpHeader getNextHeader() throws InvalidRequestException, EndOfFileException {
        return (HttpHeader)HttpRequest.READNEXT(1);
    }

    public void endBrowseHeader() throws InvalidRequestException {
        HttpRequest.ENDBROWSE(1);
    }

    public void startBrowseFormField() throws InvalidRequestException, RecordNotFoundException, LogicException {
        this.startBrowseFormField(null);
    }

    public void startBrowseFormField(String name) throws InvalidRequestException, RecordNotFoundException, LogicException {
        this.startBrowseFormField(name, null, null);
    }

    public void startBrowseFormField(String name, String hostCodePage, String characterset) throws InvalidRequestException, RecordNotFoundException, LogicException {
        hostCodePage = this.spacePad(hostCodePage, 8);
        characterset = this.spacePad(characterset, 40);
        HttpRequest.STARTBROWSE(2, name, hostCodePage, characterset);
    }

    public FormField getNextFormField() throws InvalidRequestException, EndOfFileException {
        return (FormField)HttpRequest.READNEXT(2);
    }

    public void endBrowseFormField() throws InvalidRequestException {
        HttpRequest.ENDBROWSE(2);
    }

    public void startBrowseQueryParm() throws InvalidRequestException, RecordNotFoundException, LogicException {
        this.startBrowseQueryParm(null);
    }

    public void startBrowseQueryParm(String name) throws InvalidRequestException, RecordNotFoundException, LogicException {
        HttpRequest.STARTBROWSE(3, name, null, null);
    }

    public QueryParm getNextQueryParm() throws InvalidRequestException, EndOfFileException {
        return (QueryParm)HttpRequest.READNEXT(3);
    }

    public void endBrowseQueryParm() throws InvalidRequestException {
        HttpRequest.ENDBROWSE(3);
    }

    private String spacePad(String dataIn, int newLength) {
        if (dataIn == null) {
            return null;
        }
        StringBuilder dataOut = new StringBuilder();
        dataOut.append(dataIn);
        if (newLength > 0) {
            int spaces = newLength - dataIn.length();
            for (int i = 0; i < spaces; ++i) {
                dataOut.append(" ");
            }
            return dataOut.toString();
        }
        return dataIn;
    }

    private static boolean ibmJVMTidyUp() {
        if (WInfo.get() != null) {
            WInfo.get().resetObject();
            WInfo.remove();
        }
        if (WRecv.get() != null) {
            WRecv.get().resetObject();
            WRecv.remove();
        }
        return true;
    }

    @Override
    public final void drive_ibmJVMTidyUp() {
        HttpRequest.ibmJVMTidyUp();
        super.drive_ibmJVMTidyUp();
    }
}

