/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.server.API;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.Document;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.RecordNotFoundException;
import java.io.UnsupportedEncodingException;

public class HttpResponse
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NOTSET = -1;
    private int serverConvert = -1;
    private String characterset;
    private String hostCodePage;
    private String mediaType;
    private short statusCode = (short)-1;
    private String statusText;
    private int closeStatus = -1;
    private int action = -1;
    private int docStatus = -1;
    private static final int SRVCONVERT = 738;
    private static final int NOSRVCONVERT = 739;
    private static final int CLOSE = 741;
    private static final int NOCLOSE = 742;
    private static final int EVENTUAL = 3;
    private static final int IMMEDIATE = 2;
    private static final int CHUNKNO = 735;
    private static final int CHUNKYES = 736;
    private static final int CHUNKEND = 737;
    private static final int DOCDELETE = 295;
    private static final int NODOCDELETE = 296;
    private static final int RESP2_CONTAINER_NOT_FOUND = 2;

    private static native void WRITE(byte[] var0, byte[] var1) throws InvalidRequestException;

    private static native void SEND(byte[] var0, byte[] var1, int var2, short var3, String var4, int var5, String var6, String var7, String var8, int var9, int var10, int var11, int var12, String var13, String var14) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException;

    public void writeHeader(String header, String value) throws InvalidRequestException, LengthErrorException {
        try {
            HttpResponse.WRITE(header.getBytes(CommonConstants.LOCALCCSID), value.getBytes(CommonConstants.LOCALCCSID));
        }
        catch (UnsupportedEncodingException e) {
            RuntimeException re = new RuntimeException("Problem in HttpResponse.writeHeader()");
            re.initCause(e);
            throw re;
        }
    }

    public void setServerConvert() {
        this.serverConvert = 738;
    }

    public void setNoServerConvert() {
        this.serverConvert = 739;
        this.characterset = null;
        this.hostCodePage = null;
    }

    public void setClientCodePage(String characterset) {
        this.characterset = this.spacePad(characterset, 40);
        this.serverConvert = 738;
    }

    public void setCharacterset(String characterset) {
        this.characterset = this.spacePad(characterset, 40);
        this.serverConvert = 738;
    }

    public void setHostCodePage(String hostCodePage) {
        this.hostCodePage = this.spacePad(hostCodePage, 8);
        this.serverConvert = 738;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = this.spacePad(mediaType, 56);
    }

    public void setStatus(short statusCode, String statusText) {
        this.statusCode = statusCode;
        this.statusText = statusText;
    }

    public void setClose() {
        this.closeStatus = 741;
    }

    public void setNoClose() {
        this.closeStatus = 742;
    }

    public void setActionEventual() {
        this.action = 3;
    }

    public void setActionImmediate() {
        this.action = 2;
    }

    public void setDocDelete() {
        this.docStatus = 295;
    }

    public void setNoDocDelete() {
        this.docStatus = 296;
    }

    public void sendDocument(Document doc, short statusCode, String statusText, String characterset) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        this.characterset = this.spacePad(characterset, 40);
        this.statusCode = statusCode;
        this.statusText = statusText;
        HttpResponse.SEND(doc.getDocToken(), null, -1, this.statusCode, this.statusText, this.serverConvert, this.characterset, null, this.mediaType, this.closeStatus, this.action, -1, this.docStatus, null, null);
        if (this.docStatus == 295) {
            doc.docDeleted();
        }
    }

    public void sendDocument(Document doc) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        HttpResponse.SEND(doc.getDocToken(), null, -1, this.statusCode, this.statusText, this.serverConvert, this.characterset, null, this.mediaType, this.closeStatus, this.action, -1, this.docStatus, null, null);
        if (this.docStatus == 295) {
            doc.docDeleted();
        }
    }

    public void sendFrom(String from) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        try {
            HttpResponse.SEND(null, from.getBytes(CommonConstants.LOCALCCSID), from.length(), this.statusCode, this.statusText, this.serverConvert, this.characterset, this.hostCodePage, this.mediaType, this.closeStatus, this.action, -1, -1, null, null);
        }
        catch (UnsupportedEncodingException e) {
            HttpResponse.SEND(null, from.getBytes(), from.length(), this.statusCode, this.statusText, this.serverConvert, this.characterset, this.hostCodePage, this.mediaType, this.closeStatus, this.action, -1, -1, null, null);
        }
    }

    public void sendFrom(byte[] from) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        HttpResponse.SEND(null, from, from.length, this.statusCode, this.statusText, this.serverConvert, this.characterset, this.hostCodePage, this.mediaType, this.closeStatus, this.action, -1, -1, null, null);
    }

    public void sendChunk(String from) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        try {
            HttpResponse.SEND(null, from.getBytes(CommonConstants.LOCALCCSID), from.length(), this.statusCode, this.statusText, this.serverConvert, this.characterset, this.hostCodePage, this.mediaType, this.closeStatus, this.action, 736, -1, null, null);
        }
        catch (UnsupportedEncodingException e) {
            HttpResponse.SEND(null, from.getBytes(), from.length(), this.statusCode, this.statusText, this.serverConvert, this.characterset, this.hostCodePage, this.mediaType, this.closeStatus, this.action, 736, -1, null, null);
        }
        this.serverConvert = -1;
        this.characterset = null;
        this.hostCodePage = null;
        this.mediaType = null;
        this.statusCode = (short)-1;
        this.statusText = null;
        this.closeStatus = -1;
        this.action = -1;
    }

    public void sendChunk(byte[] from) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        HttpResponse.SEND(null, from, from.length, this.statusCode, this.statusText, this.serverConvert, this.characterset, this.hostCodePage, this.mediaType, this.closeStatus, this.action, 736, -1, null, null);
        this.serverConvert = -1;
        this.characterset = null;
        this.hostCodePage = null;
        this.mediaType = null;
        this.statusCode = (short)-1;
        this.statusText = null;
        this.closeStatus = -1;
        this.action = -1;
    }

    public void sendLastChunk() throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        HttpResponse.SEND(null, null, -1, this.statusCode, this.statusText, this.serverConvert, this.characterset, this.hostCodePage, this.mediaType, this.closeStatus, this.action, 737, -1, null, null);
    }

    public void sendContainer(Container container) throws InvalidRequestException, RecordNotFoundException, LengthErrorException, IOErrorException, ContainerErrorException, ChannelErrorException {
        if (container == null) {
            throw new ContainerErrorException("Null Container", 2);
        }
        try {
            container.getName();
            container.getChannelName();
        }
        catch (Exception e) {
            throw new ContainerErrorException("Container deleted", 2);
        }
        HttpResponse.SEND(null, null, -1, this.statusCode, this.statusText, this.serverConvert, this.characterset, null, this.mediaType, this.closeStatus, this.action, -1, -1, container.getName(), container.getChannelName());
    }

    private String spacePad(String dataIn, int newLength) {
        if (dataIn == null) {
            return null;
        }
        StringBuilder dataOut = new StringBuilder();
        dataOut.append(dataIn);
        if (newLength > 0) {
            int spaces = newLength - dataIn.length();
            for (int i = 0; i < spaces; ++i) {
                dataOut.append(" ");
            }
            return dataOut.toString();
        }
        return dataIn;
    }
}

