/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.TimedOutException;
import java.nio.charset.Charset;

public class HttpSession
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private byte[] sessionToken;
    private String hostName;
    private String urimap;
    private int scheme = -1;
    private int portNumber = -1;
    private String certificate;
    private String codePage;
    private String ciphers;
    private short numberCiphers = (short)-1;
    private int httpVersionNumber = -1;
    private int httpReleaseNumber = -1;
    private String extractHost;
    private String extractPath;
    private int extractScheme = -1;
    private String extractVersion;
    private String extractUrimap;
    private int extractPortNumber = -1;
    private int extractHostType = -1;
    public static final int NOTSET = -1;
    public static final int NOTAPPLIC = 1;
    public static final int IPV4 = 300;
    public static final int IPV6 = 301;
    public static final int HOSTNAME = 302;
    private static final int HTTP = 1096;
    private static final int HTTPS = 1029;

    private native void OPEN(String var1, String var2, int var3, int var4, int var5, String var6, String var7, String var8, short var9, boolean var10) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException;

    private native void CLOSE(byte[] var1) throws NotOpenException;

    private native void EXTRACT(byte[] var1) throws NotOpenException;

    public HttpSession(String urimap) {
        this.urimap = this.spacePad(urimap, 8);
    }

    public HttpSession(String hostName, String scheme) {
        this.hostName = hostName;
        this.scheme = -1;
        if (scheme.equalsIgnoreCase("HTTPS")) {
            this.scheme = 1029;
        }
        if (scheme.equalsIgnoreCase("HTTP")) {
            this.scheme = 1096;
        }
    }

    public HttpSession(String hostName, String scheme, int portNumber) {
        this.hostName = hostName;
        this.scheme = -1;
        if (scheme.equalsIgnoreCase("HTTPS")) {
            this.scheme = 1029;
        }
        if (scheme.equalsIgnoreCase("HTTP")) {
            this.scheme = 1096;
        }
        this.portNumber = portNumber;
    }

    public void setCodePage(String codePage) {
        this.codePage = this.spacePad(codePage, 8);
    }

    public String getCodePage() {
        return this.codePage;
    }

    protected String getCodePageCharsetName() {
        String dataCodepageName = this.getCodePage();
        if (dataCodepageName != null) {
            if ("1208".equals(dataCodepageName = dataCodepageName.trim())) {
                return "UTF-8";
            }
            if ("01208".equals(dataCodepageName)) {
                return "UTF-8";
            }
            if ("1200".equals(dataCodepageName)) {
                return "UTF-16";
            }
            try {
                dataCodepageName = Charset.forName(dataCodepageName).name();
            }
            catch (Exception e) {
                try {
                    new String(new byte[]{-63, -16}, dataCodepageName);
                    return dataCodepageName;
                }
                catch (Exception e1) {
                    try {
                        dataCodepageName = Charset.forName("IBM" + dataCodepageName).name();
                    }
                    catch (Exception e2) {
                        dataCodepageName = Charset.forName("Cp" + dataCodepageName).name();
                    }
                }
            }
        }
        return dataCodepageName;
    }

    public void setCertificate(String certificate) {
        this.certificate = this.spacePad(certificate, 32);
    }

    public void setCiphers(String ciphers, short numberCiphers) {
        this.ciphers = ciphers;
        this.numberCiphers = numberCiphers;
    }

    public void open() throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, TimedOutException {
        if (this.urimap != null) {
            this.OPEN(this.urimap, null, -1, -1, -1, this.certificate, this.codePage, this.ciphers, this.numberCiphers, true);
        } else {
            this.OPEN(null, this.hostName, this.hostName.length(), this.scheme, this.portNumber, this.certificate, this.codePage, this.ciphers, this.numberCiphers, true);
        }
    }

    public void open(boolean options) throws InvalidRequestException, RecordNotFoundException, IOErrorException, NotAuthorisedException, LengthErrorException, TimedOutException {
        if (options) {
            this.open();
        } else if (this.urimap != null) {
            this.OPEN(this.urimap, null, -1, -1, -1, this.certificate, this.codePage, this.ciphers, this.numberCiphers, false);
        } else {
            this.OPEN(null, this.hostName, this.hostName.length(), this.scheme, this.portNumber, this.certificate, this.codePage, this.ciphers, this.numberCiphers, false);
        }
    }

    public int getHttpVersionNumber() {
        return this.httpVersionNumber;
    }

    public int getHttpReleaseNumber() {
        return this.httpReleaseNumber;
    }

    protected byte[] getSessionToken() {
        if (this.sessionToken != null) {
            return this.sessionToken;
        }
        byte[] sessToken = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        return sessToken;
    }

    public void close() throws InvalidRequestException, NotOpenException {
        if (this.sessionToken == null) {
            throw new NotOpenException("Session not open");
        }
        this.CLOSE(this.sessionToken);
        this.sessionToken = null;
        this.httpVersionNumber = -1;
        this.httpReleaseNumber = -1;
    }

    public String getHost() throws NotOpenException {
        if (this.extractHost == null) {
            this.EXTRACT(this.sessionToken);
        }
        return this.extractHost;
    }

    public int getHostType() throws NotOpenException {
        if (this.extractHostType == -1) {
            this.EXTRACT(this.sessionToken);
        }
        return this.extractHostType;
    }

    public String getPath() throws NotOpenException {
        if (this.extractPath == null) {
            this.EXTRACT(this.sessionToken);
        }
        return this.extractPath;
    }

    public String getScheme() throws NotOpenException {
        if (this.extractScheme == -1) {
            this.EXTRACT(this.sessionToken);
        }
        String schemeString = null;
        schemeString = this.extractScheme == 1096 ? "HTTP" : "HTTPS";
        return schemeString;
    }

    public String getVersion() throws NotOpenException {
        if (this.extractPath == null) {
            this.EXTRACT(this.sessionToken);
        }
        return this.extractVersion;
    }

    public String getUrimap() throws NotOpenException {
        if (this.extractUrimap == null) {
            this.EXTRACT(this.sessionToken);
        }
        return this.extractUrimap;
    }

    public int getPortNumber() throws NotOpenException {
        if (this.extractPortNumber == -1) {
            this.EXTRACT(this.sessionToken);
        }
        return this.extractPortNumber;
    }

    private String spacePad(String dataIn, int newLength) {
        if (dataIn == null) {
            return null;
        }
        StringBuilder dataOut = new StringBuilder();
        dataOut.append(dataIn);
        if (newLength > 0) {
            int spaces = newLength - dataIn.length();
            for (int i = 0; i < spaces; ++i) {
                dataOut.append(" ");
            }
            return dataOut.toString();
        }
        return dataIn;
    }
}

