/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CICSThreadLocalManager;
import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.osgi.CICSTaskService;
import com.ibm.cics.server.TaskAlreadyBoundRuntimeException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class IsCICS {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int UNABLE_TO_DETERMINE_STATUS = -1;
    public static final int NOT_CICS_REGION = 0;
    public static final int CICS_REGION_BUT_API_DISALLOWED = 1;
    public static final int CICS_REGION_AND_API_ALLOWED = 2;
    private static final int IN_CICS = 1;
    private static final int API_ALLOWED = 2;
    private static ThreadLocal<Integer> cachedResults = new ThreadLocal();
    private static CICSTaskService taskService;

    private static final native int DTCIsCICS();

    public static int getApiStatus() {
        return IsCICS.getApiStatus(true);
    }

    static int getApiStatus(boolean lateBind) {
        int retvalue = -1;
        ThreadLocal apiAllowed = null;
        Integer cachedResult = null;
        if (CommonConstants.THREADPOOL_ACTIVE && (apiAllowed = CICSThreadLocalManager.getThreadLocal((String)"API_ALLOWED")) != null && apiAllowed.get() != null) {
            retvalue = (Boolean)apiAllowed.get() == Boolean.TRUE ? 2 : 1;
        }
        if (retvalue == -1 && (cachedResult = cachedResults.get()) != null) {
            retvalue = cachedResult;
        }
        try {
            if (retvalue == -1) {
                int isCICSresult = IsCICS.DTCIsCICS();
                switch (isCICSresult & 3) {
                    case 0: {
                        retvalue = 0;
                        break;
                    }
                    case 1: {
                        retvalue = 1;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        retvalue = 2;
                        break;
                    }
                }
                cachedResults.set(retvalue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (UnsatisfiedLinkError ule) {
            // empty catch block
        }
        if (CommonConstants.THREADPOOL_ACTIVE && lateBind && retvalue == 1) {
            BundleContext ctx;
            ServiceReference servRef;
            if (taskService == null && (servRef = (ctx = FrameworkUtil.getBundle(CICSTaskService.class).getBundleContext()).getServiceReference(CICSTaskService.class)) != null) {
                taskService = (CICSTaskService)ctx.getService(servRef);
            }
            if (taskService != null) {
                try {
                    if (taskService.bindTask()) {
                        return 2;
                    }
                }
                catch (TaskAlreadyBoundRuntimeException tabre) {
                    throw new RuntimeException("Unexpected condition", tabre);
                }
            }
        }
        return retvalue;
    }
}

