/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.ChangedException;
import com.ibm.cics.server.CicsError;
import com.ibm.cics.server.DTCFile;
import com.ibm.cics.server.DuplicateKeyException;
import com.ibm.cics.server.DuplicateRecordException;
import com.ibm.cics.server.FileDisabledException;
import com.ibm.cics.server.FileNotFoundException;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.KeyedFile;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.LoadingException;
import com.ibm.cics.server.LockedException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NoSpaceException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RecordBusyException;
import com.ibm.cics.server.RecordNotFoundException;

public class KSDS
extends KeyedFile {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = -3061399328966602329L;

    public void delete() throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        try {
            DTCFile.DELETE_KSDS(this.getName(), this.getSysId(), null, false);
        }
        catch (DuplicateKeyException DKE) {
            throw new CicsError("Unexpected DuplicateKeyException caught");
        }
        catch (RecordNotFoundException RNFE) {
            throw new CicsError("Unexpected RecordNotFoundException caught");
        }
    }

    public void delete(byte[] key) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DTCFile.DELETE_KSDS(this.getName(), this.getSysId(), key, false);
    }

    public int deleteGeneric(byte[] key) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        int numberDeleted = 0;
        try {
            numberDeleted = DTCFile.DELETE_KSDS(this.getName(), this.getSysId(), key, true);
        }
        catch (DuplicateKeyException DKE) {
            throw new CicsError("Unexpected DuplicateKeyException caught");
        }
        return numberDeleted;
    }

    public void write(byte[] key, byte[] data) throws FileDisabledException, DuplicateRecordException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DTCFile.WRITE_KSDS(this.getName(), this.getSysId(), key, data);
    }
}

