/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.ChangedException;
import com.ibm.cics.server.DTCFile;
import com.ibm.cics.server.DuplicateKeyException;
import com.ibm.cics.server.DuplicateRecordException;
import com.ibm.cics.server.File;
import com.ibm.cics.server.FileDisabledException;
import com.ibm.cics.server.FileNotFoundException;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.KeyedFileBrowse;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.LoadingException;
import com.ibm.cics.server.LockedException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NoSpaceException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RecordBusyException;
import com.ibm.cics.server.RecordHolder;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.SearchType;

public class KeyedFile
extends File {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = -5327458558427905768L;

    public void read(byte[] key, RecordHolder holder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (holder == null) {
            throw new NullPointerException("null holder in KeyedFile.read()");
        }
        DTCFile.READ_Keyed(this.getName(), this.getSysId(), key, false, 0, false, holder);
    }

    public void read(byte[] key, SearchType searchType, RecordHolder holder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        if (holder == null) {
            throw new NullPointerException("null holder in KeyedFile.read()");
        }
        DTCFile.READ_Keyed(this.getName(), this.getSysId(), key, false, searchType.hashCode(), false, holder);
    }

    public void readForUpdate(byte[] key, RecordHolder holder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        if (holder == null) {
            throw new NullPointerException("null holder in KeyedFile.readForUpdate()");
        }
        DTCFile.READ_Keyed(this.getName(), this.getSysId(), key, false, 0, true, holder);
    }

    public void readForUpdate(byte[] key, SearchType searchType, RecordHolder holder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        if (holder == null) {
            throw new NullPointerException("null holder in KeyedFile.readForUpdate()");
        }
        DTCFile.READ_Keyed(this.getName(), this.getSysId(), key, false, searchType.hashCode(), true, holder);
    }

    public void readGeneric(byte[] key, RecordHolder holder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        if (holder == null) {
            throw new NullPointerException("null holder in KeyedFile.readGeneric()");
        }
        DTCFile.READ_Keyed(this.getName(), this.getSysId(), key, true, 0, false, holder);
    }

    public void readGeneric(byte[] key, SearchType searchType, RecordHolder holder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (holder == null) {
            throw new NullPointerException("null holder in KeyedFile.readGeneric()");
        }
        DTCFile.READ_Keyed(this.getName(), this.getSysId(), key, true, searchType.hashCode(), false, holder);
    }

    public void readGenericForUpdate(byte[] key, RecordHolder holder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (holder == null) {
            throw new NullPointerException("null holder in KeyedFile.readGenericForUpdate()");
        }
        DTCFile.READ_Keyed(this.getName(), this.getSysId(), key, true, 0, true, holder);
    }

    public void readGenericForUpdate(byte[] key, SearchType searchType, RecordHolder holder) throws FileDisabledException, DuplicateKeyException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (holder == null) {
            throw new NullPointerException("null holder in KeyedFile.readGenericForUpdate()");
        }
        DTCFile.READ_Keyed(this.getName(), this.getSysId(), key, true, searchType.hashCode(), true, holder);
    }

    public void rewrite(byte[] data) throws FileDisabledException, DuplicateRecordException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        if (data == null) {
            throw new NullPointerException("null data in KeyedFile.rewrite()");
        }
        DTCFile.REWRITE(this.getName(), this.getSysId(), data);
    }

    public KeyedFileBrowse startBrowse(byte[] key) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, RecordBusyException, LoadingException, ChangedException {
        if (key == null) {
            throw new NullPointerException("null key in KeyedFile.startBrowse()");
        }
        KeyedFileBrowse newBrowse = new KeyedFileBrowse(this.getName(), this.getSysId(), key, key.length, false, 0);
        return newBrowse;
    }

    public KeyedFileBrowse startBrowse(byte[] key, SearchType searchType) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        if (key == null) {
            throw new NullPointerException("null key in KeyedFile.startBrowse()");
        }
        KeyedFileBrowse newBrowse = new KeyedFileBrowse(this.getName(), this.getSysId(), key, key.length, false, searchType.hashCode());
        return newBrowse;
    }

    public KeyedFileBrowse startGenericBrowse(byte[] key, int fullKeyLength) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        if (key == null) {
            throw new NullPointerException("null key in KeyedFile.startGenericBrowse()");
        }
        KeyedFileBrowse newBrowse = new KeyedFileBrowse(this.getName(), this.getSysId(), key, fullKeyLength, true, 0);
        return newBrowse;
    }

    public KeyedFileBrowse startGenericBrowse(byte[] key, int fullKeyLength, SearchType searchType) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, LockedException, ChangedException, LoadingException, RecordBusyException {
        if (key == null) {
            throw new NullPointerException("null key in KeyedFile.startGenericBrowse()");
        }
        KeyedFileBrowse newBrowse = new KeyedFileBrowse(this.getName(), this.getSysId(), key, fullKeyLength, true, searchType.hashCode());
        return newBrowse;
    }
}

