/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.ChangedException;
import com.ibm.cics.server.DTCFile;
import com.ibm.cics.server.DuplicateKeyException;
import com.ibm.cics.server.EndOfFileException;
import com.ibm.cics.server.FileBrowse;
import com.ibm.cics.server.FileDisabledException;
import com.ibm.cics.server.FileNotFoundException;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.KeyHolder;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.LoadingException;
import com.ibm.cics.server.LockedException;
import com.ibm.cics.server.LogicException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.RecordBusyException;
import com.ibm.cics.server.RecordHolder;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.SearchType;

public class KeyedFileBrowse
extends FileBrowse {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int fullKeyLength;
    private byte[] previousKey;

    protected KeyedFileBrowse(String fileName, String sysId) {
        super(fileName, sysId);
    }

    protected KeyedFileBrowse(String fileName, String sysId, byte[] key, int fullKeyLength, boolean generic, int searchType) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        super(fileName, sysId);
        DTCFile.STARTBR_Keyed(fileName, sysId, key, fullKeyLength, this.getRequestID(), generic, searchType);
        this.fullKeyLength = fullKeyLength;
        this.previousKey = new byte[fullKeyLength];
        System.arraycopy(key, 0, this.previousKey, 0, key.length);
    }

    public void next(byte[] inputKey, RecordHolder record, KeyHolder outputKey) throws FileDisabledException, DuplicateKeyException, EndOfFileException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        try {
            DTCFile.READNEXT_Keyed(this.fileName, this.sysId, this.getRequestID(), inputKey, this.fullKeyLength, outputKey, record);
        }
        catch (DuplicateKeyException dke) {
            System.arraycopy(outputKey.getValue(), 0, this.previousKey, 0, outputKey.getValue().length);
            throw dke;
        }
        System.arraycopy(outputKey.getValue(), 0, this.previousKey, 0, outputKey.getValue().length);
    }

    public void next(RecordHolder record, KeyHolder outputKey) throws FileDisabledException, DuplicateKeyException, EndOfFileException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        try {
            DTCFile.READNEXT_Keyed(this.fileName, this.sysId, this.getRequestID(), this.previousKey, this.fullKeyLength, outputKey, record);
        }
        catch (DuplicateKeyException dke) {
            System.arraycopy(outputKey.getValue(), 0, this.previousKey, 0, outputKey.getValue().length);
            throw dke;
        }
        System.arraycopy(outputKey.getValue(), 0, this.previousKey, 0, outputKey.getValue().length);
    }

    public void previous(byte[] inputKey, RecordHolder record, KeyHolder outputKey) throws FileDisabledException, DuplicateKeyException, EndOfFileException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        try {
            DTCFile.READPREV_Keyed(this.fileName, this.sysId, this.getRequestID(), inputKey, this.fullKeyLength, outputKey, record);
        }
        catch (DuplicateKeyException dke) {
            System.arraycopy(outputKey.getValue(), 0, this.previousKey, 0, outputKey.getValue().length);
            throw dke;
        }
        System.arraycopy(outputKey.getValue(), 0, this.previousKey, 0, outputKey.getValue().length);
    }

    public void previous(RecordHolder record, KeyHolder outputKey) throws FileDisabledException, DuplicateKeyException, EndOfFileException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        try {
            DTCFile.READPREV_Keyed(this.fileName, this.sysId, this.getRequestID(), this.previousKey, this.fullKeyLength, outputKey, record);
        }
        catch (DuplicateKeyException dke) {
            System.arraycopy(outputKey.getValue(), 0, this.previousKey, 0, outputKey.getValue().length);
            throw dke;
        }
        System.arraycopy(outputKey.getValue(), 0, this.previousKey, 0, outputKey.getValue().length);
    }

    public void reset(byte[] key) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DTCFile.RESETBR_Keyed(this.fileName, this.sysId, key, this.fullKeyLength, this.getRequestID(), false, 0);
        System.arraycopy(key, 0, this.previousKey, 0, key.length);
    }

    public void reset(byte[] key, SearchType searchType) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DTCFile.RESETBR_Keyed(this.fileName, this.sysId, key, this.fullKeyLength, this.getRequestID(), false, searchType.hashCode());
        System.arraycopy(key, 0, this.previousKey, 0, key.length);
    }

    public void reset(byte[] key, boolean generic) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DTCFile.RESETBR_Keyed(this.fileName, this.sysId, key, this.fullKeyLength, this.getRequestID(), generic, 0);
        System.arraycopy(key, 0, this.previousKey, 0, key.length);
    }

    public void reset(byte[] key, boolean generic, SearchType searchType) throws FileDisabledException, FileNotFoundException, LogicException, InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, NotOpenException, InvalidSystemIdException, ChangedException, LockedException, LoadingException, RecordBusyException {
        DTCFile.RESETBR_Keyed(this.fileName, this.sysId, key, this.fullKeyLength, this.getRequestID(), generic, searchType.hashCode());
        System.arraycopy(key, 0, this.previousKey, 0, key.length);
    }
}

