/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.DTCProgram;
import com.ibm.cics.server.DataLength;
import com.ibm.cics.server.InvalidProgramIdException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.RemotableResource;
import com.ibm.cics.server.RolledBackException;
import com.ibm.cics.server.TerminalException;

public class Program
extends RemotableResource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = -4417976934390189065L;
    private boolean syncOnReturn;
    private String transId = "";

    public boolean getSyncOnReturn() {
        return this.syncOnReturn;
    }

    public String getTransId() {
        return this.transId;
    }

    public void link() throws InvalidRequestException, LengthErrorException, NotAuthorisedException, InvalidProgramIdException, RolledBackException, InvalidSystemIdException, TerminalException {
        try {
            DTCProgram.LINK(this.getName(), null, this.getSysId(), this.syncOnReturn, this.transId, null, null);
        }
        catch (ChannelErrorException channelErrorException) {
            // empty catch block
        }
    }

    public void link(byte[] CA) throws InvalidRequestException, LengthErrorException, NotAuthorisedException, InvalidProgramIdException, RolledBackException, InvalidSystemIdException, TerminalException {
        try {
            DTCProgram.LINK(this.getName(), CA, this.getSysId(), this.syncOnReturn, this.transId, null, null);
        }
        catch (ChannelErrorException channelErrorException) {
            // empty catch block
        }
    }

    public void link(byte[] CA, int DATALENGTH) throws InvalidRequestException, LengthErrorException, NotAuthorisedException, InvalidProgramIdException, RolledBackException, InvalidSystemIdException, TerminalException {
        try {
            DTCProgram.LINK(this.getName(), CA, this.getSysId(), this.getSyncOnReturn(), this.getTransId(), new DataLength(DATALENGTH), null);
        }
        catch (ChannelErrorException channelErrorException) {
            // empty catch block
        }
    }

    public void link(Channel chan) throws InvalidRequestException, LengthErrorException, NotAuthorisedException, InvalidProgramIdException, RolledBackException, InvalidSystemIdException, TerminalException, ChannelErrorException {
        DTCProgram.LINK(this.getName(), null, this.getSysId(), this.syncOnReturn, this.transId, null, chan == null ? null : chan.getName());
    }

    public void setSyncOnReturn(boolean syncOnReturn) {
        this.syncOnReturn = syncOnReturn;
    }

    public void setTransId(String TRANSID) {
        this.transId = TRANSID;
    }
}

