/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.CWAHolder;
import com.ibm.cics.server.RegionTraceBits;
import com.ibm.cics.server.internal.JCICSLateBinding;
import java.util.BitSet;

public class Region
implements RegionTraceBits {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String APPLID;
    private static String SYSID;

    private static void initialise() {
        JCICSLateBinding.bindTaskIfRequired();
        Region.getRegionData();
    }

    private static final native void ADDRESS_CWA(CWAHolder var0);

    private static final native void DISABLE_TRACE(boolean var0, boolean var1, boolean var2);

    public static void disableTrace() {
        JCICSLateBinding.bindTaskIfRequired();
        Region.DISABLE_TRACE(false, false, false);
    }

    public static void disableTrace(BitSet options) {
        boolean ei = false;
        boolean system = false;
        boolean user = false;
        ei = options.get(0);
        system = options.get(1);
        user = options.get(2);
        JCICSLateBinding.bindTaskIfRequired();
        Region.DISABLE_TRACE(ei, system, user);
    }

    private static final native void ENABLE_TRACE(boolean var0, boolean var1, boolean var2);

    public static void enableTrace() {
        JCICSLateBinding.bindTaskIfRequired();
        Region.ENABLE_TRACE(false, false, false);
    }

    public static void enableTrace(BitSet options) {
        boolean ei = false;
        boolean system = false;
        boolean user = false;
        ei = options.get(0);
        system = options.get(1);
        user = options.get(2);
        JCICSLateBinding.bindTaskIfRequired();
        Region.ENABLE_TRACE(ei, system, user);
    }

    public static String getAPPLID() {
        if (APPLID == null) {
            Region.initialise();
        }
        return APPLID;
    }

    public static void getCWA(CWAHolder holder) {
        if (holder == null) {
            throw new NullPointerException("null holder in Region.getCWA()");
        }
        JCICSLateBinding.bindTaskIfRequired();
        Region.ADDRESS_CWA(holder);
    }

    private static final native void getRegionData();

    public static String getSYSID() {
        if (SYSID == null) {
            Region.initialise();
        }
        return SYSID;
    }

    static void setAPPLID(String applid) {
        APPLID = applid == null ? null : applid.trim();
    }

    public static void setCWA(byte[] data) {
        if (data == null) {
            throw new NullPointerException("null data in setCWA()");
        }
        JCICSLateBinding.bindTaskIfRequired();
        Region.UPDATE_CWA(data);
    }

    static void setSYSID(String SYSID) {
        Region.SYSID = SYSID == null ? null : SYSID;
    }

    private static final native void UPDATE_CWA(byte[] var0);
}

