/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.CCSIDErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.internal.JCICSLateBinding;

public class SoapFault {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2004, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int SENDER = 1045;
    public static final int RECEIVER = 1046;
    public static final int CLIENT = 1122;
    public static final int SERVER = 1123;
    private static final String nullString = "";

    public static void create(int faultcode, String faultstring, String natlang, String faultactor, String role, String detail) throws InvalidRequestException, CCSIDErrorException, LengthErrorException {
        JCICSLateBinding.bindTaskIfRequired();
        SoapFault.CREATE(faultcode, nullString, faultstring, natlang, faultactor, role, detail);
    }

    public static void create(int faultcode, String faultstring, String natlang, String detail) throws InvalidRequestException, CCSIDErrorException, LengthErrorException {
        JCICSLateBinding.bindTaskIfRequired();
        SoapFault.CREATE(faultcode, nullString, faultstring, natlang, nullString, nullString, detail);
    }

    public static void create(int faultcode, String faultstring, String detail) throws InvalidRequestException, CCSIDErrorException, LengthErrorException {
        JCICSLateBinding.bindTaskIfRequired();
        SoapFault.CREATE(faultcode, nullString, faultstring, nullString, nullString, nullString, detail);
    }

    public static void create(int faultcode, String faultstring) throws InvalidRequestException, CCSIDErrorException, LengthErrorException {
        JCICSLateBinding.bindTaskIfRequired();
        SoapFault.CREATE(faultcode, nullString, faultstring, nullString, nullString, nullString, nullString);
    }

    public static void create(String faultcodeString, String faultstring, String natlang, String faultactor, String role, String detail) throws InvalidRequestException, CCSIDErrorException, LengthErrorException {
        JCICSLateBinding.bindTaskIfRequired();
        SoapFault.CREATE(0, faultcodeString, faultstring, natlang, faultactor, role, detail);
    }

    public static void addFaultstring(String faultstring, String natlang) throws RecordNotFoundException, InvalidRequestException, CCSIDErrorException, LengthErrorException {
        JCICSLateBinding.bindTaskIfRequired();
        SoapFault.ADDFAULTSTRING(faultstring, natlang);
    }

    public static void addSubcode(String subcode) throws RecordNotFoundException, InvalidRequestException, CCSIDErrorException, LengthErrorException {
        JCICSLateBinding.bindTaskIfRequired();
        SoapFault.ADDSUBCODE(subcode);
    }

    public static void delete() throws RecordNotFoundException {
        JCICSLateBinding.bindTaskIfRequired();
        SoapFault.DELETE();
    }

    private static final native void CREATE(int var0, String var1, String var2, String var3, String var4, String var5, String var6) throws InvalidRequestException, CCSIDErrorException, LengthErrorException;

    private static final native void ADDFAULTSTRING(String var0, String var1) throws RecordNotFoundException, InvalidRequestException, CCSIDErrorException, LengthErrorException;

    private static final native void ADDSUBCODE(String var0) throws RecordNotFoundException, InvalidRequestException, CCSIDErrorException, LengthErrorException;

    private static final native void DELETE() throws RecordNotFoundException;
}

