/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.DTCTSQ;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.InvalidTransactionIdException;
import com.ibm.cics.server.InvalidUserIdException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.RemotableResource;
import com.ibm.cics.server.TerminalException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class StartRequest
extends RemotableResource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Calendar time;
    private byte[] ID = new byte[0];
    private String terminal = "";
    private String userId = null;
    private String rTransaction = "";
    private String rTerminal = "";
    private byte[] queueName = new byte[0];
    private boolean checked = true;
    private boolean isProtected = false;
    static final int START_OK = 0;
    static final int INTERVAL_ERROR = 1;
    static final int REQID_ERROR = 2;
    static final int RTRANSID_ERROR = 3;
    static final int RTERMINAL_ERROR = 4;
    static final int QUEUE_ERROR = 5;
    static final int NOCHECK_ERROR = 6;
    static final int PROTECT_ERROR = 7;
    static final long serialVersionUID = 3500682743308421323L;

    public void cancel() throws InvalidRequestException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, InvalidSystemIdException {
        byte[] idBytes = this.getID();
        if (idBytes == null || idBytes.length < 8 || idBytes[0] == 0 && idBytes[1] == 0 && idBytes[2] == 0 && idBytes[3] == 0 && idBytes[4] == 0 && idBytes[5] == 0 && idBytes[6] == 0 && idBytes[7] == 0) {
            throw new InvalidRequestException("null REQID invalid for CANCEL", 0);
        }
        StartRequest.CANCEL(this.getID(), this.getName(), this.getSysId());
    }

    public void setTransId(String transId) {
        if (transId.length() == 0 || transId.length() > 3) {
            this.setName(transId);
        } else {
            switch (transId.length()) {
                case 3: {
                    this.setName(transId + " ");
                    break;
                }
                case 2: {
                    this.setName(transId + "  ");
                    break;
                }
                case 1: {
                    this.setName(transId + "   ");
                }
            }
        }
    }

    private static final native void CANCEL(byte[] var0, String var1, String var2) throws InvalidRequestException, ISCInvalidRequestException, NotAuthorisedException, RecordNotFoundException, InvalidSystemIdException;

    public byte[] getID() {
        return this.ID;
    }

    public String getIDAsString() {
        try {
            return new String(this.ID, CommonConstants.LOCALCCSID);
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.ID);
        }
    }

    public byte[] getQueueName() {
        return this.queueName;
    }

    public String getQueueNameAsString() {
        try {
            return new String(this.getQueueName(), CommonConstants.LOCALCCSID);
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.getQueueName());
        }
    }

    public String getRTerminal() {
        return this.rTerminal;
    }

    public String getRTransaction() {
        return this.rTransaction;
    }

    public String getTerminal() {
        return this.terminal;
    }

    public Calendar getTime() {
        return this.time;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTransId() {
        return this.getName();
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void issue() throws InvalidRequestException, ISCInvalidRequestException, IOErrorException, LengthErrorException, NotAuthorisedException, InvalidSystemIdException, TerminalException, InvalidTransactionIdException, InvalidUserIdException {
        long currentTimeInMillis = System.currentTimeMillis();
        int seconds = 0;
        byte[] result = null;
        byte[] originalID = null;
        if (this.time == null) {
            seconds = 0;
            Calendar startTime = Calendar.getInstance();
            this.setTime(startTime);
        } else {
            long calendarTimeInMillis = this.time.getTime().getTime();
            seconds = calendarTimeInMillis <= currentTimeInMillis ? 0 : (int)((calendarTimeInMillis - currentTimeInMillis) / 1000L);
        }
        try {
            result = StartRequest.START(seconds, this.getName(), this.getID(), null, this.getTerminal(), this.getUserId(), this.getSysId(), this.getRTransaction(), this.getRTerminal(), this.getQueueName(), this.isChecked(), this.isProtected(), null);
        }
        catch (ChannelErrorException e) {
            // empty catch block
        }
        originalID = this.getID();
        if (originalID == null || originalID.length == 0) {
            if (!this.isChecked()) {
                byte[] paddedBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                this.setID(paddedBytes);
            } else {
                this.setID(result);
            }
        }
    }

    public void issue(byte[] data) throws InvalidRequestException, ISCInvalidRequestException, IOErrorException, LengthErrorException, NotAuthorisedException, InvalidSystemIdException, TerminalException, InvalidTransactionIdException, InvalidUserIdException {
        long currentTimeInMillis = System.currentTimeMillis();
        int seconds = 0;
        byte[] result = null;
        byte[] originalID = null;
        if (this.time == null) {
            seconds = 0;
            Calendar startTime = Calendar.getInstance();
            this.setTime(startTime);
        } else {
            long calendarTimeInMillis = this.time.getTime().getTime();
            seconds = calendarTimeInMillis <= currentTimeInMillis ? 0 : (int)((calendarTimeInMillis - currentTimeInMillis) / 1000L);
        }
        try {
            result = StartRequest.START(seconds, this.getName(), this.getID(), data, this.getTerminal(), this.getUserId(), this.getSysId(), this.getRTransaction(), this.getRTerminal(), this.getQueueName(), this.isChecked(), this.isProtected(), null);
        }
        catch (ChannelErrorException e) {
            // empty catch block
        }
        originalID = this.getID();
        if (originalID == null || originalID.length == 0) {
            if (!this.isChecked()) {
                byte[] paddedBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                this.setID(paddedBytes);
            } else {
                this.setID(result);
            }
        }
    }

    public void issue(Channel chan) throws InvalidRequestException, ISCInvalidRequestException, IOErrorException, LengthErrorException, NotAuthorisedException, InvalidSystemIdException, TerminalException, InvalidTransactionIdException, InvalidUserIdException, ChannelErrorException {
        int startError = 0;
        if (this.time != null) {
            startError = 1;
        } else if (this.ID.length > 0) {
            startError = 2;
        } else if (this.rTransaction != null && this.rTransaction.length() > 0) {
            startError = 3;
        } else if (this.rTerminal != null && this.rTerminal.length() > 0) {
            startError = 4;
        } else if (this.queueName.length > 0) {
            startError = 5;
        } else if (!this.checked) {
            startError = 6;
        } else if (this.isProtected) {
            startError = 7;
        }
        if (startError != 0) {
            StringBuilder msgBuffer = new StringBuilder();
            switch (startError) {
                case 1: {
                    msgBuffer.append("Interval");
                    break;
                }
                case 2: {
                    msgBuffer.append("Reqid");
                    break;
                }
                case 3: {
                    msgBuffer.append("Rtransid");
                    break;
                }
                case 4: {
                    msgBuffer.append("Rterminal");
                    break;
                }
                case 5: {
                    msgBuffer.append("Queue");
                    break;
                }
                case 6: {
                    msgBuffer.append("Nocheck");
                    break;
                }
                case 7: {
                    msgBuffer.append("Protect");
                    break;
                }
                default: {
                    msgBuffer.append("????????");
                }
            }
            msgBuffer.append(" is incompatible with Channel");
            throw new InvalidRequestException(msgBuffer.toString(), 9);
        }
        StartRequest.START(0, this.getName(), null, null, this.getTerminal(), this.getUserId(), this.getSysId(), null, null, null, true, false, chan == null ? null : chan.getName());
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public void setID(byte[] id) {
        if (id == null) {
            throw new NullPointerException("null start id");
        }
        int length = 8;
        if (id.length > 8) {
            length = id.length;
        }
        byte[] paddedBytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            paddedBytes[i] = 0;
        }
        System.arraycopy(id, 0, paddedBytes, 0, id.length);
        this.ID = paddedBytes;
    }

    public void setIDFromString(String id) {
        byte[] idBytes;
        if (id == null) {
            throw new NullPointerException("null start id");
        }
        String paddedId = id + "        ";
        try {
            idBytes = paddedId.getBytes(CommonConstants.LOCALCCSID);
        }
        catch (UnsupportedEncodingException e) {
            idBytes = paddedId.getBytes();
        }
        this.ID = new byte[8];
        System.arraycopy(idBytes, 0, this.ID, 0, 8);
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    public void setQueueName(byte[] queueName) throws NullPointerException {
        if (queueName == null) {
            throw new NullPointerException("null TSQ queueName");
        }
        if (queueName.length < 8) {
            this.queueName = DTCTSQ.SETNAME(queueName);
        } else {
            this.queueName = new byte[8];
            System.arraycopy(queueName, 0, this.queueName, 0, 8);
        }
    }

    public void setQueueNameFromString(String name) throws NullPointerException {
        byte[] nameBytes;
        if (name == null) {
            throw new NullPointerException("null TSQ name");
        }
        try {
            nameBytes = name.getBytes(CommonConstants.LOCALCCSID);
        }
        catch (UnsupportedEncodingException e) {
            nameBytes = name.getBytes();
        }
        this.setQueueName(nameBytes);
    }

    public void setRTerminal(String rTerminal) {
        this.rTerminal = rTerminal;
    }

    public void setRTransaction(String rTransaction) {
        this.rTransaction = rTransaction;
    }

    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    public void setTime(Calendar calendar) {
        this.time = new GregorianCalendar();
        this.time.setTimeInMillis(calendar.getTimeInMillis());
    }

    public void setUserId(String userId) {
        if (userId == null) {
            throw new NullPointerException("null user ID");
        }
        if (userId.trim().length() == 0) {
            this.userId = null;
        } else if (userId.length() != 8) {
            StringBuilder sb = new StringBuilder(userId);
            if (sb.length() < 8) {
                sb.append("        ");
            }
            this.userId = sb.substring(0, 8);
        } else {
            this.userId = userId;
        }
    }

    public void resetRequestData() {
        this.time = null;
        this.ID = new byte[0];
        this.rTransaction = null;
        this.rTerminal = null;
        this.queueName = new byte[0];
        this.checked = true;
        this.isProtected = false;
    }

    private static final native byte[] START(int var0, String var1, byte[] var2, byte[] var3, String var4, String var5, String var6, String var7, String var8, byte[] var9, boolean var10, boolean var11, String var12) throws InvalidRequestException, ISCInvalidRequestException, IOErrorException, LengthErrorException, NotAuthorisedException, InvalidSystemIdException, TerminalException, InvalidTransactionIdException, ChannelErrorException, InvalidUserIdException;
}

