/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import java.io.UnsupportedEncodingException;

public class SymbolList {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NOTSET = -1;
    private String symbolList;
    private byte[] symbolListBA;
    private int length = -1;
    private char delimiter = (char)38;
    private boolean unescaped = false;

    public SymbolList(String sList) {
        this.setSymbolList(sList);
    }

    public SymbolList(byte[] sList) {
        this.setSymbolList(sList);
    }

    public SymbolList(String sList, char delim, boolean unesc) {
        this.setSymbolList(sList);
        this.setDelimiter(delim);
        this.setUnescaped(unesc);
    }

    public SymbolList(byte[] sList, char delim, boolean unesc) {
        this.setSymbolList(sList);
        this.setDelimiter(delim);
        this.setUnescaped(unesc);
    }

    public String getSymbolList() {
        if (this.symbolList != null) {
            return this.symbolList;
        }
        if (this.symbolListBA != null) {
            try {
                return new String(this.symbolListBA, CommonConstants.LOCALCCSID);
            }
            catch (UnsupportedEncodingException e) {
                return new String(this.symbolListBA);
            }
        }
        return null;
    }

    public byte[] getSymbolListAsByteArray() {
        if (this.symbolListBA != null) {
            return this.symbolListBA;
        }
        if (this.symbolList != null) {
            try {
                return this.symbolList.getBytes(CommonConstants.LOCALCCSID);
            }
            catch (UnsupportedEncodingException e) {
                return this.symbolList.getBytes();
            }
        }
        return null;
    }

    public int getLength() {
        return this.length;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public boolean getUnescaped() {
        return this.unescaped;
    }

    public void setSymbolList(String sList) {
        this.symbolList = sList;
        this.symbolListBA = null;
        this.length = this.symbolList != null ? this.symbolList.length() : -1;
    }

    public void setSymbolList(byte[] sList) {
        this.symbolListBA = sList;
        this.symbolList = null;
        this.length = this.symbolListBA == null ? -1 : this.symbolListBA.length;
    }

    public void setDelimiter(char delim) {
        this.delimiter = delim;
    }

    public void setUnescaped(boolean unesc) {
        this.unescaped = unesc;
    }
}

