/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.server.API;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.ResourceUnavailableException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public abstract class SynchronizationResource
extends API
implements Serializable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = -4417976934390189065L;
    private String description = "Synchronization Resource";

    protected void dequeue(byte[] data) throws LengthErrorException {
        if (data == null || data.length == 0) {
            throw new LengthErrorException("invalid dequeue address");
        }
        SynchronizationResource.DEQUEUE(data, 0);
    }

    protected void dequeue(String name) throws LengthErrorException {
        byte[] data;
        try {
            data = name.getBytes(CommonConstants.LOCALCCSID);
        }
        catch (UnsupportedEncodingException e) {
            data = name.getBytes();
        }
        if (data == null || data.length == 0) {
            throw new LengthErrorException("invalid dequeue name");
        }
        SynchronizationResource.DEQUEUE(data, data.length);
    }

    protected void enqueue(byte[] data, boolean suspend) throws ResourceUnavailableException, LengthErrorException {
        if (data == null || data.length == 0) {
            throw new LengthErrorException("invalid enqueue address");
        }
        SynchronizationResource.ENQUEUE(data, 0, suspend);
    }

    protected void enqueue(String name, boolean suspend) throws ResourceUnavailableException, LengthErrorException {
        byte[] data;
        try {
            data = name.getBytes(CommonConstants.LOCALCCSID);
        }
        catch (UnsupportedEncodingException e) {
            data = name.getBytes();
        }
        if (data == null || data.length == 0) {
            throw new LengthErrorException("invalid enqueue name");
        }
        SynchronizationResource.ENQUEUE(data, data.length, suspend);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private static final native void DEQUEUE(byte[] var0, int var1) throws LengthErrorException;

    private static final native void ENQUEUE(byte[] var0, int var1, boolean var2) throws ResourceUnavailableException, LengthErrorException;
}

