/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.server.CicsError;
import com.ibm.cics.server.DTCTDQ;
import com.ibm.cics.server.DataHolder;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidQueueIdException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NoSpaceException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.NotOpenException;
import com.ibm.cics.server.QueueBusyException;
import com.ibm.cics.server.QueueZeroException;
import com.ibm.cics.server.RemotableResource;
import java.io.UnsupportedEncodingException;

public class TDQ
extends RemotableResource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = -1610563867982428214L;

    public void delete() throws IOErrorException, ISCInvalidRequestException, NotAuthorisedException, InvalidQueueIdException, InvalidSystemIdException {
        String name = this.getName();
        if (name == null) {
            throw new NullPointerException("TDQ name is missing");
        }
        DTCTDQ.DELETE(name, this.getSysId());
    }

    public void readData(DataHolder holder) throws IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, NotOpenException, InvalidQueueIdException, QueueZeroException, InvalidSystemIdException {
        String name = this.getName();
        if (name == null) {
            throw new NullPointerException("TDQ name is missing");
        }
        if (holder == null) {
            throw new NullPointerException("DataHolder is null");
        }
        try {
            DTCTDQ.READ(name, this.getSysId(), holder, false);
        }
        catch (QueueBusyException QBE) {
            throw new CicsError("QueueBusyException unexpected");
        }
    }

    public void readDataConditional(DataHolder holder) throws IOErrorException, ISCInvalidRequestException, LengthErrorException, NotAuthorisedException, NotOpenException, QueueBusyException, InvalidQueueIdException, QueueZeroException, InvalidSystemIdException {
        String name = this.getName();
        if (name == null) {
            throw new NullPointerException("TDQ name is missing");
        }
        if (holder == null) {
            throw new NullPointerException("DataHolder is null");
        }
        DTCTDQ.READ(name, this.getSysId(), holder, true);
    }

    public void writeData(byte[] data) throws IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException {
        String name = this.getName();
        if (name == null) {
            throw new NullPointerException("TDQ name is missing");
        }
        if (data == null) {
            throw new NullPointerException("byte[] data is null");
        }
        DTCTDQ.WRITE(name, data, this.getSysId(), true);
    }

    public void writeString(String data) throws IOErrorException, ISCInvalidRequestException, LengthErrorException, NoSpaceException, NotAuthorisedException, NotOpenException, InvalidSystemIdException {
        String name = this.getName();
        if (name == null) {
            throw new NullPointerException("TDQ name is missing");
        }
        if (data == null) {
            throw new NullPointerException("String data is null");
        }
        try {
            DTCTDQ.WRITE(name, data.getBytes(CommonConstants.LOCALCCSID), this.getSysId(), true);
        }
        catch (UnsupportedEncodingException e) {
            DTCTDQ.WRITE(name, data.getBytes(), this.getSysId(), true);
        }
    }
}

