/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.server.CicsError;
import com.ibm.cics.server.DTCTSQ;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.ISCInvalidRequestException;
import com.ibm.cics.server.InvalidQueueIdException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidSystemIdException;
import com.ibm.cics.server.ItemErrorException;
import com.ibm.cics.server.ItemHolder;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NoSpaceException;
import com.ibm.cics.server.NotAuthorisedException;
import com.ibm.cics.server.RemotableResource;
import com.ibm.cics.server.TSQType;
import java.io.UnsupportedEncodingException;

public class TSQ
extends RemotableResource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = 6275748093699813383L;
    private byte[] queueName = new byte[0];
    protected TSQType type = TSQType.AUXILIARY;

    public void delete() throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, NotAuthorisedException, InvalidQueueIdException, InvalidSystemIdException {
        DTCTSQ.DELETE(this.getQueueName(), this.getSysId());
    }

    @Override
    public String getName() {
        try {
            return new String(this.getQueueName(), CommonConstants.LOCALCCSID);
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.getQueueName());
        }
    }

    public byte[] getQueueName() {
        return this.queueName;
    }

    public TSQType getType() {
        return this.type;
    }

    public int readItem(int item, ItemHolder holder) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NotAuthorisedException, InvalidQueueIdException, InvalidSystemIdException {
        if (holder == null) {
            throw new NullPointerException("ItemHolder 'holder' is null");
        }
        return DTCTSQ.READITEM(this.getQueueName(), this.getSysId(), item, holder);
    }

    public int readNextItem(ItemHolder holder) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NotAuthorisedException, InvalidQueueIdException, InvalidSystemIdException {
        if (holder == null) {
            throw new NullPointerException("ItemHolder 'holder' is null");
        }
        return DTCTSQ.READNEXT(this.getQueueName(), this.getSysId(), holder);
    }

    public void rewriteItem(int item, byte[] data) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NotAuthorisedException, InvalidQueueIdException, InvalidSystemIdException {
        this.validateByteArray(data);
        try {
            DTCTSQ.REWRITE(this.getQueueName(), data, item, this.getSysId(), this.getType().hashCode(), false);
        }
        catch (NoSpaceException NAE) {
            throw new CicsError("NoSpaceException unexpected");
        }
    }

    public void rewriteItemConditional(int item, byte[] data) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NoSpaceException, NotAuthorisedException, InvalidQueueIdException, InvalidSystemIdException {
        this.validateByteArray(data);
        DTCTSQ.REWRITE(this.getQueueName(), data, item, this.getSysId(), this.getType().hashCode(), true);
    }

    @Override
    public void setName(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("null TSQ name");
        }
        byte[] nameBytes = null;
        try {
            nameBytes = name.getBytes(CommonConstants.LOCALCCSID);
        }
        catch (UnsupportedEncodingException e) {
            nameBytes = name.getBytes();
        }
        this.queueName = DTCTSQ.SETNAME(nameBytes);
    }

    public void setQueueName(byte[] queueName) throws NullPointerException {
        if (queueName == null) {
            throw new NullPointerException("null TSQ queueName");
        }
        this.queueName = DTCTSQ.SETNAME(queueName);
    }

    public void setType(TSQType type) {
        if (type == null) {
            throw new NullPointerException("TSQType 'type' is null");
        }
        this.type = type;
    }

    public int writeItem(byte[] data) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NotAuthorisedException, InvalidSystemIdException {
        this.validateByteArray(data);
        try {
            return DTCTSQ.WRITE(this.getQueueName(), data, this.getSysId(), this.getType().hashCode(), false);
        }
        catch (NoSpaceException NAE) {
            throw new CicsError("NoSpaceException unexpected");
        }
    }

    public int writeString(String data) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NotAuthorisedException, InvalidSystemIdException {
        byte[] dataBytes;
        if (data == null) {
            throw new NullPointerException("String 'data' is null");
        }
        try {
            dataBytes = data.getBytes(CommonConstants.LOCALCCSID);
        }
        catch (UnsupportedEncodingException e) {
            dataBytes = data.getBytes();
        }
        this.validateByteArray(dataBytes);
        try {
            return DTCTSQ.WRITE(this.getQueueName(), dataBytes, this.getSysId(), this.getType().hashCode(), false);
        }
        catch (NoSpaceException NAE) {
            throw new CicsError("TSQ.writeString: NoSpaceException unexpected");
        }
    }

    public int writeItemConditional(byte[] data) throws InvalidRequestException, IOErrorException, ISCInvalidRequestException, ItemErrorException, LengthErrorException, NoSpaceException, NotAuthorisedException, InvalidSystemIdException {
        this.validateByteArray(data);
        return DTCTSQ.WRITE(this.getQueueName(), data, this.getSysId(), this.getType().hashCode(), true);
    }

    private void validateByteArray(byte[] data) throws LengthErrorException {
        if (data == null) {
            throw new NullPointerException("byte[] is null for TSQ: '" + this.getName() + "'");
        }
        if (data.length > 32763) {
            throw new LengthErrorException("Maximum data length of 32763 exceeded for TSQ '" + this.getName() + "'. Requested Length: " + data.length + ".");
        }
    }
}

