/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.common.CommonConstants;
import com.ibm.cics.common.CommonLogger;
import com.ibm.cics.server.API;
import com.ibm.cics.server.ApplicationContext;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.ChannelFactory;
import com.ibm.cics.server.ContainerIterator;
import com.ibm.cics.server.DTCTerminal;
import com.ibm.cics.server.EndOfDataException;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidRetrieveOptionException;
import com.ibm.cics.server.IsCICS;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.RetrieveBits;
import com.ibm.cics.server.RetrievedDataHolder;
import com.ibm.cics.server.RolledBackException;
import com.ibm.cics.server.TWAHolder;
import com.ibm.cics.server.Terminal;
import com.ibm.cics.server.TerminalOutputStream;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.BitSet;

public class Task
extends API
implements RetrieveBits {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2001, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String COMPONENT = Task.class.getPackage().getName();
    private static final String CLASS_NAME = Task.class.getSimpleName();
    public PrintWriter err;
    public PrintWriter out;
    public static PrintWriter fixedOutForJVMLifetime;
    public static PrintWriter fixedErrForJVMLifetime;
    public static final byte FCI_START_NO_DATA = 0;
    public static final byte FCI_TASK_WITH_FACILITY = 1;
    public static final byte FCI_TRIGGERED_NO_FACILITY = 8;
    public static final byte FCI_START_WITH_DATA = 16;
    private Object principalFacility;
    private byte FCI;
    private String QNAME;
    private String STARTCODE;
    private String PROGRAMNAME;
    private String INVOKINGPROG;
    private int TWAlength;
    private byte[] TWAP;
    private Channel transactionChannel;
    private boolean transactionChannelChecked;
    private Channel currentChannel;
    private boolean currentChannelChecked;
    private ChannelFactory chanFactory;
    private String transactionName;
    private int taskNumber;
    private Integer taskNumberInt;
    private byte[] originData;
    private byte[] transactionGroupID;
    private Thread taskThread;
    private int thread_position;
    private boolean isDB2Active;
    private boolean isJTATranActive;
    private static ThreadLocal<Task> theTask;
    private static ThreadLocal<String> debugPrefix;
    static final boolean taskTerminalOutputDisabled;

    Task() {
        super(false);
        if (Task.shouldTrace('D')) {
            Task.logEntry("constructor", 'D');
        }
        this.getCommonData();
        if (Task.shouldTrace('D')) {
            Task.logEvent("constructor", 'D', "getCommonData returned");
        }
        this.setTaskThread();
        if (!taskTerminalOutputDisabled && this.principalFacility instanceof Terminal) {
            if (Task.shouldTrace('D')) {
                Task.logEvent("constructor", 'D', "principalFacility is a Terminal");
            }
            try {
                TerminalOutputStream outStream = new TerminalOutputStream((Terminal)this.principalFacility);
                BufferedOutputStream BOS = new BufferedOutputStream(outStream);
                OutputStreamWriter OSW = new OutputStreamWriter((OutputStream)BOS, CommonConstants.LOCALCCSID);
                this.out = new PrintWriter((Writer)OSW, true);
                TerminalOutputStream errStream = new TerminalOutputStream((Terminal)this.principalFacility);
                OutputStreamWriter errOSW = new OutputStreamWriter((OutputStream)errStream, CommonConstants.LOCALCCSID);
                this.err = new PrintWriter((Writer)errOSW, true);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (this.out == null) {
            if (fixedOutForJVMLifetime == null) {
                fixedOutForJVMLifetime = new PrintWriter(System.out, true);
            }
            this.out = fixedOutForJVMLifetime;
        }
        if (this.err == null) {
            if (fixedErrForJVMLifetime == null) {
                fixedErrForJVMLifetime = new PrintWriter(System.err, true);
            }
            this.err = fixedOutForJVMLifetime;
        }
        if (Task.shouldTrace('D')) {
            Task.logExit("constructor", 'D');
        }
    }

    public void abend(String abcode) {
        this.abend(abcode, true);
    }

    private void setTaskThread() {
        this.taskThread = Thread.currentThread();
    }

    public Thread getTaskThread() {
        return this.taskThread;
    }

    public void setDB2SQLJJDBCActive(boolean active) {
        this.isDB2Active = active;
    }

    public boolean getDB2SQLJJDBCActive() {
        return this.isDB2Active;
    }

    public void abend(String abcode, boolean dump) {
        if (abcode == null) {
            throw new IllegalArgumentException("null abcode provided");
        }
        String abcodeLocal = abcode;
        if (abcodeLocal.length() < 4) {
            abcodeLocal = abcodeLocal.concat("    ");
        }
        if (abcodeLocal.length() > 4) {
            abcodeLocal = abcodeLocal.substring(0, 4);
        }
        this.Abend(abcodeLocal, false, dump);
    }

    public void abend() {
        this.Abend(null, false, false);
    }

    private final native void Abend(String var1, boolean var2, boolean var3);

    private final native void ADDRESS_TWA(TWAHolder var1, byte[] var2, int var3);

    public void commit() throws InvalidRequestException, RolledBackException {
        if (Task.shouldTrace('D')) {
            Task.logEntry("commit", 'D');
        }
        if (this.isJTATranActive) {
            if (Task.shouldTrace('D')) {
                Task.logEvent("commit", 'D', "Task.commit() has been issued in a JTA User Transaction and has been ignored.");
            }
            return;
        }
        this.commitTask();
        if (Task.shouldTrace('D')) {
            Task.logExit("commmit", 'D');
        }
    }

    private final native void commitTask() throws InvalidRequestException, RolledBackException;

    private final native void DISABLE_TASKTRACE();

    @Deprecated
    public void disableTaskTrace() {
        this.DISABLE_TASKTRACE();
    }

    private final native void ENABLE_TASKTRACE();

    @Deprecated
    public void enableTaskTrace() {
        this.ENABLE_TASKTRACE();
    }

    public void forceAbend(String abcode) {
        this.forceAbend(abcode, true);
    }

    public void forceAbend(String abcode, boolean dump) {
        this.Abend(abcode, true, dump);
    }

    public void forceAbend() {
        this.forceAbend(null, false);
    }

    private final native void getCommonData();

    public byte getFCI() {
        return this.FCI;
    }

    public Object getPrincipalFacility() {
        return this.principalFacility;
    }

    public String getQNAME() {
        return this.QNAME;
    }

    public String getSTARTCODE() {
        return this.STARTCODE;
    }

    protected int getThreadPosition() {
        return this.thread_position;
    }

    public Channel getTransactionChannel() {
        if (!this.transactionChannelChecked) {
            try {
                this.transactionChannel = new Channel("DFHTRANSACTION");
            }
            catch (ChannelErrorException channelErrorException) {
                // empty catch block
            }
            this.transactionChannelChecked = true;
        }
        return this.transactionChannel;
    }

    public Channel getCurrentChannel() {
        if (Task.shouldTrace('D')) {
            Task.logEntry("getCurrentChannel", 'D');
        }
        if (!this.currentChannelChecked) {
            String ccName = null;
            try {
                ccName = this.GETCURRENTCHANNEL();
            }
            catch (InvalidRequestException ire) {
                // empty catch block
            }
            if (ccName != null) {
                if (ccName.startsWith(" ")) {
                    ccName = null;
                } else {
                    try {
                        this.currentChannel = new Channel(ccName);
                    }
                    catch (ChannelErrorException channelErrorException) {
                        // empty catch block
                    }
                }
            }
            this.currentChannelChecked = true;
        }
        if (Task.shouldTrace('D')) {
            Task.logExit("getCurrentChannel", 'D');
        }
        return this.currentChannel;
    }

    private native String GETCURRENTCHANNEL() throws InvalidRequestException;

    public Channel createChannel(String channelName) throws ChannelErrorException {
        return this.createChannel(channelName, 16);
    }

    public Channel createChannel(String channelName, int listSize) throws ChannelErrorException {
        if (this.chanFactory == null) {
            this.chanFactory = new ChannelFactory(this.getCurrentChannel());
        }
        return this.chanFactory.createChannel(channelName, listSize);
    }

    void removeChannel(Channel channel) {
        this.chanFactory.remove(channel);
    }

    public Channel getChannel(String channelName) {
        if (this.chanFactory == null) {
            this.chanFactory = new ChannelFactory(this.getCurrentChannel());
        }
        return this.chanFactory.getChannel(channelName);
    }

    protected Channel returnChannel(String channelName) throws ChannelErrorException {
        return this.chanFactory.returnChannel(channelName);
    }

    public ContainerIterator containerIterator() {
        if (this.getCurrentChannel() != null) {
            return this.currentChannel.containerIterator();
        }
        return null;
    }

    public static Task getTask() {
        Task t;
        if (Task.shouldTrace('D')) {
            Task.logEntry("getTask", 'D');
        }
        if ((t = theTask.get()) == null) {
            if (Task.shouldTrace('D')) {
                Task.logEvent("getTask", 'D', "Task is null");
            }
            if (CommonConstants.THREADPOOL_ACTIVE) {
                IsCICS.getApiStatus(true);
                t = theTask.get();
            }
            if (t == null) {
                t = new Task();
                theTask.set(t);
            }
        } else if (Task.shouldTrace('D')) {
            Task.logEvent("getTask", 'D', "Task is not null");
        }
        if (Task.shouldTrace('D')) {
            Task.logExit("getTask", 'D');
        }
        return t;
    }

    public int getTaskNumber() {
        return this.taskNumber;
    }

    public Integer getTaskNumberInteger() {
        if (this.taskNumberInt == null) {
            this.taskNumberInt = new Integer(this.taskNumber);
        }
        return this.taskNumberInt;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public void getTWA(TWAHolder holder) {
        if (holder == null) {
            throw new NullPointerException("null holder in Task.getTWA()");
        }
        if (this.TWAlength == 0) {
            holder.value = new byte[0];
        } else {
            this.ADDRESS_TWA(holder, this.TWAP, this.TWAlength);
        }
    }

    public String getUSERID() throws InvalidRequestException {
        if (Task.shouldTrace('D')) {
            Task.logEntryExit("getUSERID", 'D', "");
        }
        return DTCTerminal.getUserId();
    }

    public String getProgramName() {
        return this.PROGRAMNAME;
    }

    public String getInvokingProgramName() {
        return this.INVOKINGPROG;
    }

    public ApplicationContext getApplicationContext() throws InvalidRequestException {
        ApplicationContext appC = this.GETCONTEXT();
        return appC;
    }

    private final native ApplicationContext GETCONTEXT() throws InvalidRequestException;

    static void resetTask() {
        if (Task.shouldTrace('D')) {
            Task.logEntry("resetTask", 'D');
        }
        if (theTask.get() != null) {
            if (Task.shouldTrace('D')) {
                Task.logEvent("resetTask", 'D', "Task object = " + theTask.get());
            }
            theTask.remove();
        } else if (Task.shouldTrace('D')) {
            Task.logEvent("resetTask", 'D', "Task object = null");
        }
        if (Task.shouldTrace('D')) {
            Task.logExit("resetTask", 'D');
        }
    }

    public void retrieve(BitSet whatToRetrieve, RetrievedDataHolder holder) throws EndOfDataException, InvalidRequestException, InvalidRetrieveOptionException, IOErrorException, LengthErrorException, RecordNotFoundException {
        boolean data = false;
        boolean rTransId = false;
        boolean rTermId = false;
        boolean queue = false;
        data = whatToRetrieve.get(0);
        rTransId = whatToRetrieve.get(1);
        rTermId = whatToRetrieve.get(2);
        queue = whatToRetrieve.get(3);
        this.RETRIEVE(data, rTransId, rTermId, queue, holder);
    }

    private final native void RETRIEVE(boolean var1, boolean var2, boolean var3, boolean var4, RetrievedDataHolder var5) throws EndOfDataException, InvalidRequestException, InvalidRetrieveOptionException, IOErrorException, LengthErrorException, RecordNotFoundException;

    public void rollback() throws InvalidRequestException {
        if (Task.shouldTrace('D')) {
            Task.logEntryExit("rollback", 'D', "");
        }
        if (this.isJTATranActive) {
            if (Task.shouldTrace('D')) {
                Task.logEvent("rollback", 'D', "Task.rollback() has been issued in a JTA User Transaction and has been ignored.");
            }
            return;
        }
        this.rollbackTask();
    }

    private final native void rollbackTask() throws InvalidRequestException;

    public void setTWA(byte[] data) throws InvalidRequestException {
        if (data == null) {
            throw new NullPointerException("null data in setTWA()");
        }
        if (this.TWAlength == 0) {
            throw new InvalidRequestException("No TWA to update");
        }
        this.UPDATE_TWA(data, this.TWAP, this.TWAlength);
    }

    private final native void UPDATE_TWA(byte[] var1, byte[] var2, int var3);

    public void setJTATranActive(boolean setJTATran) {
        this.isJTATranActive = setJTATran;
    }

    protected void setOriginData(byte[] taskOriginData, byte[] transactionGroupID) {
        this.originData = taskOriginData;
        this.transactionGroupID = transactionGroupID;
    }

    protected byte[] getOriginData() {
        return this.originData;
    }

    protected byte[] getTransactionGroupID() {
        return this.transactionGroupID;
    }

    public String getThreadName() {
        StringBuilder sb = new StringBuilder(64);
        if (this.PROGRAMNAME != null) {
            sb.append(this.PROGRAMNAME.trim());
            sb.append('.');
        }
        sb.append("TASK");
        sb.append(this.taskNumber);
        sb.append('.');
        sb.append(this.transactionName);
        return sb.toString();
    }

    private static void logEntry(String theMethod, char level) {
        CommonLogger.logEntry((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)"", null);
    }

    private static void logEntry(String theMethod, char level, String msg) {
        CommonLogger.logEntry((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)msg, null);
    }

    private static void logExit(String theMethod, char level) {
        CommonLogger.logExit((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)"", null);
    }

    private static void logExit(String theMethod, char level, String msg) {
        CommonLogger.logExit((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)msg, null);
    }

    private static void logEvent(String theMethod, char level, String message) {
        CommonLogger.logEvent((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)message, null);
    }

    private static void logError(String theMethod, char level, String message, Throwable t) {
        CommonLogger.logError((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)message, (Throwable)t);
    }

    private static void logEntryExit(String theMethod, char level, String message) {
        CommonLogger.logEntryExit((String)COMPONENT, (String)CLASS_NAME, (String)theMethod, (char)level, (String)message, null);
    }

    private static final boolean shouldTrace(char level) {
        return CommonLogger.shouldTrace((char)level);
    }

    public boolean isJTATranActive() {
        return this.isJTATranActive;
    }

    static {
        theTask = new ThreadLocal();
        debugPrefix = new ThreadLocal();
        taskTerminalOutputDisabled = System.getProperty("com.ibm.cics.server.disableStandardTerminalOutput") != null ? System.getProperty("com.ibm.cics.server.disableStandardTerminalOutput").equalsIgnoreCase("true") : false;
    }
}

