/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.InvalidRequestException;

class TcpipInfo
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NOTSET = -1;
    private String clientName;
    private String serverName;
    private String clientAddr;
    private String serverAddr;
    private byte[] clientAddrNu;
    private byte[] serverAddrNu;
    private byte[] clntAddr6Nu;
    private byte[] srvrAddr6Nu;
    private int clntIpFamily = -1;
    private int srvrIpFamily = -1;
    private int sslType = -1;
    private String tcpipService;
    private int portNumNu = -1;
    private int authenticate = -1;
    private int privacy = -1;
    private int maxDataLen = -1;

    private native void EXTRACT(boolean var1) throws InvalidRequestException;

    TcpipInfo() {
    }

    public String getClientHostName() throws InvalidRequestException {
        if (this.clientName == null) {
            this.EXTRACT(true);
        }
        return this.clientName;
    }

    public String getServerHostName() throws InvalidRequestException {
        if (this.serverName == null) {
            this.EXTRACT(true);
        }
        return this.serverName;
    }

    public String getClientAddress() throws InvalidRequestException {
        if (this.clientAddr == null) {
            this.EXTRACT(true);
        }
        return this.clientAddr;
    }

    public String getServerAddress() throws InvalidRequestException {
        if (this.serverAddr == null) {
            this.EXTRACT(true);
        }
        return this.serverAddr;
    }

    public byte[] getClientHostAddress() throws InvalidRequestException {
        if (this.clientAddrNu == null) {
            this.EXTRACT(false);
        }
        return this.clientAddrNu;
    }

    public byte[] getServerHostAddress() throws InvalidRequestException {
        if (this.serverAddrNu == null) {
            this.EXTRACT(false);
        }
        return this.serverAddrNu;
    }

    public byte[] getClientHostAddress6() throws InvalidRequestException {
        if (this.clntAddr6Nu == null) {
            this.EXTRACT(false);
        }
        return this.clntAddr6Nu;
    }

    public byte[] getServerHostAddress6() throws InvalidRequestException {
        if (this.srvrAddr6Nu == null) {
            this.EXTRACT(false);
        }
        return this.srvrAddr6Nu;
    }

    public int getClientIpFamily() throws InvalidRequestException {
        if (this.clntIpFamily == -1) {
            this.EXTRACT(false);
        }
        return this.clntIpFamily;
    }

    public int getServerIpFamily() throws InvalidRequestException {
        if (this.srvrIpFamily == -1) {
            this.EXTRACT(false);
        }
        return this.srvrIpFamily;
    }

    public boolean isSSL() throws InvalidRequestException {
        if (this.sslType == -1) {
            this.EXTRACT(false);
        }
        return this.sslType != 1031;
    }

    public boolean isClientAuth() throws InvalidRequestException {
        if (this.sslType == -1) {
            this.EXTRACT(false);
        }
        return this.sslType == 1032;
    }

    public String getTcpipService() throws InvalidRequestException {
        if (this.tcpipService == null) {
            this.EXTRACT(false);
        }
        return this.tcpipService;
    }

    public int getPortNumber() throws InvalidRequestException {
        if (this.portNumNu == -1) {
            this.EXTRACT(false);
        }
        return this.portNumNu;
    }

    public int getAuthenticate() throws InvalidRequestException {
        if (this.authenticate == -1) {
            this.EXTRACT(true);
        }
        return this.authenticate;
    }

    public int getPrivacy() throws InvalidRequestException {
        if (this.privacy == -1) {
            this.EXTRACT(false);
        }
        return this.privacy;
    }

    public int getMaxDataLen() throws InvalidRequestException {
        if (this.maxDataLen == -1) {
            this.EXTRACT(false);
        }
        return this.maxDataLen;
    }

    protected void resetObject() {
        this.clientName = null;
        this.serverName = null;
        this.clientAddr = null;
        this.serverAddr = null;
        this.clientAddrNu = null;
        this.serverAddrNu = null;
        this.clntAddr6Nu = null;
        this.srvrAddr6Nu = null;
        this.clntIpFamily = -1;
        this.srvrIpFamily = -1;
        this.sslType = -1;
        this.tcpipService = null;
        this.portNumNu = -1;
        this.authenticate = -1;
        this.privacy = -1;
        this.maxDataLen = -1;
    }
}

