/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.ras.server.TidyUpOnTermination;
import com.ibm.cics.ras.server.WrapperHelper;
import com.ibm.cics.server.API;
import com.ibm.cics.server.CertificateInfo;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.ChannelErrorException;
import com.ibm.cics.server.Container;
import com.ibm.cics.server.ContainerErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NonHttpDataException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.Task;
import com.ibm.cics.server.TcpipInfo;
import com.ibm.cics.server.WebReceive;

public class TcpipRequest
extends API
implements TidyUpOnTermination {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Integer NOTSET = -1;
    private static ThreadLocal<CertificateInfo> CInfo = new ThreadLocal();
    private static ThreadLocal<TcpipInfo> TInfo = new ThreadLocal();
    private static ThreadLocal<WebReceive> WRecv = new ThreadLocal();
    private static ThreadLocal<TcpipRequest> _trq = new ThreadLocal();
    private static ThreadLocal<Integer> lastCertExtract = new ThreadLocal();
    public static final int NOTAPPLIC = 1;
    public static final int IPV4 = 300;
    public static final int IPV6 = 301;
    public static final int SSL = 1030;
    public static final int NOSSL = 1031;
    public static final int CLIENTAUTH = 1032;
    public static final int NOAUTHENTIC = 1091;
    public static final int BASICAUTH = 1092;
    public static final int CERTIFICAUTH = 1093;
    public static final int AUTOREGISTER = 1094;
    public static final int AUTOAUTH = 1095;
    public static final int SUPPORTED = 1106;
    public static final int REQUIRED = 666;
    public static final int NOTSUPPORTED = 15;
    private static final int RESP2_NO_CURRENT_CHANNEL = 145;
    private static final int RESP2_CONTAINER_NAME_INVALID = 1;
    private static final int RESP2_CHANNEL_NAME_INVALID = 1;
    private static boolean registeredWithWrapper;

    protected TcpipRequest() {
        lastCertExtract.set(NOTSET);
        if (!registeredWithWrapper) {
            registeredWithWrapper = true;
            WrapperHelper.registerTerminator((TidyUpOnTermination)this);
        }
    }

    public static TcpipRequest getTcpipRequestInstance() {
        if (_trq.get() == null) {
            _trq.set(new TcpipRequest());
        }
        return _trq.get();
    }

    public CertificateInfo getCertificateInfo() throws InvalidRequestException {
        return this.getCertificateInfo(1);
    }

    public CertificateInfo getCertificateInfo(int ownerIssuer) throws InvalidRequestException {
        if (CInfo.get() == null || lastCertExtract.get() != ownerIssuer) {
            CInfo.set(new CertificateInfo(ownerIssuer));
            lastCertExtract.set(ownerIssuer);
        }
        return CInfo.get();
    }

    public String getClientHostName() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getClientHostName();
    }

    public String getServerHostName() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getServerHostName();
    }

    public String getClientAddress() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getClientAddress();
    }

    public String getServerAddress() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getServerAddress();
    }

    public byte[] getClientHostAddress() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getClientHostAddress();
    }

    public byte[] getServerHostAddress() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getServerHostAddress();
    }

    public byte[] getClientHostAddress6() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getClientHostAddress6();
    }

    public byte[] getServerHostAddress6() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getServerHostAddress6();
    }

    public int getClientIpFamily() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getClientIpFamily();
    }

    public int getServerIpFamily() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getServerIpFamily();
    }

    public boolean isSSL() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().isSSL();
    }

    public boolean isClientAuth() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().isClientAuth();
    }

    public String getTcpipService() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getTcpipService();
    }

    public int getPortNumber() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getPortNumber();
    }

    public int getAuthenticate() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getAuthenticate();
    }

    public int getPrivacy() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getPrivacy();
    }

    public int getMaxDataLen() throws InvalidRequestException {
        if (TInfo.get() == null) {
            TInfo.set(new TcpipInfo());
        }
        return TInfo.get().getMaxDataLen();
    }

    public void setServerConvert() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setServerConvert();
    }

    public void setNoServerConvert() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setNoServerConvert();
    }

    public void setClientCodePage(String characterset) {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        characterset = this.spacePad(characterset, 40);
        WRecv.get().setCharacterset(characterset);
    }

    public void setCharacterset(String characterset) {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        characterset = this.spacePad(characterset, 40);
        WRecv.get().setCharacterset(characterset);
    }

    public void setHostCodePage(String hostCodePage) {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        hostCodePage = this.spacePad(hostCodePage, 8);
        WRecv.get().setHostCodePage(hostCodePage);
    }

    public void setNoTruncate() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setNoTruncate();
    }

    public void setTruncate() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setTruncate();
    }

    public void setMaxLength(int maxLength) throws LengthErrorException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        if (maxLength < 1) {
            throw new LengthErrorException("maxLength not greater than 0");
        }
        WRecv.get().setMaxLength(maxLength);
    }

    public byte[] getContent(String hostCodePage, String characterset) throws InvalidRequestException, RecordNotFoundException, NonHttpDataException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        hostCodePage = this.spacePad(hostCodePage, 8);
        WRecv.get().setHostCodePage(hostCodePage);
        characterset = this.spacePad(characterset, 40);
        WRecv.get().setCharacterset(characterset);
        WRecv.get().setNonHttpDataExceptionNo();
        return WRecv.get().receive();
    }

    public byte[] getContent() throws InvalidRequestException, RecordNotFoundException, NonHttpDataException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        WRecv.get().setNonHttpDataExceptionNo();
        return WRecv.get().receive();
    }

    public Container getContentAsContainer(String toContainer, String toChannel) throws InvalidRequestException, RecordNotFoundException, ChannelErrorException, ContainerErrorException {
        Channel chan;
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        if (toContainer == null) {
            throw new ContainerErrorException("Null toContainer", 1);
        }
        if (toChannel == null) {
            throw new ChannelErrorException("Null toChannel", 1);
        }
        toContainer = this.spacePad(toContainer, 16);
        toChannel = this.spacePad(toChannel, 16);
        WRecv.get().receiveContainer(toContainer, toChannel);
        Task t = Task.getTask();
        if (t == null) {
            throw new InvalidRequestException("Task.getTask failed");
        }
        try {
            chan = t.createChannel(toChannel);
        }
        catch (Exception e) {
            chan = t.returnChannel(toChannel);
        }
        Container cont = chan.returnContainer(toContainer);
        cont.setDataInCICS();
        return cont;
    }

    public Container getContentAsContainer(String toContainer) throws InvalidRequestException, RecordNotFoundException, ChannelErrorException, ContainerErrorException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        if (toContainer == null) {
            throw new ContainerErrorException("Null toContainer", 1);
        }
        toContainer = this.spacePad(toContainer, 16);
        Task t = Task.getTask();
        Channel chan = t.getCurrentChannel();
        if (chan == null) {
            throw new InvalidRequestException("No current channel", 145);
        }
        WRecv.get().receiveContainer(toContainer, chan.getName());
        Container cont = chan.returnContainer(chan.getName());
        cont.setDataInCICS();
        return cont;
    }

    public boolean isBodyComplete() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().isBodyComplete();
    }

    public boolean isBodyTruncated() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().isBodyTruncated();
    }

    public boolean isBodyPartial() {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().isBodyPartial();
    }

    public String getBodyCharset() throws InvalidRequestException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().getBodyCharset();
    }

    public String getMediaType() throws InvalidRequestException {
        if (WRecv.get() == null) {
            WRecv.set(new WebReceive());
        }
        return WRecv.get().getMediaType();
    }

    private String spacePad(String dataIn, int newLength) {
        if (dataIn == null) {
            return null;
        }
        StringBuilder dataOut = new StringBuilder(newLength);
        dataOut.append(dataIn);
        if (newLength > 0) {
            int spaces = newLength - dataIn.length();
            for (int i = 0; i < spaces; ++i) {
                dataOut.append(" ");
            }
            return dataOut.toString();
        }
        return dataIn;
    }

    private static boolean ibmJVMTidyUp() {
        if (TInfo.get() != null) {
            TInfo.get().resetObject();
            TInfo.remove();
        }
        if (CInfo.get() != null) {
            CInfo.get().resetObject();
            CInfo.remove();
        }
        if (WRecv.get() != null) {
            WRecv.get().resetObject();
            WRecv.remove();
        }
        lastCertExtract.set(NOTSET);
        return true;
    }

    public void drive_ibmJVMTidyUp() {
        TcpipRequest.ibmJVMTidyUp();
    }
}

