/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.Channel;
import com.ibm.cics.server.Cursor;
import com.ibm.cics.server.DTCTerminal;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidTerminalIdException;

public class Terminal
extends API {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2002, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String terminalName;
    protected Cursor cursor;
    private byte[] nextCOMMAREA;
    private String nextTransaction;
    private Channel nextChannel;

    public Terminal(String name) throws NullPointerException, InvalidTerminalIdException {
        if (name == null) {
            throw new NullPointerException("null terminal name");
        }
        if (name.length() == 0) {
            throw new InvalidTerminalIdException("empty terminal name", 0);
        }
        this.terminalName = name;
        this.cursor = new Cursor(80, 24);
    }

    public Terminal(String name, String NETNAME) throws NullPointerException, InvalidTerminalIdException {
        this(name);
        if (NETNAME == null) {
            throw new NullPointerException("null terminal NETNAME");
        }
        if (NETNAME.length() == 0) {
            throw new InvalidTerminalIdException("empty terminal NETNAME", 0);
        }
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public String getName() {
        return this.terminalName;
    }

    protected byte[] getNextCOMMAREA() {
        return this.nextCOMMAREA;
    }

    protected Channel getNextChannel() {
        return this.nextChannel;
    }

    protected String getNextTransaction() {
        return this.nextTransaction;
    }

    public String getUser() throws InvalidRequestException {
        return DTCTerminal.getUserId();
    }

    protected void setNextCOMMAREA(byte[] nextCOMMAREA) {
        this.nextCOMMAREA = nextCOMMAREA;
    }

    protected void setNextTransaction(String nextTransaction) {
        this.nextTransaction = nextTransaction;
    }

    protected void setNextChannel(Channel nextChan) {
        this.nextChannel = nextChan;
    }
}

